/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryBlockHeaderInfosRequest
extends Request {
    private BigInteger blockNumber = BigInteger.ZERO;
    private Hash hash = new Hash();
    private long maxAmount = 0L;
    private int reverse = 0;

    public QueryBlockHeaderInfosRequest() {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER_INFOS);
    }

    public QueryBlockHeaderInfosRequest(long maxAmount, int reverse) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER_INFOS);
        this.maxAmount = maxAmount;
        this.reverse = reverse;
    }

    public QueryBlockHeaderInfosRequest(BigInteger blockNumber, long maxAmount) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER_INFOS);
        this.blockNumber = blockNumber;
        this.maxAmount = maxAmount;
    }

    public QueryBlockHeaderInfosRequest(Hash hash, long maxAmount, int reverse) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER_INFOS);
        this.hash = hash;
        this.maxAmount = maxAmount;
        this.reverse = reverse;
    }

    public QueryBlockHeaderInfosRequest(BigInteger blockNumber, long maxAmount, int reverse) {
        super(MessageType.MSG_TYPE_QUERY_REQ_BLOCK_HEADER_INFOS);
        this.blockNumber = blockNumber;
        this.maxAmount = maxAmount;
        this.reverse = reverse;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    public long getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(long maxAmount) {
        this.maxAmount = maxAmount;
    }

    public int getReverse() {
        return this.reverse;
    }

    public void setReverse(int reverse) {
        this.reverse = reverse;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.maxAmount > 0L && (this.hash != null && !this.hash.hexStrValue().equalsIgnoreCase(Hash.ZERO.hexStrValue()) || this.blockNumber != null) && this.blockNumber.compareTo(BigInteger.ZERO) >= 0;
    }

    @Override
    public byte[] toRlp() {
        byte[] block_number = Rlp.encodeBigInteger(this.blockNumber);
        byte[] block_hash = Rlp.encodeElement(this.hash.getValue());
        byte[] max_amount = Rlp.encodeLong(this.maxAmount);
        byte[] is_reverse = Rlp.encodeInt(this.reverse);
        return Rlp.encodeList(super.toRlp(), block_number, block_hash, max_amount, is_reverse);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.hash = new Hash(((RlpElement)list.get(2)).getRlpData());
        this.maxAmount = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
        this.reverse = ByteUtils.byteArrayToInt(((RlpElement)list.get(4)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("block_number", (Object)this.blockNumber);
        jsonObject.put("block_hash", (Object)ByteUtils.toHexString(this.hash.getValue()));
        jsonObject.put("max_amount", (Object)this.maxAmount);
        jsonObject.put("reverse", (Object)this.reverse);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.hash = new Hash(jsonObject.getString("block_hash"));
        this.maxAmount = jsonObject.getLong("max_amount");
        this.reverse = jsonObject.getIntValue("reverse");
    }
}

