/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.domain.account.AuthMap;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;

public class ResetPubKeyRequest
extends AbstractTransactionRequest {
    private Identity acctId;
    private AuthMap authMap;

    public ResetPubKeyRequest(Identity acctId, AuthMap authMap) {
        super(MessageType.MSG_TYPE_TX_REQ_RESET_PUB_KEY);
        this.acctId = acctId;
        this.authMap = authMap;
    }

    public ResetPubKeyRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_RESET_PUB_KEY);
    }

    public Identity getAcctId() {
        return this.acctId;
    }

    public AuthMap getAuthMap() {
        return this.authMap;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.acctId == null || this.acctId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue())) {
            return false;
        }
        return this.authMap != null && this.authMap.getAuthMap() != null && !this.authMap.getAuthMap().isEmpty() && this.authMap.isValid();
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.RESET_PUB_KEY);
        transaction.setFrom(this.acctId);
        transaction.setTo(this.acctId);
        transaction.setData(this.authMap.toRlp());
        super.complete();
    }
}

