/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network;

import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.callback.IConnectionCallback;
import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.env.ISslOption;
import com.alipay.mychain.sdk.api.env.NetworkOption;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.codec.CodecFactory;
import com.alipay.mychain.sdk.codec.ICodec;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.errorcode.IErrorCode;
import com.alipay.mychain.sdk.message.MessageFactory;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.network.ChannelStatus;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.network.MessageContext;
import com.alipay.mychain.sdk.network.MessageProcessor;
import com.alipay.mychain.sdk.network.MsgTimeoutTask;
import com.alipay.mychain.sdk.network.NetworkConnection;
import com.alipay.mychain.sdk.network.SequenceGenerator;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class ClientNetwork
implements INetwork {
    private SequenceGenerator sequenceGenerator;
    private MessageProcessor messageProcessor;
    private NetworkConnection connection;
    private ILogger logger;
    private TimerTaskManager timerTaskManager;

    @Override
    public boolean startup(NetworkOption networkOption, ISslOption sslOption, TimerTaskManager timerTaskManager, ILogger logger) {
        if (timerTaskManager == null) {
            return false;
        }
        this.timerTaskManager = timerTaskManager;
        this.logger = logger;
        this.sequenceGenerator = new SequenceGenerator();
        ICodec codec = CodecFactory.getCodec(networkOption.getCodecType());
        this.messageProcessor = new MessageProcessor(this.timerTaskManager, networkOption, codec, logger);
        boolean result = this.messageProcessor.start();
        if (!result) {
            return false;
        }
        this.connection = new NetworkConnection(networkOption, sslOption, codec, this.messageProcessor, logger);
        this.connection.start();
        Long connectionEndTime = System.currentTimeMillis() + (long)networkOption.getConnectTimeoutMs().intValue();
        result = this.connection.connect(connectionEndTime);
        if (!result) {
            return false;
        }
        this.messageProcessor.setNetworkConnection(this.connection);
        return true;
    }

    @Override
    public boolean shutDown() {
        if (this.connection != null) {
            this.connection.disConnect();
            this.connection.stop();
        }
        if (this.messageProcessor != null) {
            this.messageProcessor.stop();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response sendSyncRequest(Request request, Hash hash, int timeout) {
        if (this.connection == null) {
            return (Response)MessageFactory.getResponse(request, ErrorCode.SDK_NOT_CONNECTED);
        }
        request.setSequenceId(this.sequenceGenerator.getSequence());
        MessageContext context = new MessageContext(MessageContext.RequestType.SYNC_REQUEST);
        context.setRequest(request);
        boolean result = this.messageProcessor.saveContext(context);
        if (!result) {
            IErrorCode errorCode = ErrorCode.SDK_INTERNAL_ERROR;
            if (context.getResponse() != null && ErrorCode.SUCCESS != context.getResponse().getErrorCode()) {
                errorCode = context.getResponse().getErrorCode();
            }
            return (Response)MessageFactory.getResponse(request, errorCode);
        }
        Long taskId = 0L;
        ErrorCode errCode = ErrorCode.SUCCESS;
        try {
            MsgTimeoutTask task = new MsgTimeoutTask(this.messageProcessor, request, hash, this, this.logger, timeout);
            taskId = this.timerTaskManager.registerTask(task);
            context.setTaskId(taskId);
            context.getLock().lock();
            Long connectionEndTime = System.currentTimeMillis() + (long)timeout;
            result = this.connection.sendRequest(request, connectionEndTime);
            if (!result) {
                errCode = ErrorCode.SDK_NOT_CONNECTED;
                this.logger.warn("sendSyncRequest, sdk not connected.");
            } else {
                result = context.getCondition().await(timeout, TimeUnit.MILLISECONDS);
                if (!result) {
                    this.logger.debug("sendSyncRequest, sdk timeout.");
                    errCode = ErrorCode.SDK_TIMED_OUT;
                }
            }
        }
        catch (Throwable e) {
            this.logger.error("caught exception: cause{}\n{}", (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e.getCause()));
            result = false;
            errCode = ErrorCode.SDK_INTERNAL_ERROR;
        }
        finally {
            if (taskId != 0L) {
                this.timerTaskManager.unRegisterTask(taskId);
            }
            context.getLock().unlock();
        }
        this.messageProcessor.getContext(request.getSequenceId());
        if (!result) {
            return (Response)MessageFactory.getResponse(request, errCode);
        }
        return context.getResponse();
    }

    @Override
    public int sendAsyncRequest(Request request, Hash hash, IAsyncCallback callback, int timeout) {
        ErrorCode errorCode = ErrorCode.SDK_INTERNAL_ERROR;
        if (this.connection == null) {
            return errorCode.getErrorCode();
        }
        request.setSequenceId(this.sequenceGenerator.getSequence());
        MessageContext context = new MessageContext(MessageContext.RequestType.ASYNC_REQUEST);
        context.setRequest(request);
        context.setCallback(callback);
        boolean result = this.messageProcessor.saveContext(context);
        if (!result) {
            if (context.getResponse() != null && ErrorCode.SUCCESS != context.getResponse().getErrorCode()) {
                return context.getResponse().getErrorCode().getErrorCode();
            }
            return errorCode.getErrorCode();
        }
        MsgTimeoutTask task = new MsgTimeoutTask(this.messageProcessor, request, hash, this, this.logger, timeout);
        Long taskId = this.timerTaskManager.registerTask(task);
        context.setTaskId(taskId);
        Long connectionEndTime = System.currentTimeMillis() + (long)timeout;
        result = this.connection.sendRequest(request, connectionEndTime);
        if (!result) {
            this.timerTaskManager.unRegisterTask(taskId);
        }
        if (!result) {
            this.messageProcessor.getContext(request.getSequenceId());
            return errorCode.getErrorCode();
        }
        return ErrorCode.SUCCESS.getErrorCode();
    }

    @Override
    public boolean registerConnectionEventHandler(IConnectionCallback eventHandler) {
        return this.connection != null && this.connection.registerEventHandler(eventHandler);
    }

    @Override
    public boolean registerEventHandler(MessageType type, IEventCallback eventCallback) {
        return this.messageProcessor != null && this.messageProcessor.registerEventHandler(type, eventCallback);
    }

    @Override
    public boolean unRegisterEventHandler(MessageType type) {
        return this.messageProcessor != null && this.messageProcessor.unRegisterEventHandler(type);
    }

    @Override
    public long getLastActiveTime() {
        if (this.connection == null) {
            return 0L;
        }
        return this.connection.getLastActiveTime();
    }

    @Override
    public void checkAndSetStatus(ChannelStatus status) {
        if (this.connection == null) {
            return;
        }
        this.logger.debug("checkAndSetStatus, check and update status.");
        this.connection.checkAndSetStatus(status);
    }

    @Override
    public long getSystemTimestamp() {
        if (this.connection == null) {
            return System.currentTimeMillis();
        }
        return this.connection.getSystemTimestamp();
    }
}

