/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto;

import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.crypto.ecdsa.ECSignUtils;
import com.alipay.mychain.zoro.crypto.ecdsa.SignatureData;
import com.alipay.mychain.zoro.crypto.keymanagement.KeyManagement;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;

public class AlgorithmService {
    private static final Logger logger = Logger.getLogger(AlgorithmService.class.getName());
    private static final int BYTE_BIT_LEN = 8;
    private static final int MAX_RSA_LEN = 256;
    private static final String ALGO_RSA = "RSA/ECB/PKCS1Padding";
    private static final ThreadLocal<Cipher> RSA;
    private static final String ALGO_ECDSA = "SHA256withECDSA";
    private static final String ALGO_AES_GCM = "AES/GCM/NoPadding";
    public static final int SPEC_AES_KEY_BYTE_LEN = 32;
    private static final int SPEC_AES_GCM_TAG_BYTE_LEN = 16;
    public static final int SPEC_AES_GCM_NONCE_BYTE_LEN = 12;
    private static final ThreadLocal<Cipher> AESGCM;
    private static final String ALGO_SHA = "SHA-256";
    private static final ThreadLocal<MessageDigest> SHA;
    private static final ThreadLocal<SecureRandom> RANDOM;

    public static void initJceSecurityPolicy() throws CryptoException {
        if (Double.parseDouble(System.getProperty("java.specification.version")) <= 1.8) {
            try {
                Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
                field.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                field.set(null, false);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                String errorMsg = "Failed to set JCE security policy";
                logger.log(Level.SEVERE, errorMsg);
                logger.log(Level.SEVERE, ex.getMessage());
                throw new CryptoException(errorMsg);
            }
        }
    }

    public static byte[] rsa2048Encrypt(RSAPublicKey pubkey, byte[] message) throws CryptoException, InvalidKeyException, BadPaddingException {
        if (256 != (pubkey.getModulus().bitLength() + 8 - 1) / 8) {
            throw new CryptoException("Not an RSA2048 instance.");
        }
        try {
            Cipher rsa = RSA.get();
            rsa.init(1, pubkey);
            return rsa.doFinal(message);
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("RSA2048 encryption key format error.", e);
        }
        catch (BadPaddingException e) {
            throw new BadPaddingException("RSA2048 bad padding." + e);
        }
        catch (Exception e) {
            RSA.remove();
            throw new CryptoException("RSA2048 encryption error.", e);
        }
    }

    public static boolean ecdsaVerify(ECPublicKey pubkey, byte[] message, byte[] sigval) throws SignatureException, InvalidKeyException, CryptoException {
        if (sigval.length != 65) {
            throw new CryptoException("Error in sig verify, signature length should be 65.");
        }
        if (!KeyManagement.checkECParameter(pubkey.getParams())) {
            throw new InvalidKeyException("ECDSA verify public key is NOT for secp256k1.");
        }
        try {
            byte[] hashMessage = AlgorithmService.sha256(message);
            SignatureData signatureData = SignatureData.decode(sigval);
            BigInteger recPubKey = ECSignUtils.signedMessageToKey(hashMessage, signatureData);
            ECPoint q = ECSignUtils.CURVE.getCurve().createPoint(pubkey.getW().getAffineX(), pubkey.getW().getAffineY());
            byte[] qBytes = q.getEncoded(false);
            BigInteger originalPubKey = new BigInteger(1, Arrays.copyOfRange(qBytes, 1, qBytes.length));
            return recPubKey.equals(originalPubKey);
        }
        catch (SignatureException e) {
            throw new SignatureException("ECDSA verify Signatures Format error.", e);
        }
        catch (Exception e) {
            throw new CryptoException("ECDSA verify exception.", e);
        }
    }

    public static byte[] aes256GCM(int opmode, byte[] key, byte[] iv, byte[] input) throws CryptoException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (key.length != 32) {
            logger.log(Level.INFO, "aes gcm encrypt key MUST be 256 bits.");
            throw new CryptoException("aes gcm encrypt key MUST be 256 bits.");
        }
        if (iv.length != 12) {
            throw new CryptoException("aes gcm iv must be 96 bits");
        }
        try {
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            GCMParameterSpec s = new GCMParameterSpec(128, iv);
            if (opmode == 1) {
                byte[] iv4Jump = new byte[16];
                GCMParameterSpec s4Jump = new GCMParameterSpec(128, iv4Jump);
                Cipher c4Jump = AESGCM.get();
                c4Jump.init(1, (Key)skey, s4Jump);
                Cipher c = AESGCM.get();
                c.init(1, (Key)skey, s);
                return c.doFinal(input);
            }
            if (opmode == 2) {
                Cipher c = AESGCM.get();
                c.init(2, (Key)skey, s);
                return c.doFinal(input);
            }
            throw new CryptoException("aes gcm opcode must be 1(Enc) and 2(Dec).");
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeyException("aes gcm key is invalid", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidAlgorithmParameterException("aes gcm invalid algo.", e);
        }
        catch (Exception e) {
            AESGCM.remove();
            throw new CryptoException("aes gcm error.", e);
        }
    }

    public static byte[] genAES256SecretKey() throws NoSuchAlgorithmException, CryptoException {
        try {
            SecureRandom rdn = RANDOM.get();
            KeyGenerator keyGen = KeyGenerator.getInstance("AES");
            keyGen.init(256, rdn);
            SecretKey key = keyGen.generateKey();
            return key.getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("generate AES key: NoSuchAlgorithmException exception", e);
        }
        catch (Exception e) {
            RANDOM.remove();
            throw new CryptoException("AES generate key error", e);
        }
    }

    public static byte[] sha256(byte[] msg) {
        MessageDigest md = SHA.get();
        md.reset();
        SHA.remove();
        return md.digest(msg);
    }

    public static byte[] random(int len) {
        SecureRandom rdn = RANDOM.get();
        byte[] randomByte = new byte[len];
        rdn.nextBytes(randomByte);
        RANDOM.remove();
        return randomByte;
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        catch (Exception ex) {
            String errorMsg = "Failed to set JCE security policy";
            logger.log(Level.SEVERE, errorMsg);
            logger.log(Level.SEVERE, ex.getMessage());
            throw new RuntimeException(errorMsg, ex);
        }
        try {
            AlgorithmService.initJceSecurityPolicy();
        }
        catch (Exception ex) {
            String errorMsg = "Failed to set JCE security policy";
            logger.log(Level.SEVERE, errorMsg);
            logger.log(Level.SEVERE, ex.getMessage());
            throw new RuntimeException(errorMsg);
        }
        RSA = new ThreadLocal<Cipher>(){

            @Override
            protected Cipher initialValue() {
                try {
                    return Cipher.getInstance(AlgorithmService.ALGO_RSA);
                }
                catch (NoSuchAlgorithmException e) {
                    logger.log(Level.SEVERE, "RSA2048 encryption algorithm NOT Found.", e);
                }
                catch (NoSuchPaddingException e) {
                    logger.log(Level.SEVERE, "RSA/ECB/PKCS1Padding Padding NOT Found.", e);
                }
                return null;
            }
        };
        AESGCM = new ThreadLocal<Cipher>(){

            @Override
            protected Cipher initialValue() {
                try {
                    return Cipher.getInstance(AlgorithmService.ALGO_AES_GCM);
                }
                catch (NoSuchAlgorithmException e) {
                    logger.log(Level.SEVERE, "AES/GCM Algorithm NOT Found.", e);
                }
                catch (NoSuchPaddingException e) {
                    logger.log(Level.SEVERE, "AES/GCM/NoPadding Padding NOT Found.", e);
                }
                return null;
            }
        };
        SHA = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance(AlgorithmService.ALGO_SHA);
                }
                catch (NoSuchAlgorithmException e) {
                    logger.log(Level.SEVERE, "SHA256 Algorithm NOT Found.", e);
                    return null;
                }
            }
        };
        RANDOM = new ThreadLocal<SecureRandom>(){

            @Override
            protected SecureRandom initialValue() {
                return new SecureRandom();
            }
        };
    }
}

