/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

public class TJScalingFactor {
    private int num = 1;
    private int denom = 1;

    public TJScalingFactor(int num, int denom) {
        if (num < 1 || denom < 1) {
            throw new IllegalArgumentException("Numerator and denominator must be >= 1");
        }
        this.num = num;
        this.denom = denom;
    }

    public int getNum() {
        return this.num;
    }

    public int getDenom() {
        return this.denom;
    }

    public int getScaled(int dimension) {
        return (dimension * this.num + this.denom - 1) / this.denom;
    }

    public boolean equals(TJScalingFactor other) {
        return this.num == other.num && this.denom == other.denom;
    }

    public boolean isOne() {
        return this.num == 1 && this.denom == 1;
    }
}

