/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import org.libjpegturbo.turbojpeg.TJ;

public class YUVImage {
    private static final String NO_ASSOC_ERROR = "No image data is associated with this instance";
    protected long handle = 0L;
    protected byte[][] yuvPlanes = null;
    protected int[] yuvOffsets = null;
    protected int[] yuvStrides = null;
    protected int yuvPad = 0;
    protected int yuvWidth = 0;
    protected int yuvHeight = 0;
    protected int yuvSubsamp = -1;

    private static final int PAD(int v, int p) {
        return v + p - 1 & ~(p - 1);
    }

    public YUVImage(int width, int[] strides, int height, int subsamp) throws Exception {
        this.setBuf(null, null, width, strides, height, subsamp, true);
    }

    public YUVImage(int width, int pad, int height, int subsamp) throws Exception {
        this.setBuf(new byte[TJ.bufSizeYUV(width, pad, height, subsamp)], width, pad, height, subsamp);
    }

    public YUVImage(byte[][] planes, int[] offsets, int width, int[] strides, int height, int subsamp) throws Exception {
        this.setBuf(planes, offsets, width, strides, height, subsamp, false);
    }

    public YUVImage(byte[] yuvImage, int width, int pad, int height, int subsamp) throws Exception {
        this.setBuf(yuvImage, width, pad, height, subsamp);
    }

    public void setBuf(byte[][] planes, int[] offsets, int width, int[] strides, int height, int subsamp) throws Exception {
        this.setBuf(planes, offsets, width, strides, height, subsamp, false);
    }

    private void setBuf(byte[][] planes, int[] offsets, int width, int[] strides, int height, int subsamp, boolean alloc) throws Exception {
        int nc;
        if (planes == null && !alloc || width < 1 || height < 1 || subsamp < 0 || subsamp >= 6) {
            throw new Exception("Invalid argument in YUVImage::setBuf()");
        }
        int n = nc = subsamp == 3 ? 1 : 3;
        if (planes.length != nc || offsets != null && offsets.length != nc || strides != null && strides.length != nc) {
            throw new Exception("YUVImage::setBuf(): planes, offsets, or strides array is the wrong size");
        }
        if (offsets == null) {
            offsets = new int[nc];
        }
        if (strides == null) {
            strides = new int[nc];
        }
        for (int i = 0; i < nc; ++i) {
            int pw = TJ.planeWidth(i, width, subsamp);
            int ph = TJ.planeHeight(i, height, subsamp);
            int planeSize = TJ.planeSizeYUV(i, width, strides[i], height, subsamp);
            if (strides[i] == 0) {
                strides[i] = pw;
            }
            if (alloc) {
                if (strides[i] < pw) {
                    throw new Exception("Stride must be >= plane width when allocating a new YUV image");
                }
                planes[i] = new byte[strides[i] * ph];
            }
            if (planes[i] == null || offsets[i] < 0) {
                throw new Exception("Invalid argument in YUVImage::setBuf()");
            }
            if (strides[i] < 0 && offsets[i] - planeSize + pw < 0) {
                throw new Exception("Stride for plane " + i + " would cause memory to be accessed below plane boundary");
            }
            if (planes[i].length >= offsets[i] + planeSize) continue;
            throw new Exception("Image plane " + i + " is not large enough");
        }
        this.yuvPlanes = planes;
        this.yuvOffsets = offsets;
        this.yuvWidth = width;
        this.yuvStrides = strides;
        this.yuvHeight = height;
        this.yuvSubsamp = subsamp;
    }

    public void setBuf(byte[] yuvImage, int width, int pad, int height, int subsamp) throws Exception {
        if (yuvImage == null || width < 1 || pad < 1 || (pad & pad - 1) != 0 || height < 1 || subsamp < 0 || subsamp >= 6) {
            throw new Exception("Invalid argument in YUVImage::setBuf()");
        }
        if (yuvImage.length < TJ.bufSizeYUV(width, pad, height, subsamp)) {
            throw new Exception("YUV image buffer is not large enough");
        }
        int nc = subsamp == 3 ? 1 : 3;
        byte[][] planes = new byte[nc][];
        int[] strides = new int[nc];
        int[] offsets = new int[nc];
        planes[0] = yuvImage;
        strides[0] = YUVImage.PAD(TJ.planeWidth(0, width, subsamp), pad);
        if (subsamp != 3) {
            strides[1] = strides[2] = YUVImage.PAD(TJ.planeWidth(1, width, subsamp), pad);
            planes[2] = yuvImage;
            planes[1] = yuvImage;
            offsets[1] = offsets[0] + strides[0] * TJ.planeHeight(0, height, subsamp);
            offsets[2] = offsets[1] + strides[1] * TJ.planeHeight(1, height, subsamp);
        }
        this.yuvPad = pad;
        this.setBuf(planes, offsets, width, strides, height, subsamp);
    }

    public int getWidth() throws Exception {
        if (this.yuvWidth < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.yuvWidth;
    }

    public int getHeight() throws Exception {
        if (this.yuvHeight < 1) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.yuvHeight;
    }

    public int getPad() throws Exception {
        if (this.yuvPlanes == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        if (this.yuvPad < 1 || (this.yuvPad & this.yuvPad - 1) != 0) {
            throw new Exception("Image is not stored in a unified buffer");
        }
        return this.yuvPad;
    }

    public int[] getStrides() throws Exception {
        if (this.yuvStrides == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.yuvStrides;
    }

    public int[] getOffsets() throws Exception {
        if (this.yuvOffsets == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.yuvOffsets;
    }

    public int getSubsamp() throws Exception {
        if (this.yuvSubsamp < 0 || this.yuvSubsamp >= 6) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.yuvSubsamp;
    }

    public byte[][] getPlanes() throws Exception {
        if (this.yuvPlanes == null) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        return this.yuvPlanes;
    }

    public byte[] getBuf() throws Exception {
        if (this.yuvPlanes == null || this.yuvSubsamp < 0 || this.yuvSubsamp >= 6) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        int nc = this.yuvSubsamp == 3 ? 1 : 3;
        for (int i = 1; i < nc; ++i) {
            if (this.yuvPlanes[i] == this.yuvPlanes[0]) continue;
            throw new Exception("Image is not stored in a unified buffer");
        }
        return this.yuvPlanes[0];
    }

    public int getSize() throws Exception {
        int nc;
        if (this.yuvPlanes == null || this.yuvSubsamp < 0 || this.yuvSubsamp >= 6) {
            throw new Exception(NO_ASSOC_ERROR);
        }
        int n = nc = this.yuvSubsamp == 3 ? 1 : 3;
        if (this.yuvPad < 1) {
            throw new Exception("Image is not stored in a unified buffer");
        }
        for (int i = 1; i < nc; ++i) {
            if (this.yuvPlanes[i] == this.yuvPlanes[0]) continue;
            throw new Exception("Image is not stored in a unified buffer");
        }
        return TJ.bufSizeYUV(this.yuvWidth, this.yuvPad, this.yuvHeight, this.yuvSubsamp);
    }
}

