/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.clientinforeport.util;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.UUID;

public class DeviceUtils {
    private static boolean isPad = false;
    private static boolean isPadDecied = false;
    private static final String KEY_SHARED_PREFERENCE = "aliyun_svideo_global_info";
    private static final String KEY_UUID = "uuid";
    private static String uuid = null;
    private static boolean uuidDecied = false;

    public static boolean isPad(Context context) {
        if (isPadDecied) {
            return isPad;
        }
        if (context == null) {
            return false;
        }
        try {
            WindowManager wm = (WindowManager)context.getApplicationContext().getSystemService("window");
            Display display = wm.getDefaultDisplay();
            DisplayMetrics dm = new DisplayMetrics();
            display.getMetrics(dm);
            double x = Math.pow((float)dm.widthPixels / dm.xdpi, 2.0);
            double y = Math.pow((float)dm.heightPixels / dm.ydpi, 2.0);
            double screenInches = Math.sqrt(x + y);
            isPad = screenInches >= 6.0;
            isPadDecied = true;
            return isPad;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getDeviceModel() {
        String model = Build.MODEL;
        if (model.contains(" ")) {
            try {
                return URLEncoder.encode(model, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return URLEncoder.encode(model);
            }
        }
        return model;
    }

    public static String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getUuid(Context context) {
        if (uuidDecied) {
            return uuid;
        }
        if (context == null) {
            return "";
        }
        SharedPreferences sp = context.getSharedPreferences(KEY_SHARED_PREFERENCE, 0);
        if (sp.contains(KEY_UUID)) {
            uuid = sp.getString(KEY_UUID, null);
        }
        if (uuid == null) {
            uuid = UUID.randomUUID().toString().toUpperCase();
            SharedPreferences.Editor editor = sp.edit();
            editor.putString(KEY_UUID, uuid);
            editor.apply();
        }
        uuidDecied = true;
        return uuid;
    }

    public static String getOperationSystem(Context context) {
        try {
            Class<?> buildClass = Class.forName("android.os.SystemProperties");
            Method getStringMethod = buildClass.getMethod("get", String.class);
            getStringMethod.setAccessible(true);
            String osName = (String)getStringMethod.invoke(null, "ro.os.name");
            if (TextUtils.isEmpty((CharSequence)osName)) {
                osName = (String)getStringMethod.invoke(null, "net.bt.name");
            }
            if (!TextUtils.isEmpty((CharSequence)osName)) {
                return osName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "Android";
    }

    public static String getDeviceBrand() {
        String brand = Build.BRAND;
        if (brand.contains(" ")) {
            try {
                return URLEncoder.encode(brand, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return URLEncoder.encode(brand);
            }
        }
        return brand;
    }

    public static String getDeviceManufacture() {
        String manufacturer = Build.MANUFACTURER;
        if (manufacturer.contains(" ")) {
            try {
                return URLEncoder.encode(manufacturer, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return URLEncoder.encode(manufacturer);
            }
        }
        return manufacturer;
    }

    public static String getConnection(Context context) {
        if (context == null) {
            return "";
        }
        ConnectivityManager connMgr = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr.getActiveNetworkInfo();
        if (networkInfo == null) {
            return "";
        }
        int nType = networkInfo.getType();
        if (nType == 0) {
            return Connection.cellnetwork.name();
        }
        if (nType == 1) {
            return Connection.wifi.name();
        }
        return "";
    }

    public static enum Connection {
        wifi,
        cellnetwork;

    }
}

