/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.clientinforeport.core;

import android.text.TextUtils;
import com.aliyun.clientinforeport.AlivcEventPublicParam;
import com.aliyun.clientinforeport.util.CheckLog;
import com.aliyun.clientinforeport.util.NetUtils;
import com.aliyun.clientinforeport.util.RLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PublicParamChecker {
    private static final List<String> productList = new ArrayList<String>();
    private static final List<String> moduleList;
    private static final List<String> submoduleList;
    private static final List<String> videoTypeList;
    private static final List<String> terminalTypeList;
    private static final List<String> connectionList;
    private static final Map<Integer, String> playerEventDesc;

    public static void checkParam(AlivcEventPublicParam param, int eventId) {
        if (!RLog.isOpen()) {
            return;
        }
        if (param == null) {
            CheckLog.empty("AlivcEventPublicParam");
        } else {
            if (param.getProduct().equals("player")) {
                CheckLog.ok("==================== AlivcEventPublicParam ", "check Start  eventid = " + eventId + "(" + playerEventDesc.get(eventId) + ") =====================");
            }
            PublicParamChecker.checkTime(param.getTime());
            PublicParamChecker.checkLogLevel(param.getLogLevel());
            PublicParamChecker.checkLogVersion(param.getLogVersion());
            PublicParamChecker.checkProduct(param.getProduct());
            PublicParamChecker.checkModule(param.getModule());
            PublicParamChecker.checkSubModule(param.getSubModule());
            PublicParamChecker.checkHostName(param.getHostName());
            PublicParamChecker.checkBusinessId(param.getBusinessId());
            PublicParamChecker.checkRequestId(param.getRequestId());
            PublicParamChecker.checkVideoType(param.getVideoType());
            PublicParamChecker.checkTerminalType(param.getTerminalType());
            PublicParamChecker.checkDeviceModel(param.getDeviceModel());
            PublicParamChecker.checkDeviceBrand(param.getDeviceBrand());
            PublicParamChecker.checkDeviceManufacture(param.getDeviceManufacture());
            PublicParamChecker.checkOperationSystem(param.getOperationSystem());
            PublicParamChecker.checkOsVersion(param.getOsVersion());
            PublicParamChecker.checkAppVersion(param.getAppVersion());
            PublicParamChecker.checkUuid(param.getUuid());
            PublicParamChecker.checkVideoUrl(param.getVideoUrl());
            PublicParamChecker.checkConnection(param.getConnection());
            PublicParamChecker.checkUserAgent(param.getUserAgent());
            PublicParamChecker.checkAppId(param.getApplicationId());
            PublicParamChecker.checkAppName(param.getApplicationName());
            PublicParamChecker.checkCdnIp(param.getCdnIp());
            PublicParamChecker.checkRefer(param.getReferer());
        }
        CheckLog.ok("==================== AlivcEventPublicParam ", "check End =====================");
    }

    private static void checkRefer(String referer) {
        String name = "r(referrer)";
        PublicParamChecker.emptyCheck(name, referer);
    }

    private static void checkCdnIp(String cdnIp) {
        String name = "cdn_ip(cdnIp)";
        if (TextUtils.isEmpty((CharSequence)cdnIp)) {
            CheckLog.empty(name);
        } else if (!NetUtils.isIp(cdnIp)) {
            CheckLog.error("ERROR: " + name + " is  " + cdnIp + " , should be IP address");
        } else {
            CheckLog.ok(name, cdnIp);
        }
    }

    private static void checkAppName(String applicationName) {
        String name = "app_n(applicationName)";
        PublicParamChecker.emptyCheck(name, applicationName);
    }

    private static void checkAppId(String applicationId) {
        String name = "app_id(applicationId)";
        if (TextUtils.isEmpty((CharSequence)applicationId)) {
            CheckLog.empty(name);
        } else if (applicationId.contains(" ")) {
            CheckLog.space(name, applicationId);
        } else if (!applicationId.endsWith("|Android") && !applicationId.endsWith("|iOS")) {
            CheckLog.error("ERROR: " + name + " is  " + applicationId + " , should be endWith [|Android , |iOS]");
        } else {
            CheckLog.ok(name, applicationId);
        }
    }

    private static void checkUserAgent(String userAgent) {
        String name = "uat(userAgent)";
        PublicParamChecker.emptyCheck(name, userAgent);
    }

    private static void checkConnection(String connection) {
        String name = "co(connection)";
        PublicParamChecker.rangeCheck(name, connection, connectionList);
    }

    private static void checkVideoUrl(String videoUrl) {
        String name = "vu(videoUrl)";
        PublicParamChecker.emptyCheck(name, videoUrl);
    }

    private static void checkUuid(String uuid) {
        String name = "uuid(uuid)";
        PublicParamChecker.emptyCheck(name, uuid);
    }

    private static void checkAppVersion(String appVersion) {
        String name = "av(appVersion)";
        PublicParamChecker.emptyCheck(name, appVersion);
    }

    private static void checkOsVersion(String osVersion) {
        String name = "ov(osVersion)";
        PublicParamChecker.emptyCheck(name, osVersion);
    }

    private static void checkOperationSystem(String operationSystem) {
        String name = "os(operationSystem)";
        PublicParamChecker.emptyCheck(name, operationSystem);
    }

    private static void checkDeviceManufacture(String deviceManufacture) {
        String name = "dma(deviceManufacture)";
        PublicParamChecker.emptyCheck(name, deviceManufacture);
    }

    private static void checkDeviceBrand(String deviceBrand) {
        String name = "db(deviceBrand)";
        PublicParamChecker.emptyCheck(name, deviceBrand);
    }

    private static void checkDeviceModel(String deviceModel) {
        String name = "dm(deviceModel)";
        PublicParamChecker.emptyCheck(name, deviceModel);
    }

    private static void checkTerminalType(String terminalType) {
        String name = "tt(terminalType)";
        PublicParamChecker.rangeCheck(name, terminalType, terminalTypeList);
    }

    private static void checkVideoType(String videoType) {
        String name = "vt(videoType)";
        PublicParamChecker.rangeCheck(name, videoType, videoTypeList);
    }

    private static void checkRequestId(String requestId) {
        String name = "ri(requestId)";
        PublicParamChecker.emptyCheck(name, requestId);
    }

    private static void checkBusinessId(String businessId) {
        String name = "bi(businessId)";
        PublicParamChecker.emptyCheck(name, businessId);
    }

    private static void checkHostName(String hostName) {
        String name = "hn(hostName)";
        if (TextUtils.isEmpty((CharSequence)hostName)) {
            CheckLog.empty(name);
        } else if (!NetUtils.isIp(hostName)) {
            CheckLog.error("ERROR: " + name + " is  " + hostName + " , should be IP address");
        } else {
            CheckLog.ok(name, hostName);
        }
    }

    private static void checkSubModule(String subModule) {
        String name = "sm(subModule)";
        PublicParamChecker.rangeCheck(name, subModule, submoduleList);
    }

    private static void checkModule(String module) {
        String name = "md(module)";
        PublicParamChecker.rangeCheck(name, module, moduleList);
    }

    private static void checkProduct(String product) {
        String name = "pd(product)";
        PublicParamChecker.rangeCheck(name, product, productList);
    }

    private static void checkLogLevel(String logLevel) {
        String name = "ll(logLevel)";
        PublicParamChecker.emptyCheck(name, logLevel);
    }

    private static void checkLogVersion(String logVersion) {
        String name = "lv(logVersion)";
        PublicParamChecker.emptyCheck(name, logVersion);
    }

    private static void checkTime(String time) {
        String name = "t(time)";
        if (TextUtils.isEmpty((CharSequence)time)) {
            CheckLog.empty(name);
        } else if (time.length() != 13) {
            CheckLog.error("ERROR: " + name + " is  " + time + " , should be MS");
        } else {
            CheckLog.ok(name, time);
        }
    }

    private static void emptyCheck(String name, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            CheckLog.empty(name);
        } else if (name.contains(" ")) {
            CheckLog.space(name, value);
        } else {
            CheckLog.ok(name, value);
        }
    }

    private static void rangeCheck(String name, String value, List<String> rangeList) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            CheckLog.empty(name);
        } else if (!rangeList.contains(value)) {
            CheckLog.outRange(name, value, rangeList);
        } else {
            CheckLog.ok(name, value);
        }
    }

    static {
        productList.add("player");
        productList.add("pusher");
        productList.add("mixer");
        productList.add("svideo");
        moduleList = new ArrayList<String>();
        moduleList.add("saas_player");
        moduleList.add("player");
        moduleList.add("mixer");
        moduleList.add("publisher");
        moduleList.add("svideo_basic");
        moduleList.add("svideo_standard");
        moduleList.add("svideo_pro");
        submoduleList = new ArrayList<String>();
        submoduleList.add("play");
        submoduleList.add("download");
        submoduleList.add("record");
        submoduleList.add("cut");
        submoduleList.add("edit");
        submoduleList.add("pusher");
        videoTypeList = new ArrayList<String>();
        videoTypeList.add("live");
        videoTypeList.add("vod");
        terminalTypeList = new ArrayList<String>();
        terminalTypeList.add("pc");
        terminalTypeList.add("phone");
        terminalTypeList.add("pad");
        connectionList = new ArrayList<String>();
        connectionList.add("wifi");
        connectionList.add("cellnetwork");
        playerEventDesc = new HashMap<Integer, String>();
        playerEventDesc.put(1001, "\u64ad\u653e\u5668\u521d\u59cb\u5316");
        playerEventDesc.put(1002, "\u5173\u95ed/\u91ca\u653e\u64ad\u653e\u5668");
        playerEventDesc.put(1003, "\u5f00\u59cb\u83b7\u53d6URL");
        playerEventDesc.put(1004, "\u7ed3\u675f\u83b7\u53d6URL");
        playerEventDesc.put(1005, "\u5f00\u59cb\u64ad\u653e \u64ad\u653e\u4e4b\u524d\u6c47\u62a5");
        playerEventDesc.put(2001, "\u64ad\u653e");
        playerEventDesc.put(2002, "\u5b8c\u6210");
        playerEventDesc.put(2012, "\u505c\u6b62");
        playerEventDesc.put(2003, "\u6682\u505c");
        playerEventDesc.put(2010, "\u6682\u505c\u6062\u590d");
        playerEventDesc.put(2004, "\u62d6\u52a8");
        playerEventDesc.put(2005, "\u5168\u5c4f");
        playerEventDesc.put(2006, "\u9000\u51fa\u5168\u5c4f");
        playerEventDesc.put(2007, "\u5207\u6362\u6e05\u6670\u5ea6");
        playerEventDesc.put(2008, "\u6e05\u6670\u5ea6\u5207\u6362\u5b8c\u6210");
        playerEventDesc.put(2009, "\u91cd\u64ad");
        playerEventDesc.put(2023, "\u5f00\u59cb\u7f13\u5b58");
        playerEventDesc.put(2024, "\u7f13\u5b58\u6210\u529f");
        playerEventDesc.put(2025, "\u5f00\u542f\u5faa\u73af\u64ad\u653e");
        playerEventDesc.put(2026, "\u5173\u95ed\u5faa\u73af\u64ad\u653e");
        playerEventDesc.put(2027, "\u4f7f\u7528\u622a\u56fe");
        playerEventDesc.put(2028, "\u8bbe\u7f6e\u65cb\u8f6c\u89d2\u5ea6");
        playerEventDesc.put(2029, "\u8bbe\u7f6e\u955c\u50cf");
        playerEventDesc.put(2030, "\u8bfb\u53d6SEI");
        playerEventDesc.put(2011, "\u62d6\u52a8\u5b8c\u6210");
        playerEventDesc.put(3002, "\u5361\u987f");
        playerEventDesc.put(3001, "\u5361\u987f\u6062\u590d");
        playerEventDesc.put(3005, "\u5468\u671f\u6027\u4e0b\u8f7d");
        playerEventDesc.put(9001, "\u5468\u671f\u6027\u6c47\u62a5");
        playerEventDesc.put(9004, "\u5ef6\u65f6\u4fe1\u606f");
        playerEventDesc.put(4001, "\u53d1\u751f\u9519\u8bef");
    }
}

