/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.encoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.util.Range;
import android.view.Surface;
import com.alivc.component.encoder.MediaCodecData;
import com.alivc.component.encoder.NativeUsed;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;

@NativeUsed
public class VideoCodecEncoder {
    public static final int[] SUPPORTED_COLOR_FORMATS = new int[]{21, 39, 19, 20, 2130706688};
    public static final int OK = 0;
    public static final int ERROR_API_LEVEL = 0x10003100;
    public static final int ERROR_STATE = 0x10003101;
    public static final int ERROR_INPUT_BUFFER_ERROR = 268448002;
    public static final int ERROR_NO_BUFFER_AVAILABLE = 0x10003103;
    private static final String TAG = VideoCodecEncoder.class.getName();
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_ENCODING = 2;
    private MediaCodec mMediaCodec;
    private int mState = 0;
    private ByteBuffer[] mOutputBuffers;
    private int encodeFormat = -1;
    private int mOutputCount = 0;
    private boolean useHighProfile = false;
    int inputCount = 0;

    @NativeUsed
    public int init(String mimeType, MediaFormat format, boolean inputSurface, int gopSize) {
        if (this.mState == 0) {
            try {
                this.mOutputCount = 0;
                MediaCodecInfo codecInfo = this.selectCodecInfo(mimeType);
                if (codecInfo == null) {
                    Log.d((String)TAG, (String)("not supported mime type (" + mimeType + ")"));
                    return -1;
                }
                Log.e((String)TAG, (String)("Create MediaCodec " + codecInfo.getName()));
                this.mMediaCodec = MediaCodec.createByCodecName((String)codecInfo.getName());
                if (Build.MODEL.contains("Pixel\u00a0XL") || Build.MODEL.contains("LON-AL00") || Build.MODEL.contains("VTR-AL00") || Build.MODEL.contains("MHA-AL00") || Build.MODEL.contains("VKY-AL00") || Build.MODEL.contains("STF-AL00") || Build.MODEL.contains("SM-N9108V") || Build.MODEL.contains("SM-G9008V") || Build.MODEL.contains("SM-G9500") || Build.MODEL.contains("SM-G9006V")) {
                    this.useHighProfile = true;
                }
                int selectedProfile = 0;
                int selectedLevel = 0;
                ArrayList<Integer> highlineLevels = new ArrayList<Integer>();
                ArrayList<Integer> baselineLevels = new ArrayList<Integer>();
                MediaCodecInfo.CodecCapabilities cap = codecInfo.getCapabilitiesForType(mimeType);
                for (int i = 0; i < cap.profileLevels.length; ++i) {
                    MediaCodecInfo.CodecProfileLevel profileLevel = cap.profileLevels[i];
                    if (profileLevel.profile == 8) {
                        if (this.useHighProfile) {
                            selectedProfile = profileLevel.profile;
                        }
                        highlineLevels.add(profileLevel.level);
                        if (this.useHighProfile && profileLevel.level == 512) {
                            selectedLevel = profileLevel.level;
                            break;
                        }
                    }
                    if (profileLevel.profile != 1) continue;
                    if (!this.useHighProfile) {
                        selectedProfile = profileLevel.profile;
                    }
                    baselineLevels.add(profileLevel.level);
                    if (this.useHighProfile || profileLevel.level != 512) continue;
                    selectedLevel = profileLevel.level;
                    break;
                }
                if (selectedProfile != 0 && selectedLevel == 0) {
                    if (this.useHighProfile && highlineLevels.size() > 0) {
                        selectedLevel = (Integer)highlineLevels.get(0);
                    } else if (!this.useHighProfile && baselineLevels.size() > 0) {
                        selectedLevel = (Integer)baselineLevels.get(0);
                    }
                }
                if (selectedProfile == 0 && cap.profileLevels.length > 0) {
                    if (this.useHighProfile && baselineLevels.size() > 0) {
                        selectedProfile = 1;
                        selectedLevel = baselineLevels.contains(512) ? 512 : (Integer)baselineLevels.get(0);
                    } else if (!this.useHighProfile && highlineLevels.size() > 0) {
                        selectedProfile = 8;
                        selectedLevel = highlineLevels.contains(512) ? 512 : (Integer)baselineLevels.get(0);
                    } else {
                        Log.e((String)TAG, (String)"donnot support hardware codec ---> AVCProfileHigh & AVCProfileBaseline");
                        selectedProfile = cap.profileLevels[0].profile;
                        selectedLevel = cap.profileLevels[0].level;
                    }
                }
                if (cap.profileLevels.length <= 0) {
                    Log.e((String)TAG, (String)"donnot support hardware codec");
                    return -1;
                }
                Log.e((String)TAG, (String)Arrays.toString(cap.colorFormats));
                this.encodeFormat = VideoCodecEncoder.selectColorFormat(codecInfo, inputSurface, mimeType);
                if (this.encodeFormat == 0) {
                    return -1;
                }
                Log.d((String)TAG, (String)("selected format " + this.encodeFormat));
                format.setInteger("color-format", this.encodeFormat);
                int fps = format.getInteger("frame-rate");
                format.setInteger("i-frame-interval", gopSize);
                format.setInteger("profile", 1);
                format.setInteger("level", 512);
                if (Build.VERSION.SDK_INT >= 21) {
                    Method method = MediaCodecInfo.VideoCapabilities.class.getMethod("create", MediaFormat.class, MediaCodecInfo.CodecCapabilities.class);
                    MediaCodecInfo.VideoCapabilities vcap = (MediaCodecInfo.VideoCapabilities)method.invoke(null, format, cap);
                    Range bitrateRange = vcap.getBitrateRange();
                    int widthAlignment = vcap.getWidthAlignment();
                    int heightAlignment = vcap.getHeightAlignment();
                    Range widthRange = vcap.getSupportedWidths();
                    Range heightRange = vcap.getSupportedHeights();
                    int width = format.getInteger("width");
                    int height = format.getInteger("height");
                    int frameRate = format.getInteger("frame-rate");
                    boolean isSizeSupport = vcap.isSizeSupported(width, height);
                    Log.e((String)TAG, (String)("bitrateRange [" + bitrateRange.getLower() + "," + bitrateRange.getUpper() + "], widthAlignment = " + widthAlignment + ", heightAlignment = " + heightAlignment + ", widthRange [" + widthRange.getLower() + "," + widthRange.getUpper() + "], heightRange [" + heightRange.getLower() + "," + heightRange.getUpper() + "], isSizeSupport = " + isSizeSupport + ", sizeAndRateSupport = " + vcap.areSizeAndRateSupported(width, height, (double)frameRate)));
                    if (Build.VERSION.SDK_INT >= 23) {
                        format.setInteger("stride", width);
                        format.setInteger("slice-height", height);
                    }
                }
                Log.e((String)TAG, (String)("encoder bitrate = " + format.getInteger("bitrate") + ", encoder i frame interval = " + format.getInteger("i-frame-interval") + ", encoder frame rate = " + format.getInteger("frame-rate") + ", encoder profile = " + format.getInteger("profile") + ", encoder level = " + format.getInteger("level") + ", encoder width = " + format.getInteger("width") + ", encoder height = " + format.getInteger("height")));
                this.mMediaCodec.configure(format, null, null, 1);
                this.mState = 1;
                if (codecInfo.getName().equals("OMX.IMG.TOPAZ.VIDEO.Encoder")) {
                    Log.d((String)TAG, (String)("Product:" + Build.PRODUCT));
                    switch (this.encodeFormat) {
                        case 19: {
                            this.encodeFormat = 20;
                            break;
                        }
                        case 20: {
                            this.encodeFormat = 19;
                            break;
                        }
                        case 21: {
                            this.encodeFormat = 39;
                            break;
                        }
                        case 39: {
                            this.encodeFormat = 21;
                            break;
                        }
                    }
                }
                Log.d((String)TAG, (String)("Phone Model: " + Build.MODEL));
                return this.encodeFormat;
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Create MediaCodec Failed");
                e.printStackTrace();
                return 0x10003101;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return 0x10003101;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0x10003101;
            }
        }
        return 0x10003101;
    }

    @NativeUsed
    public Surface createInputSurface() {
        if (this.mMediaCodec != null && this.mState == 1 && Build.VERSION.SDK_INT >= 18) {
            try {
                return this.mMediaCodec.createInputSurface();
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)TAG, (String)"create surface input failed");
                return null;
            }
        }
        Log.e((String)TAG, (String)"not support surface input");
        return null;
    }

    @NativeUsed
    public int start() {
        if (this.mMediaCodec != null && this.mState == 1) {
            try {
                this.mMediaCodec.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0x10003101;
            }
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            this.mState = 2;
            return 0;
        }
        return 0x10003101;
    }

    @NativeUsed
    public int inputFrame(byte[] frame, long presentationTimeUs, long timeoutUs, boolean isKeyFrame) {
        try {
            ByteBuffer[] inputBuffers = this.mMediaCodec.getInputBuffers();
            int bufferIndex = this.mMediaCodec.dequeueInputBuffer(timeoutUs);
            if (bufferIndex >= 0) {
                inputBuffers[bufferIndex].clear();
                if (frame == null) {
                    Log.e((String)TAG, (String)"Symptom of the \"Callback buffer was to small\" problem...");
                } else {
                    inputBuffers[bufferIndex].put(frame, 0, frame.length);
                }
                ++this.inputCount;
                if (isKeyFrame && Build.VERSION.SDK_INT >= 19) {
                    Bundle params = new Bundle();
                    params.putInt("request-sync", 0);
                    this.mMediaCodec.setParameters(params);
                }
            } else {
                Log.e((String)TAG, (String)"No buffer available !");
                return 0x10003103;
            }
            int flag = isKeyFrame ? 1 : 0;
            this.mMediaCodec.queueInputBuffer(bufferIndex, 0, inputBuffers[bufferIndex].position(), presentationTimeUs, flag);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    @NativeUsed
    public MediaCodecData tryRead(long timeoutUs) {
        MediaCodec.BufferInfo outputBufferInfo = new MediaCodec.BufferInfo();
        ByteBuffer outputBuffer = null;
        MediaCodecData resultData = new MediaCodecData();
        int outputBufferId = this.mMediaCodec.dequeueOutputBuffer(outputBufferInfo, timeoutUs);
        if (outputBufferId >= 0) {
            outputBuffer = this.mOutputBuffers[outputBufferId];
            if (outputBufferInfo.size != 0) {
                outputBuffer.position(outputBufferInfo.offset);
                outputBuffer.limit(outputBufferInfo.offset + outputBufferInfo.size);
            }
            resultData.setCodecData(outputBuffer, this.mMediaCodec, outputBufferId);
            ++this.mOutputCount;
            if ((outputBufferInfo.flags & 2) > 0) {
                resultData.setDataType(1);
            } else if ((outputBufferInfo.flags & 1) > 0) {
                resultData.setDataType(3);
            } else {
                resultData.setDataType(2);
            }
            resultData.setPts(outputBufferInfo.presentationTimeUs);
            resultData.setDts(outputBufferInfo.presentationTimeUs);
        } else if (outputBufferId == -2) {
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            resultData.setCode(1);
        } else if (outputBufferId == -1) {
            resultData.setCode(1);
        } else if (outputBufferId == -3) {
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            resultData.setCode(1);
        } else {
            resultData.setCode(-1);
        }
        return resultData;
    }

    @NativeUsed
    public int updateBitrate(int bitrate) {
        if (Build.VERSION.SDK_INT < 19) {
            return 0x10003100;
        }
        if (this.mState == 2 && this.mMediaCodec != null) {
            Bundle params = new Bundle();
            params.putInt("video-bitrate", bitrate * 1000);
            this.mMediaCodec.setParameters(params);
            return 0;
        }
        return 0x10003101;
    }

    @NativeUsed
    public int stop() {
        if (this.mState == 2 && this.mMediaCodec != null) {
            if (this.mOutputCount > 0) {
                this.mMediaCodec.flush();
            }
            this.mMediaCodec.stop();
            this.mState = 1;
            return 0;
        }
        return 0x10003101;
    }

    @NativeUsed
    public int release() {
        Log.e((String)"dyt", (String)("input" + this.inputCount + "output" + this.mOutputCount));
        if (this.mState == 1) {
            this.mMediaCodec.release();
            this.mMediaCodec = null;
            this.mState = 0;
            return 0;
        }
        return 0x10003101;
    }

    private MediaCodecInfo selectCodecInfo(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            String[] types = codecInfo.getSupportedTypes();
            for (int j = 0; j < types.length; ++j) {
                if (!types[j].equalsIgnoreCase(mimeType)) continue;
                return codecInfo;
            }
        }
        return null;
    }

    private static int selectColorFormat(MediaCodecInfo codecInfo, boolean inputSurface, String mimeType) {
        if (inputSurface) {
            return 2130708361;
        }
        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(mimeType);
        for (int i = 0; i < capabilities.colorFormats.length; ++i) {
            int colorFormat = capabilities.colorFormats[i];
            if (!VideoCodecEncoder.isRecognizedFormat(colorFormat)) continue;
            return colorFormat;
        }
        return 0;
    }

    private static boolean isRecognizedFormat(int colorFormat) {
        switch (colorFormat) {
            case 19: 
            case 20: 
            case 21: 
            case 39: 
            case 2130706688: {
                return true;
            }
        }
        return false;
    }
}

