/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.clientinforeport;

import android.content.Context;
import android.text.TextUtils;
import com.aliyun.clientinforeport.util.AppUtils;
import com.aliyun.clientinforeport.util.DeviceUtils;
import com.aliyun.clientinforeport.util.NetUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;

public class AlivcEventPublicParam {
    private String logStore;
    private long time = System.currentTimeMillis();
    private String logLevel;
    private String logVersion = "1.1";
    private String product;
    private String module;
    private String subModule;
    private String hostName = NetUtils.getHostIp();
    private String businessId;
    private String requestId;
    private String videoType;
    private String terminalType;
    private String deviceModel;
    private String deviceBrand;
    private String deviceManufacture;
    private String operationSystem;
    private String osVersion;
    private String appVersion;
    private String uuid;
    private String videoUrl;
    private String userAccount;
    private String connection;
    private String userAgent;
    private String ui;
    private String applicationId;
    private String applicationName;
    private String cdnIp;
    private String referer;

    public AlivcEventPublicParam(Context context) {
        boolean isPad = DeviceUtils.isPad(context);
        this.terminalType = isPad ? TerminalType.pad.name() : TerminalType.phone.name();
        this.deviceModel = DeviceUtils.getDeviceModel();
        this.deviceBrand = DeviceUtils.getDeviceBrand();
        this.deviceManufacture = DeviceUtils.getDeviceManufacture();
        this.operationSystem = DeviceUtils.getOperationSystem(context);
        this.osVersion = DeviceUtils.getOsVersion();
        this.uuid = DeviceUtils.getUuid(context);
        this.connection = DeviceUtils.getConnection(context);
        this.applicationId = AppUtils.getPackageName(context) + "|Android";
        this.applicationName = AppUtils.getAppName(context);
        this.requestId = UUID.randomUUID().toString().toUpperCase();
    }

    public void setLogStore(String ls) {
        this.logStore = ls;
    }

    public void setLogLevel(LogLevel ll) {
        this.logLevel = ll == null ? LogLevel.debug.name() : ll.name();
    }

    public void setProduct(String pd) {
        this.product = pd;
    }

    public void setModule(String md) {
        this.module = md;
    }

    public void setSubModule(String sm) {
        this.subModule = sm;
    }

    public void setBusinessId(String bi) {
        this.businessId = bi;
    }

    public void refreshRequestId() {
        this.requestId = UUID.randomUUID().toString().toUpperCase();
    }

    public void setRequestId(String id) {
        this.requestId = id;
    }

    public void setVideoType(VideoType vt) {
        this.videoType = vt == null ? "" : vt.name();
    }

    public void setAppVersion(String av) {
        this.appVersion = av;
    }

    public void setVideoUrl(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.videoUrl = "";
        } else {
            try {
                this.videoUrl = URLEncoder.encode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.videoUrl = URLEncoder.encode(url);
            }
        }
    }

    public void setUserAccount(String userAccount) {
        this.userAccount = userAccount;
    }

    public void setUserAgent(String ua) {
        this.userAgent = ua;
    }

    public void setUi(Ui ui) {
        this.ui = ui == null ? "" : ui.name();
    }

    public void setCdnIp(String ci) {
        this.cdnIp = ci;
    }

    public void setReferer(String ref) {
        this.referer = ref;
    }

    public String getTime() {
        return System.currentTimeMillis() + "";
    }

    public String getLogStore() {
        if (TextUtils.isEmpty((CharSequence)this.logStore)) {
            throw new IllegalAccessError("logStore is Empty!");
        }
        return this.logStore;
    }

    public String getLogLevel() {
        if (TextUtils.isEmpty((CharSequence)this.logLevel)) {
            this.logLevel = LogLevel.info.name();
        }
        return this.logLevel;
    }

    public String getLogVersion() {
        if (TextUtils.isEmpty((CharSequence)this.logVersion)) {
            this.logVersion = "1.0";
        }
        return this.logVersion;
    }

    public String getProduct() {
        if (TextUtils.isEmpty((CharSequence)this.product)) {
            throw new IllegalAccessError("product is Empty!");
        }
        return this.product;
    }

    public String getModule() {
        if (TextUtils.isEmpty((CharSequence)this.module)) {
            throw new IllegalAccessError("module is Empty!");
        }
        return this.module;
    }

    public String getSubModule() {
        if (TextUtils.isEmpty((CharSequence)this.subModule)) {
            throw new IllegalAccessError("subModule is Empty!");
        }
        return this.subModule;
    }

    public String getHostName() {
        if (TextUtils.isEmpty((CharSequence)this.hostName)) {
            this.hostName = "";
        }
        return this.hostName;
    }

    public String getBusinessId() {
        if (TextUtils.isEmpty((CharSequence)this.businessId)) {
            this.businessId = "";
        }
        return this.businessId;
    }

    public String getRequestId() {
        if (TextUtils.isEmpty((CharSequence)this.requestId)) {
            this.refreshRequestId();
        }
        return this.requestId;
    }

    public String getTerminalType() {
        return this.terminalType;
    }

    public String getOperationSystem() {
        return this.operationSystem;
    }

    public String getOsVersion() {
        return this.osVersion;
    }

    public String getAppVersion() {
        if (TextUtils.isEmpty((CharSequence)this.appVersion)) {
            throw new IllegalAccessError("appVersion is Empty !");
        }
        return this.appVersion;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getConnection() {
        if (TextUtils.isEmpty((CharSequence)this.connection)) {
            this.connection = "";
        }
        return this.connection;
    }

    public String getUserAgent() {
        if (TextUtils.isEmpty((CharSequence)this.userAgent)) {
            this.userAgent = "";
        }
        return this.userAgent;
    }

    public String getUi() {
        if (TextUtils.isEmpty((CharSequence)this.ui)) {
            this.ui = "";
        }
        return this.ui;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getCdnIp() {
        if (TextUtils.isEmpty((CharSequence)this.cdnIp)) {
            this.cdnIp = "0.0.0.0";
        }
        return this.cdnIp;
    }

    public String getReferer() {
        if (TextUtils.isEmpty((CharSequence)this.referer)) {
            this.referer = "";
        }
        return this.referer;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getVideoType() {
        if (TextUtils.isEmpty((CharSequence)this.videoType)) {
            this.videoType = "";
        }
        return this.videoType;
    }

    public String getVideoUrl() {
        if (TextUtils.isEmpty((CharSequence)this.videoUrl)) {
            this.videoUrl = "";
        }
        return this.videoUrl;
    }

    public String getUserAccount() {
        if (TextUtils.isEmpty((CharSequence)this.userAccount)) {
            this.userAccount = "0";
        }
        return this.userAccount;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getDeviceBrand() {
        return this.deviceBrand;
    }

    public String getDeviceManufacture() {
        return this.deviceManufacture;
    }

    public static enum Ui {
        saas_player;

    }

    public static enum TerminalType {
        pc,
        phone,
        pad;

    }

    public static enum VideoType {
        live,
        vod;

    }

    public static enum LogLevel {
        debug,
        info,
        warn,
        error;

    }
}

