/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.clientinforeport.core;

import com.aliyun.clientinforeport.AlivcEventPublicParam;
import com.aliyun.clientinforeport.core.PublicParamChecker;
import com.aliyun.clientinforeport.util.RLog;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.json.JSONObject;

public class LogSender {
    private static final String TAG = "LogSender";
    private static String logPushUrl = "http://videocloud.cn-hangzhou.log.aliyuncs.com/logstores/";
    private static String trackVersion = "/track?APIVersion=0.6.0";
    public static final String KEY_TIME = "t";
    public static final String KEY_LOG_LEVEL = "ll";
    public static final String KEY_LOG_VERSION = "lv";
    public static final String KEY_PRODUCT = "pd";
    public static final String KEY_MODULE = "md";
    public static final String KEY_SUB_MODULE = "sm";
    public static final String KEY_HOSTNAME = "hn";
    public static final String KEY_BUSINESS_ID = "bi";
    public static final String KEY_REQUEST_ID = "ri";
    public static final String KEY_EVENT = "e";
    public static final String KEY_ARGS = "args";
    public static final String KEY_VIDEO_TYPE = "vt";
    public static final String KEY_TERMINAL_TYPE = "tt";
    public static final String KEY_DEVICE_MODEL = "dm";
    public static final String KEY_DEVICE_BRAND = "db";
    public static final String KEY_DEVICE_MANUFACTURER = "dma";
    public static final String KEY_OPERATION_SYSTEM = "os";
    public static final String KEY_OSVERSION = "ov";
    public static final String KEY_APP_VERSION = "av";
    public static final String KEY_UUID = "uuid";
    public static final String KEY_VIDEO_URL = "vu";
    public static final String KEY_CONNECTION = "co";
    public static final String KEY_USER_AGENT = "uat";
    public static final String KEY_APPLICATION_ID = "app_id";
    public static final String KEY_APPLICATION_NAME = "app_n";
    public static final String KEY_CDN_IP = "cdn_ip";
    public static final String KEY_REFER = "r";

    public static void sendActually(AlivcEventPublicParam alivcEventPublicParam, int eventId, Map<String, String> eventArgs) {
        if (alivcEventPublicParam == null) {
            throw new IllegalAccessError("report log's publicparam can NOT be null!");
        }
        PublicParamChecker.checkParam(alivcEventPublicParam, eventId);
        String logBaseUrl = logPushUrl + alivcEventPublicParam.getLogStore() + trackVersion;
        String eventParam = LogSender.formatEventArgs(eventArgs);
        String logFinalUrl = LogSender.formatFinalUrl(logBaseUrl, alivcEventPublicParam, eventId, eventParam);
        RLog.d(TAG, "logFinalUrl " + logFinalUrl);
        RLog.d(TAG, "requestId =  " + alivcEventPublicParam.getRequestId());
        try {
            String ret = LogSender.doHttpGet(logFinalUrl);
            RLog.i(TAG, "onResponse " + ret);
        }
        catch (Exception e) {
            RLog.e(TAG, e.getMessage());
        }
    }

    private static String doHttpGet(String serverURL) throws Exception {
        URL url = new URL(serverURL);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(10000);
        connection.setReadTimeout(10000);
        InputStream in = connection.getInputStream();
        BufferedReader bufr = new BufferedReader(new InputStreamReader(in));
        StringBuilder response = new StringBuilder();
        String line = null;
        while ((line = bufr.readLine()) != null) {
            response.append(line);
        }
        int responseCode = connection.getResponseCode();
        connection.disconnect();
        if (responseCode == 200) {
            return response.toString();
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("StatusCode", responseCode);
        jsonObject.put("ResponseStr", (Object)response.toString());
        return jsonObject.toString();
    }

    private static String formatEventArgs(Map<String, String> eventArgs) {
        if (eventArgs != null && eventArgs.size() > 0) {
            StringBuilder argsStr = new StringBuilder();
            for (Map.Entry<String, String> entry : eventArgs.entrySet()) {
                argsStr.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            argsStr.deleteCharAt(argsStr.lastIndexOf("&"));
            try {
                return URLEncoder.encode(argsStr.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                RLog.e(TAG, e.toString());
                return "";
            }
        }
        return "";
    }

    private static String formatFinalUrl(String logBaseUrl, AlivcEventPublicParam alivcEventPublicParam, int eventId, String eventParam) {
        StringBuilder logUrlBuilder = new StringBuilder(logBaseUrl).append("&");
        logUrlBuilder.append(KEY_TIME).append("=").append(alivcEventPublicParam.getTime()).append("&");
        logUrlBuilder.append(KEY_LOG_LEVEL).append("=").append(alivcEventPublicParam.getLogLevel()).append("&");
        logUrlBuilder.append(KEY_LOG_VERSION).append("=").append(alivcEventPublicParam.getLogVersion()).append("&");
        logUrlBuilder.append(KEY_PRODUCT).append("=").append(alivcEventPublicParam.getProduct()).append("&");
        logUrlBuilder.append(KEY_MODULE).append("=").append(alivcEventPublicParam.getModule()).append("&");
        logUrlBuilder.append(KEY_SUB_MODULE).append("=").append(alivcEventPublicParam.getSubModule()).append("&");
        logUrlBuilder.append(KEY_HOSTNAME).append("=").append(alivcEventPublicParam.getHostName()).append("&");
        logUrlBuilder.append(KEY_BUSINESS_ID).append("=").append(alivcEventPublicParam.getBusinessId()).append("&");
        logUrlBuilder.append(KEY_REQUEST_ID).append("=").append(alivcEventPublicParam.getRequestId()).append("&");
        logUrlBuilder.append(KEY_EVENT).append("=").append(eventId).append("&");
        logUrlBuilder.append(KEY_ARGS).append("=").append(eventParam).append("&");
        logUrlBuilder.append(KEY_VIDEO_TYPE).append("=").append(alivcEventPublicParam.getVideoType()).append("&");
        logUrlBuilder.append(KEY_TERMINAL_TYPE).append("=").append(alivcEventPublicParam.getTerminalType()).append("&");
        logUrlBuilder.append(KEY_DEVICE_MODEL).append("=").append(alivcEventPublicParam.getDeviceModel()).append("&");
        logUrlBuilder.append(KEY_DEVICE_BRAND).append("=").append(alivcEventPublicParam.getDeviceBrand()).append("&");
        logUrlBuilder.append(KEY_DEVICE_MANUFACTURER).append("=").append(alivcEventPublicParam.getDeviceManufacture()).append("&");
        logUrlBuilder.append(KEY_OPERATION_SYSTEM).append("=").append(alivcEventPublicParam.getOperationSystem()).append("&");
        logUrlBuilder.append(KEY_OSVERSION).append("=").append(alivcEventPublicParam.getOsVersion()).append("&");
        logUrlBuilder.append(KEY_APP_VERSION).append("=").append(alivcEventPublicParam.getAppVersion()).append("&");
        logUrlBuilder.append(KEY_UUID).append("=").append(alivcEventPublicParam.getUuid()).append("&");
        logUrlBuilder.append(KEY_VIDEO_URL).append("=").append(alivcEventPublicParam.getVideoUrl()).append("&");
        logUrlBuilder.append(KEY_CONNECTION).append("=").append(alivcEventPublicParam.getConnection()).append("&");
        logUrlBuilder.append(KEY_USER_AGENT).append("=").append(alivcEventPublicParam.getUserAgent()).append("&");
        logUrlBuilder.append(KEY_APPLICATION_ID).append("=").append(alivcEventPublicParam.getApplicationId()).append("&");
        logUrlBuilder.append(KEY_APPLICATION_NAME).append("=").append(alivcEventPublicParam.getApplicationName()).append("&");
        logUrlBuilder.append(KEY_CDN_IP).append("=").append(alivcEventPublicParam.getCdnIp()).append("&");
        logUrlBuilder.append(KEY_REFER).append("=").append(alivcEventPublicParam.getReferer()).append("&");
        logUrlBuilder.deleteCharAt(logUrlBuilder.lastIndexOf("&"));
        return logUrlBuilder.toString();
    }
}

