/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.capture;

import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.audiofx.AcousticEchoCanceler;
import android.os.Process;
import android.telephony.TelephonyManager;
import com.alivc.live.pusher.LogUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

public class AudioPusher {
    private static final String TAG = "AudioPusher";
    private final int NTP_TIME_OUT_MILLISECOND = 1000;
    private int minBufferSize;
    private int maxBufferSize;
    private AudioRecord audioRecord;
    private int mSampleRateInHz = 44100;
    private AcousticEchoCanceler mAEC;
    private boolean mPusherRuning = false;
    private boolean mRegisterCallback = false;
    private AudioSourceListener mAudioSourceListener = null;
    private Status mStatus;
    private Context mContext = null;
    private byte[] mMuteData = null;
    private int mFrameSize;
    private TelephonyManager telephonyManager = null;
    private int mAudioChannel = 16;
    private int mAudioFormat = 2;
    private int mAudioFormatBits = 2;
    private long mTimeDelta = 0L;
    private AudioManager mAudioManager = null;
    private BluetoothAdapter mBluetoothAdapter = null;
    final int HEADSET_NONE = -1;
    final int BLUTOOTH_A2DP = 2;
    final int BLUTOOTH_HEADSET = 1;
    final int BLUTOOTH_HEALTH = 3;
    final int WIRE_HEADSET = 10;
    private boolean restartPause = false;
    long startTime = 0L;
    long allSendedSize = 0L;
    ScheduledExecutorService mExecutorService = Executors.newSingleThreadScheduledExecutor();

    public AudioPusher() {
        LogUtil.d(TAG, "new AudioPusher.");
        this.mStatus = Status.STOPED;
    }

    public void init(int n2, int n3, int n4, int n5, int n6, Context context) {
        this.mContext = context;
        this.mSampleRateInHz = n4;
        this.mAudioChannel = n3;
        this.mFrameSize = n6;
        this.mAudioFormat = n5;
        if (this.mAudioFormat == 3) {
            this.mAudioFormatBits = 1;
        } else if (this.mAudioFormat == 4) {
            this.mAudioFormatBits = 4;
        }
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        }
        LogUtil.d(TAG, "====> Init src: " + n2 + ", channel: " + n3 + ", sampleRate:" + n4 + ", format:" + n5 + ", frameSize:" + n6);
    }

    public void start() {
        LogUtil.d(TAG, "start.");
        if (this.mStatus != Status.STOPED) {
            return;
        }
        if (this.mMuteData == null) {
            this.mMuteData = new byte[this.mFrameSize];
            for (int i2 = 0; i2 < this.mFrameSize; ++i2) {
                this.mMuteData[i2] = 0;
            }
        }
        this.minBufferSize = AudioRecord.getMinBufferSize((int)this.mSampleRateInHz, (int)this.mAudioChannel, (int)this.mAudioFormat);
        if (this.minBufferSize <= this.mFrameSize) {
            this.minBufferSize = this.mFrameSize;
        }
        try {
            this.audioRecord = new AudioRecord(0, this.mSampleRateInHz, this.mAudioChannel, this.mAudioFormat, this.minBufferSize * 20);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (this.audioRecord == null) {
            return;
        }
        try {
            this.mAEC = AcousticEchoCanceler.create((int)this.audioRecord.getAudioSessionId());
            if (this.mAEC != null) {
                this.mAEC.setEnabled(false);
                if (this.mAEC.getEnabled()) {
                    this.mAEC.setEnabled(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.maxBufferSize = this.minBufferSize * 10;
        this.mStatus = Status.RUNNING;
        this.mPusherRuning = true;
        if (this.audioRecord.getRecordingState() == 1) {
            try {
                this.audioRecord.startRecording();
            }
            catch (Exception exception) {
                this.mStatus = Status.STOPED;
                this.mPusherRuning = false;
                this.audioRecord.release();
                this.audioRecord = null;
                return;
            }
            try {
                int n2 = 0;
                byte[] byArray = new byte[256];
                n2 = this.audioRecord.read(byArray, 0, byArray.length);
                LogUtil.d("======", "audioRecord read len " + n2);
                if (n2 < 0) {
                    this.mStatus = Status.STOPED;
                    this.mPusherRuning = false;
                    this.audioRecord.release();
                    this.audioRecord = null;
                    return;
                }
            }
            catch (Exception exception) {
                this.mStatus = Status.STOPED;
                this.mPusherRuning = false;
                this.audioRecord.release();
                this.audioRecord = null;
                return;
            }
            LogUtil.d(TAG, "new thread and start thread. " + this.audioRecord.getRecordingState());
            if (this.audioRecord.getRecordingState() == 1) {
                this.mPusherRuning = false;
                this.audioRecord.release();
                this.audioRecord = null;
                throw new IllegalStateException("audio record read fail");
            }
            this.mExecutorService.execute(new AudioRecordTask());
        }
    }

    public boolean isPushing() {
        return this.mPusherRuning;
    }

    public void pause() {
        LogUtil.d(TAG, "pause.");
        if (this.mStatus == Status.RUNNING) {
            this.mStatus = Status.PAUSED;
        }
    }

    public void resume() {
        LogUtil.d(TAG, "resume.");
        if (this.mStatus == Status.PAUSED) {
            this.mStatus = Status.RUNNING;
        }
    }

    public void stop() {
        LogUtil.d(TAG, "stop.");
        if (null == this.audioRecord) {
            return;
        }
        this.mPusherRuning = false;
        if (this.mStatus != Status.STOPED) {
            this.mStatus = Status.STOPED;
            if (this.audioRecord.getRecordingState() == 3) {
                this.audioRecord.stop();
            }
        }
        if (this.mAEC != null) {
            this.mAEC.setEnabled(false);
            this.mAEC.release();
            this.mAEC = null;
        }
        if (this.mAudioManager.isBluetoothScoOn()) {
            this.mAudioManager.setBluetoothScoOn(false);
            this.mAudioManager.stopBluetoothSco();
        }
    }

    public void destroy() {
        LogUtil.d(TAG, "destroy.");
        if (null == this.audioRecord) {
            return;
        }
        this.mPusherRuning = false;
        if (this.audioRecord.getRecordingState() == 1) {
            this.audioRecord.release();
        }
        this.audioRecord = null;
        this.mAudioManager = null;
        this.mContext = null;
        this.mMuteData = null;
        if (this.mExecutorService != null) {
            this.mExecutorService.shutdown();
            this.mExecutorService = null;
        }
    }

    public void setAudioSourceListener(AudioSourceListener audioSourceListener) {
        this.mAudioSourceListener = audioSourceListener;
    }

    private boolean isTelephonyCalling() {
        boolean bl = false;
        if (this.mContext != null) {
            if (this.telephonyManager == null) {
                this.telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
            }
            if (2 == this.telephonyManager.getCallState() || 1 == this.telephonyManager.getCallState()) {
                bl = true;
            }
        }
        return bl;
    }

    class AudioRecordTask
    implements Runnable {
        AudioRecordTask() {
        }

        @Override
        public void run() {
            LogUtil.d(AudioPusher.TAG, "run begin ." + AudioPusher.this.mPusherRuning + " " + AudioPusher.this.audioRecord.getRecordingState());
            try {
                Process.setThreadPriority((int)-19);
            }
            catch (Exception exception) {
                LogUtil.e(AudioPusher.TAG, "Set record thread priority failed: " + exception.getMessage());
            }
            byte[] byArray = new byte[AudioPusher.this.mFrameSize];
            long l2 = -1L;
            long l3 = 0L;
            long l4 = AudioPusher.this.audioRecord.getSampleRate() * AudioPusher.this.audioRecord.getChannelCount() * AudioPusher.this.mAudioFormatBits;
            AudioPusher.this.startTime = System.nanoTime();
            AudioPusher.this.allSendedSize = 0L;
            while (AudioPusher.this.mPusherRuning) {
                long l5;
                long l6;
                long l7;
                long l8;
                if (AudioPusher.this.mPusherRuning && AudioPusher.this.restartPause) {
                    try {
                        Thread.sleep(40L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (AudioPusher.this.audioRecord.getRecordingState() != 3) break;
                int n2 = AudioPusher.this.audioRecord.read(byArray, 0, byArray.length);
                if (0 >= n2) continue;
                if (AudioPusher.this.mStatus == Status.PAUSED && l2 < 0L && AudioPusher.this.isTelephonyCalling()) {
                    l2 = System.nanoTime();
                    LogUtil.d("======", "Pause: cur " + l2);
                }
                if (l2 > 0L && !AudioPusher.this.isTelephonyCalling()) {
                    l2 = -1L;
                    l3 = 0L;
                    l8 = AudioPusher.this.allSendedSize * 1000L / l4;
                    l7 = (System.nanoTime() - AudioPusher.this.startTime) / 1000000L;
                    LogUtil.d(AudioPusher.TAG, "BlueTooth: Alarm, audio capture lower, sendDueTime " + l7 + ",sendedTime " + l8);
                    if (l7 - l8 > 100L) {
                        l6 = l4 * l7 / 1000L - AudioPusher.this.allSendedSize;
                        LogUtil.d(AudioPusher.TAG, "BlueTooth: Alarm, audio capture lower, sendDueTime " + l7 + ",sendedTime " + l8 + ", compensateSize " + l6);
                        while (l6 > 0L) {
                            l5 = l6 > (long)AudioPusher.this.mFrameSize ? (long)AudioPusher.this.mFrameSize : l6;
                            l6 -= l5;
                            AudioPusher.this.mAudioSourceListener.onAudioFrame(AudioPusher.this.mMuteData, (int)l5, System.nanoTime() / 1000L + AudioPusher.this.mTimeDelta, AudioPusher.this.audioRecord.getAudioFormat(), AudioPusher.this.audioRecord.getChannelCount(), AudioPusher.this.audioRecord.getSampleRate());
                            AudioPusher.this.allSendedSize += l5;
                        }
                    }
                }
                if (AudioPusher.this.mTimeDelta == 0L) {
                    AudioPusher.this.mTimeDelta = System.currentTimeMillis() * 1000L - System.nanoTime() / 1000L;
                }
                if (l2 > 0L) {
                    l8 = l4 * (System.nanoTime() - l2) / 1000000000L;
                    l3 += (l8 -= l3);
                    while (l8 > 0L) {
                        l7 = l8 > (long)AudioPusher.this.mFrameSize ? (long)AudioPusher.this.mFrameSize : l8;
                        l8 -= l7;
                        AudioPusher.this.mAudioSourceListener.onAudioFrame(AudioPusher.this.mMuteData, (int)l7, System.nanoTime() / 1000L + AudioPusher.this.mTimeDelta, AudioPusher.this.audioRecord.getAudioFormat(), AudioPusher.this.audioRecord.getChannelCount(), AudioPusher.this.audioRecord.getSampleRate());
                        AudioPusher.this.allSendedSize += l7;
                    }
                    continue;
                }
                if (AudioPusher.this.mAudioSourceListener == null) continue;
                AudioPusher.this.mAudioSourceListener.onAudioFrame(byArray, n2, System.nanoTime() / 1000L + AudioPusher.this.mTimeDelta, AudioPusher.this.audioRecord.getAudioFormat(), AudioPusher.this.audioRecord.getChannelCount(), AudioPusher.this.audioRecord.getSampleRate());
                AudioPusher.this.allSendedSize += (long)n2;
                l8 = AudioPusher.this.allSendedSize * 1000L / l4;
                l7 = (System.nanoTime() - AudioPusher.this.startTime) / 1000000L;
                LogUtil.d(AudioPusher.TAG, "Alarm, audio capture lower, sendDueTime " + l7 + ",sendedTime " + l8);
                if (l7 - l8 <= 100L) continue;
                l6 = l4 * l7 / 1000L - AudioPusher.this.allSendedSize;
                LogUtil.d(AudioPusher.TAG, "BlueTooth: Alarm, audio capture lower, sendDueTime " + l7 + ",sendedTime " + l8 + ", compensateSize " + l6);
                while (l6 > 0L) {
                    l5 = l6 > (long)AudioPusher.this.mFrameSize ? (long)AudioPusher.this.mFrameSize : l6;
                    l6 -= l5;
                    AudioPusher.this.mAudioSourceListener.onAudioFrame(AudioPusher.this.mMuteData, (int)l5, System.nanoTime() / 1000L + AudioPusher.this.mTimeDelta, AudioPusher.this.audioRecord.getAudioFormat(), AudioPusher.this.audioRecord.getChannelCount(), AudioPusher.this.audioRecord.getSampleRate());
                    AudioPusher.this.allSendedSize += l5;
                }
            }
        }
    }

    public static interface AudioSourceListener {
        public void onAudioFrame(byte[] var1, int var2, long var3, int var5, int var6, int var7);
    }

    static enum Status {
        STOPED,
        PAUSED,
        RUNNING;

    }
}

