/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.capture;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.CountDownTimer;
import android.util.Log;
import java.util.List;

public abstract class BluetoothHeadsetUtils {
    private Context mContext;
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothHeadset mBluetoothHeadset;
    private BluetoothDevice mConnectedHeadset;
    private AudioManager mAudioManager;
    private boolean mIsCountDownOn;
    private boolean mIsStarting;
    private boolean mIsOnHeadsetSco;
    private boolean mIsStarted;
    private static final String TAG = "BluetoothHeadsetUtils";
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if (string.equals("android.bluetooth.device.action.ACL_CONNECTED")) {
                int n2;
                BluetoothHeadsetUtils.this.mConnectedHeadset = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                BluetoothClass bluetoothClass = BluetoothHeadsetUtils.this.mConnectedHeadset.getBluetoothClass();
                if (bluetoothClass != null && ((n2 = bluetoothClass.getDeviceClass()) == 1032 || n2 == 1028)) {
                    BluetoothHeadsetUtils.this.mAudioManager.setMode(2);
                    BluetoothHeadsetUtils.this.mIsCountDownOn = true;
                    BluetoothHeadsetUtils.this.mCountDown.start();
                    BluetoothHeadsetUtils.this.onBlueToothHeadsetConnected();
                }
                Log.d((String)BluetoothHeadsetUtils.TAG, (String)(BluetoothHeadsetUtils.this.mConnectedHeadset.getName() + " connected"));
            } else if (string.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Headset disconnected");
                if (BluetoothHeadsetUtils.this.mIsCountDownOn) {
                    BluetoothHeadsetUtils.this.mIsCountDownOn = false;
                    BluetoothHeadsetUtils.this.mCountDown.cancel();
                }
                BluetoothHeadsetUtils.this.mAudioManager.setMode(0);
                BluetoothHeadsetUtils.this.onBlueToothHeadsetDisconnected();
            } else if (string.equals("android.media.SCO_AUDIO_STATE_CHANGED")) {
                int n3 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                if (n3 == 1) {
                    BluetoothHeadsetUtils.this.mIsOnHeadsetSco = true;
                    if (BluetoothHeadsetUtils.this.mIsStarting) {
                        BluetoothHeadsetUtils.this.mIsStarting = false;
                        BluetoothHeadsetUtils.this.onHeadsetConnected();
                    }
                    if (BluetoothHeadsetUtils.this.mIsCountDownOn) {
                        BluetoothHeadsetUtils.this.mIsCountDownOn = false;
                        BluetoothHeadsetUtils.this.mCountDown.cancel();
                    }
                    BluetoothHeadsetUtils.this.onScoAudioConnected();
                    Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Sco connected");
                } else if (n3 == 0) {
                    Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Sco disconnected");
                    if (!BluetoothHeadsetUtils.this.mIsStarting) {
                        BluetoothHeadsetUtils.this.mIsOnHeadsetSco = false;
                        BluetoothHeadsetUtils.this.mAudioManager.stopBluetoothSco();
                        BluetoothHeadsetUtils.this.onScoAudioDisconnected();
                    }
                }
            }
        }
    };
    private CountDownTimer mCountDown = new CountDownTimer(10000L, 1000L){

        public void onTick(long l2) {
            BluetoothHeadsetUtils.this.mAudioManager.startBluetoothSco();
            Log.d((String)BluetoothHeadsetUtils.TAG, (String)"\nonTick start bluetooth Sco");
        }

        public void onFinish() {
            BluetoothHeadsetUtils.this.mIsCountDownOn = false;
            BluetoothHeadsetUtils.this.mAudioManager.setMode(0);
            Log.d((String)BluetoothHeadsetUtils.TAG, (String)"\nonFinish fail to connect to headset audio");
        }
    };
    private BluetoothProfile.ServiceListener mHeadsetProfileListener = new BluetoothProfile.ServiceListener(){

        public void onServiceDisconnected(int n2) {
            Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Profile listener onServiceDisconnected");
            BluetoothHeadsetUtils.this.stopBluetooth11();
        }

        @TargetApi(value=11)
        public void onServiceConnected(int n2, BluetoothProfile bluetoothProfile) {
            Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Profile listener onServiceConnected");
            BluetoothHeadsetUtils.this.mBluetoothHeadset = (BluetoothHeadset)bluetoothProfile;
            List list = BluetoothHeadsetUtils.this.mBluetoothHeadset.getConnectedDevices();
            if (list.size() > 0) {
                BluetoothHeadsetUtils.this.mConnectedHeadset = (BluetoothDevice)list.get(0);
                BluetoothHeadsetUtils.this.onHeadsetConnected();
                BluetoothHeadsetUtils.this.mIsCountDownOn = true;
                BluetoothHeadsetUtils.this.mCountDown11.start();
                Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Start count down");
            }
            BluetoothHeadsetUtils.this.mContext.registerReceiver(BluetoothHeadsetUtils.this.mHeadsetBroadcastReceiver, new IntentFilter("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED"));
            BluetoothHeadsetUtils.this.mContext.registerReceiver(BluetoothHeadsetUtils.this.mHeadsetBroadcastReceiver, new IntentFilter("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED"));
        }
    };
    private BroadcastReceiver mHeadsetBroadcastReceiver = new BroadcastReceiver(){

        @TargetApi(value=11)
        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if (string.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int n2 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                Log.d((String)BluetoothHeadsetUtils.TAG, (String)("\nAction = " + string + "\nState = " + n2));
                if (n2 == 2) {
                    BluetoothHeadsetUtils.this.mConnectedHeadset = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    BluetoothHeadsetUtils.this.mIsCountDownOn = true;
                    BluetoothHeadsetUtils.this.mCountDown11.start();
                    BluetoothHeadsetUtils.this.onBlueToothHeadsetConnected();
                    Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Start count down");
                } else if (n2 == 0) {
                    if (BluetoothHeadsetUtils.this.mIsCountDownOn) {
                        BluetoothHeadsetUtils.this.mIsCountDownOn = false;
                        BluetoothHeadsetUtils.this.mCountDown11.cancel();
                    }
                    BluetoothHeadsetUtils.this.mConnectedHeadset = null;
                    BluetoothHeadsetUtils.this.onBlueToothHeadsetConnected();
                    Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Headset disconnected");
                }
            } else {
                int n3 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                Log.d((String)BluetoothHeadsetUtils.TAG, (String)("\nAction = " + string + "\nState = " + n3));
                if (n3 == 12) {
                    Log.d((String)BluetoothHeadsetUtils.TAG, (String)"\nHeadset audio connected");
                    BluetoothHeadsetUtils.this.mIsOnHeadsetSco = true;
                    if (BluetoothHeadsetUtils.this.mIsCountDownOn) {
                        BluetoothHeadsetUtils.this.mIsCountDownOn = false;
                        BluetoothHeadsetUtils.this.mCountDown11.cancel();
                    }
                    BluetoothHeadsetUtils.this.onScoAudioConnected();
                } else if (n3 == 10) {
                    BluetoothHeadsetUtils.this.mIsOnHeadsetSco = false;
                    BluetoothHeadsetUtils.this.mBluetoothHeadset.stopVoiceRecognition(BluetoothHeadsetUtils.this.mConnectedHeadset);
                    BluetoothHeadsetUtils.this.onScoAudioDisconnected();
                    Log.d((String)BluetoothHeadsetUtils.TAG, (String)"Headset audio disconnected");
                }
            }
        }
    };
    private CountDownTimer mCountDown11 = new CountDownTimer(10000L, 1000L){

        @TargetApi(value=11)
        public void onTick(long l2) {
            BluetoothHeadsetUtils.this.mBluetoothHeadset.startVoiceRecognition(BluetoothHeadsetUtils.this.mConnectedHeadset);
            Log.d((String)BluetoothHeadsetUtils.TAG, (String)"onTick startVoiceRecognition");
        }

        public void onFinish() {
            BluetoothHeadsetUtils.this.mIsCountDownOn = false;
            Log.d((String)BluetoothHeadsetUtils.TAG, (String)"\nonFinish fail to connect to headset audio");
        }
    };
    private BroadcastReceiver mHeadsetPlugReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.intent.action.HEADSET_PLUG".equals(string) && intent.hasExtra("state")) {
                if (intent.getIntExtra("state", 0) == 0) {
                    BluetoothHeadsetUtils.this.mAudioManager.setMode(0);
                    BluetoothHeadsetUtils.this.mAudioManager.setSpeakerphoneOn(true);
                    BluetoothHeadsetUtils.this.onHeadSetDisconnected();
                } else if (intent.getIntExtra("state", 0) == 1) {
                    BluetoothHeadsetUtils.this.mAudioManager.setSpeakerphoneOn(false);
                    BluetoothHeadsetUtils.this.onHeadsetConnected();
                }
            }
        }
    };

    public BluetoothHeadsetUtils(Context context) {
        this.mContext = context;
        this.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        this.mContext.registerReceiver(this.mHeadsetPlugReceiver, intentFilter);
    }

    public boolean start() {
        if (!this.mIsStarted) {
            this.mIsStarted = true;
            this.mIsStarted = Build.VERSION.SDK_INT < 11 ? this.startBluetooth() : this.startBluetooth11();
        }
        return this.mIsStarted;
    }

    public void stop() {
        if (this.mIsStarted) {
            this.mIsStarted = false;
            if (Build.VERSION.SDK_INT < 11) {
                this.stopBluetooth();
            } else {
                this.stopBluetooth11();
            }
        }
    }

    public boolean isOnHeadsetSco() {
        return this.mIsOnHeadsetSco;
    }

    public abstract void onBlueToothHeadsetDisconnected();

    public abstract void onBlueToothHeadsetConnected();

    public abstract void onScoAudioDisconnected();

    public abstract void onScoAudioConnected();

    public abstract void onHeadsetConnected();

    public abstract void onHeadSetDisconnected();

    private boolean startBluetooth() {
        Log.d((String)TAG, (String)"startBluetooth");
        if (this.mBluetoothAdapter != null && this.mAudioManager.isBluetoothScoAvailableOffCall()) {
            this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.ACL_CONNECTED"));
            this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.ACL_DISCONNECTED"));
            this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.media.SCO_AUDIO_STATE_CHANGED"));
            this.mAudioManager.setMode(2);
            this.mIsCountDownOn = true;
            this.mCountDown.start();
            this.mIsStarting = true;
            return true;
        }
        return false;
    }

    @TargetApi(value=11)
    private boolean startBluetooth11() {
        Log.d((String)TAG, (String)"startBluetooth11");
        return this.mBluetoothAdapter != null && this.mAudioManager.isBluetoothScoAvailableOffCall() && this.mBluetoothAdapter.getProfileProxy(this.mContext, this.mHeadsetProfileListener, 1);
    }

    private void stopBluetooth() {
        Log.d((String)TAG, (String)"stopBluetooth");
        if (this.mIsCountDownOn) {
            this.mIsCountDownOn = false;
            this.mCountDown.cancel();
        }
        this.mContext.unregisterReceiver(this.mBroadcastReceiver);
        this.mAudioManager.stopBluetoothSco();
        this.mAudioManager.setMode(0);
    }

    @TargetApi(value=11)
    protected void stopBluetooth11() {
        Log.d((String)TAG, (String)"stopBluetooth11");
        if (this.mIsCountDownOn) {
            this.mIsCountDownOn = false;
            this.mCountDown11.cancel();
        }
        if (this.mBluetoothHeadset != null) {
            this.mBluetoothHeadset.stopVoiceRecognition(this.mConnectedHeadset);
            this.mContext.unregisterReceiver(this.mHeadsetBroadcastReceiver);
            this.mBluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.mBluetoothHeadset);
            this.mBluetoothHeadset = null;
        }
    }
}

