/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.capture;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.SurfaceTexture;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.util.DisplayMetrics;
import android.view.Surface;
import com.alivc.component.capture.ScreenVideoParam;
import com.alivc.live.pusher.LogUtil;

@TargetApi(value=21)
public class ScreenPusher {
    private static final String TAG = "ScreenPusher";
    private ScreenVideoParam mParam;
    private Surface mSurface = null;
    private static final int DISPLAY_FLAGS = 3;
    private int VIRTUAL_DISPLAY_DPI = 400;
    private Intent mediaProjectionPermissionResultData = null;
    private MediaProjection.Callback mediaProjectionCallback = new MediaProjection.Callback(){

        public void onStop() {
            super.onStop();
        }
    };
    private VirtualDisplay virtualDisplay;
    private SurfaceTexture mSurfaceTexture = null;
    private MediaProjection mediaProjection;
    private MediaProjectionManager mediaProjectionManager = null;
    private VideoSourceTextureListener mVideoSourceTextureListener = null;
    private long mTimeDelta = 0L;
    private boolean mPause = false;
    private long mLastCaptureTime = 0L;
    private int mLastFpsCounter = 0;
    private SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            long l2 = System.currentTimeMillis();
            if (ScreenPusher.this.mVideoSourceTextureListener != null) {
                if (ScreenPusher.this.mTimeDelta == 0L) {
                    ScreenPusher.this.mTimeDelta = System.currentTimeMillis() * 1000L - System.nanoTime() / 1000L;
                }
                if (!ScreenPusher.this.mPause && ScreenPusher.this.mParam != null) {
                    ScreenPusher.this.mVideoSourceTextureListener.onVideoFrame((System.nanoTime() / 1000L + ScreenPusher.this.mTimeDelta) / 1L, ScreenPusher.this.mParam.getWidth(), ScreenPusher.this.mParam.getHeight(), 17);
                }
            }
            ScreenPusher.this.mLastCaptureTime = System.currentTimeMillis();
            ScreenPusher.this.mLastFpsCounter++;
        }
    };

    public void init(int n2, int n3, int n4, int n5, Intent intent, Context context) {
        this.mParam = new ScreenVideoParam(n3, n4, n5, n2, 0);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.VIRTUAL_DISPLAY_DPI = displayMetrics.densityDpi;
        this.mediaProjectionPermissionResultData = intent;
        this.mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        LogUtil.d("VideoPusher", "====> Init src: " + n2 + ", width: " + n3 + ", height:" + n4 + ", fps:" + n5);
    }

    public void start(int n2) {
        LogUtil.d(TAG, "start.");
        if (this.mediaProjectionPermissionResultData == null || this.mediaProjectionManager == null) {
            throw new Exception("invalid parameters");
        }
        try {
            this.mediaProjection = this.mediaProjectionManager.getMediaProjection(-1, this.mediaProjectionPermissionResultData);
            this.mSurfaceTexture = new SurfaceTexture(n2);
            this.mSurface = new Surface(this.mSurfaceTexture);
            this.mSurfaceTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
            this.createVirtualDisplay();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createVirtualDisplay() {
        this.mSurfaceTexture.setDefaultBufferSize(this.mParam.getWidth(), this.mParam.getHeight());
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("AlivcScreenCapture", this.mParam.getWidth(), this.mParam.getHeight(), this.VIRTUAL_DISPLAY_DPI, 3, this.mSurface, null, null);
    }

    public void stop() {
        LogUtil.d(TAG, "stop.");
        if (this.virtualDisplay != null) {
            this.virtualDisplay.release();
            this.virtualDisplay = null;
        }
        if (this.mediaProjection != null) {
            this.mediaProjection.stop();
            this.mediaProjection = null;
        }
    }

    public void destroy() {
        LogUtil.d(TAG, "destroy.");
        this.mParam = null;
    }

    public void setVideoSourceTextureListener(VideoSourceTextureListener videoSourceTextureListener) {
        this.mVideoSourceTextureListener = videoSourceTextureListener;
    }

    public int updateTexImage() {
        if (this.mSurfaceTexture == null) {
            return -1;
        }
        this.mSurfaceTexture.updateTexImage();
        return 0;
    }

    public void getTransformMatrix(float[] fArray) {
        if (this.mSurfaceTexture == null) {
            return;
        }
        this.mSurfaceTexture.getTransformMatrix(fArray);
    }

    public static interface VideoSourceTextureListener {
        public void onVideoFrame(long var1, int var3, int var4, int var5);
    }
}

