/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.capture;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import com.alivc.component.capture.VideoParam;
import com.alivc.live.pusher.LogUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class VideoPusher {
    private static final String TAG = "VideoPusher";
    private final int TIME_MILLISECOND = 1000;
    private final float INITIATE_VALUE = -1.0f;
    private final float MAG_DELTA_DIFF = 5.0f;
    private final float ACCEL_DELTA_DIFF = 0.6f;
    private final float ACCEL_DELTAXYZ_DIFF = 1.4f;
    private static int MIN_CAP_RESOLUTION = 192;
    private static final int SCREEN_PORTRAIT = 0;
    private static final int SCREEN_LANDSCAPE_LEFT = 90;
    private static final int SCREEN_LANDSCAPE_RIGHT = 270;
    private static byte[] buffer = null;
    private static byte[] buffer1 = null;
    private static byte[] buffer2 = null;
    private static int supportMaxWH = 0;
    private boolean mPreviewRunning;
    private Camera mCamera;
    private VideoParam mParam;
    private int mScreen;
    private int mOrientation;
    private int mDataOrientation;
    private boolean mPause = false;
    private VideoSourceListener mVideoSourceListener = null;
    private VideoSourceTextureListener mVideoSourceTextureListener = null;
    private boolean mSwitchCamera = false;
    private long mLastCaptureTime = 0L;
    private long mLastFpsCountTime = 0L;
    private int mLastFpsCounter = 0;
    private int mBelowMinFpsNumberTimes = 0;
    private int mCurrentFps = 0;
    private long mTimeDelta = 0L;
    private boolean mSurfaceCbMode = false;
    private int mSurfaceTextureId = -1;
    private boolean mFlashOn = false;
    private boolean mAutoFocus = false;
    private boolean mAutoFocusing = false;
    private SurfaceTexture mSurfaceTexture = null;
    private SensorManager mSensorManager = null;
    private Sensor mAccelSensor = null;
    private Sensor mMagneticSensor = null;
    private float mLastXAccel = -1.0f;
    private float mLastYAccel = -1.0f;
    private float mLastZAccel = -1.0f;
    private float mLastXMag = -1.0f;
    private float mLastYMag = -1.0f;
    private float mLastZMag = -1.0f;
    private int mCustomRotation = 0;
    private boolean mSensorFocus = false;
    private static Map<Integer, List<Camera.Size>> sSupportedResolutionMap = new HashMap<Integer, List<Camera.Size>>();
    private static List<Integer> sSupportedFormat = new ArrayList<Integer>();
    private SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            long l2 = System.currentTimeMillis();
            if (VideoPusher.this.mVideoSourceTextureListener != null) {
                if (VideoPusher.this.mTimeDelta == 0L) {
                    VideoPusher.this.mTimeDelta = System.currentTimeMillis() * 1000L - System.nanoTime() / 1000L;
                }
                if (VideoPusher.this.mParam != null) {
                    if (VideoPusher.this.mCustomRotation > 0) {
                        VideoPusher.this.mVideoSourceTextureListener.onVideoFrame((System.nanoTime() / 1000L + VideoPusher.this.mTimeDelta) / 1L, VideoPusher.this.mParam.getCameraId(), VideoPusher.this.mCustomRotation, VideoPusher.this.mParam.getWidth(), VideoPusher.this.mParam.getHeight(), 17);
                    } else {
                        VideoPusher.this.mVideoSourceTextureListener.onVideoFrame((System.nanoTime() / 1000L + VideoPusher.this.mTimeDelta) / 1L, VideoPusher.this.mParam.getCameraId(), VideoPusher.this.mDataOrientation, VideoPusher.this.mParam.getWidth(), VideoPusher.this.mParam.getHeight(), 17);
                    }
                }
            }
            VideoPusher.this.mLastCaptureTime = System.currentTimeMillis();
            VideoPusher.this.mLastFpsCounter++;
        }
    };
    private Camera.PreviewCallback mPreviewCallback = new Camera.PreviewCallback(){

        public void onPreviewFrame(byte[] byArray, Camera camera) {
            long l2 = System.currentTimeMillis();
            if (VideoPusher.this.mVideoSourceListener != null) {
                if (VideoPusher.this.mTimeDelta == 0L) {
                    VideoPusher.this.mTimeDelta = System.currentTimeMillis() * 1000L - System.nanoTime() / 1000L;
                }
                if (!VideoPusher.this.mPause && VideoPusher.this.mParam != null) {
                    if (VideoPusher.this.mCustomRotation > 0) {
                        VideoPusher.this.mVideoSourceListener.onVideoFrame(byArray, (System.nanoTime() / 1000L + VideoPusher.this.mTimeDelta) / 1L, VideoPusher.this.mParam.getCameraId(), VideoPusher.this.mCustomRotation, VideoPusher.this.mParam.getWidth(), VideoPusher.this.mParam.getHeight(), 17);
                    } else {
                        VideoPusher.this.mVideoSourceListener.onVideoFrame(byArray, (System.nanoTime() / 1000L + VideoPusher.this.mTimeDelta) / 1L, VideoPusher.this.mParam.getCameraId(), VideoPusher.this.mDataOrientation, VideoPusher.this.mParam.getWidth(), VideoPusher.this.mParam.getHeight(), 17);
                    }
                }
            }
            VideoPusher.this.mLastCaptureTime = System.currentTimeMillis();
            VideoPusher.this.mLastFpsCounter++;
            if (VideoPusher.this.mLastFpsCountTime == 0L) {
                VideoPusher.this.mLastFpsCountTime = VideoPusher.this.mLastCaptureTime;
            }
            if (VideoPusher.this.mLastCaptureTime - VideoPusher.this.mLastFpsCountTime > 1000L) {
                LogUtil.d(VideoPusher.TAG, "StatLog: video capture fps = " + VideoPusher.this.mLastFpsCounter);
                VideoPusher.this.mCurrentFps = VideoPusher.this.mLastFpsCounter;
                if (VideoPusher.this.mLastFpsCounter < 12) {
                    if (VideoPusher.this.mBelowMinFpsNumberTimes > 5) {
                        VideoPusher.this.mBelowMinFpsNumberTimes = 0;
                    } else {
                        VideoPusher.this.mBelowMinFpsNumberTimes++;
                    }
                } else {
                    VideoPusher.this.mBelowMinFpsNumberTimes = 0;
                }
                VideoPusher.this.mLastFpsCounter = 0;
                VideoPusher.this.mLastFpsCountTime = VideoPusher.this.mLastCaptureTime;
            }
            if (camera != null) {
                camera.addCallbackBuffer(byArray);
            }
        }
    };
    private SensorEventListener mSensorEventListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent sensorEvent) {
            float f2;
            float f3;
            float f4;
            if (!VideoPusher.this.isPreviewRunning() || VideoPusher.this.mParam.getCameraId() != 0) {
                return;
            }
            if (sensorEvent.sensor.getType() == 2) {
                if (VideoPusher.this.mLastXMag == -1.0f) {
                    VideoPusher.this.mLastXMag = sensorEvent.values[0];
                    VideoPusher.this.mLastYMag = sensorEvent.values[1];
                    VideoPusher.this.mLastZMag = sensorEvent.values[2];
                    return;
                }
                f4 = Math.abs(VideoPusher.this.mLastXMag - sensorEvent.values[0]);
                f3 = Math.abs(VideoPusher.this.mLastYMag - sensorEvent.values[1]);
                f2 = Math.abs(VideoPusher.this.mLastZMag - sensorEvent.values[2]);
                if ((f4 > 5.0f || f3 > 5.0f || f2 > 5.0f) && !VideoPusher.this.mAutoFocusing) {
                    VideoPusher.this.cameraAutoFocus();
                    VideoPusher.this.mLastXMag = sensorEvent.values[0];
                    VideoPusher.this.mLastYMag = sensorEvent.values[1];
                    VideoPusher.this.mLastZMag = sensorEvent.values[2];
                }
            }
            if (sensorEvent.sensor.getType() == 1) {
                if (VideoPusher.this.mLastXAccel == -1.0f) {
                    VideoPusher.this.mLastXAccel = sensorEvent.values[0];
                    VideoPusher.this.mLastYAccel = sensorEvent.values[1];
                    VideoPusher.this.mLastZAccel = sensorEvent.values[2];
                    return;
                }
                f4 = Math.abs(VideoPusher.this.mLastXAccel - sensorEvent.values[0]);
                double d2 = Math.sqrt(f4 * f4 + (f3 = Math.abs(VideoPusher.this.mLastYAccel - sensorEvent.values[1])) * f3 + (f2 = Math.abs(VideoPusher.this.mLastZAccel - sensorEvent.values[2])) * f2);
                if (d2 > (double)1.4f && !VideoPusher.this.mAutoFocusing) {
                    VideoPusher.this.cameraAutoFocus();
                    VideoPusher.this.mLastXAccel = sensorEvent.values[0];
                    VideoPusher.this.mLastYAccel = sensorEvent.values[1];
                    VideoPusher.this.mLastZAccel = sensorEvent.values[2];
                    return;
                }
                if ((f4 > 0.6f || f3 > 0.6f || f2 > 0.6f) && !VideoPusher.this.mAutoFocusing) {
                    VideoPusher.this.cameraAutoFocus();
                    VideoPusher.this.mLastXAccel = sensorEvent.values[0];
                    VideoPusher.this.mLastYAccel = sensorEvent.values[1];
                    VideoPusher.this.mLastZAccel = sensorEvent.values[2];
                }
            }
        }

        public void onAccuracyChanged(Sensor sensor, int n2) {
        }
    };

    public void init(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, Context context) {
        this.mParam = new VideoParam(n3, n4, n5, n2, n6);
        this.mSurfaceCbMode = bl;
        this.mCustomRotation = n7;
        if (!this.mSurfaceCbMode) {
            this.mSurfaceTexture = new SurfaceTexture(10);
        }
        if (this.mSensorManager == null) {
            this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        }
        if (this.mAccelSensor == null) {
            this.mAccelSensor = this.mSensorManager.getDefaultSensor(1);
        }
        if (this.mMagneticSensor == null) {
            this.mMagneticSensor = this.mSensorManager.getDefaultSensor(2);
        }
        if (Build.MODEL.contains("MI MAX") || "MIX".equals(Build.MODEL) || "MIX 2".equals(Build.MODEL)) {
            this.mSensorFocus = true;
        }
        if (bl2) {
            this.mSensorFocus = true;
            LogUtil.d(TAG, "set focus by Sensor");
        }
        LogUtil.d(TAG, "====> Init src: " + n2 + ", width: " + n3 + ", height:" + n4 + ", fps:" + n5 + ", rotation:" + n6 + ", mSurfaceCbMode: " + this.mSurfaceCbMode);
    }

    private static void turnLightOn(Camera camera) {
        if (camera == null) {
            return;
        }
        Camera.Parameters parameters = camera.getParameters();
        if (parameters == null) {
            return;
        }
        List list = parameters.getSupportedFlashModes();
        if (list == null) {
            return;
        }
        String string = parameters.getFlashMode();
        if (!"torch".equals(string) && list.contains("torch")) {
            parameters.setFlashMode("torch");
            try {
                camera.setParameters(parameters);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private static void turnLightOff(Camera camera) {
        if (camera == null) {
            return;
        }
        Camera.Parameters parameters = camera.getParameters();
        if (parameters == null) {
            return;
        }
        List list = parameters.getSupportedFlashModes();
        String string = parameters.getFlashMode();
        if (list == null) {
            return;
        }
        if (!"off".equals(string)) {
            if (list.contains("off")) {
                parameters.setFlashMode("off");
                try {
                    camera.setParameters(parameters);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else {
                LogUtil.e(TAG, "FLASH_MODE_OFF not supported");
            }
        }
    }

    public void destroy() {
        LogUtil.d(TAG, "destroy.");
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
        }
        this.mSurfaceTexture = null;
        this.mParam = null;
    }

    public void switchCamera() {
        LogUtil.d(TAG, "switchCamera.");
        if (this.mParam.getCameraId() == 0) {
            this.mParam.setCameraId(1);
        } else {
            this.mParam.setCameraId(0);
        }
        this.stopInner();
        this.startInner();
    }

    public void setOrientation(int n2) {
        LogUtil.d(TAG, "setOrientation.");
    }

    public void stopInner() {
        LogUtil.d(TAG, "stopInner.");
        if (this.mSensorManager != null && this.mSensorFocus) {
            try {
                this.mSensorManager.unregisterListener(this.mSensorEventListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.mPreviewRunning && this.mCamera != null) {
            this.mCamera.setPreviewCallback(null);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
            this.mPreviewRunning = false;
            LogUtil.d(TAG, "stopInner over.");
        }
    }

    public void stop() {
        LogUtil.d(TAG, "stop.");
        this.stopInner();
        if (this.mSurfaceCbMode && this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
            this.mSurfaceTextureId = -1;
        }
    }

    public void start(int n2) {
        LogUtil.d(TAG, "start.");
        if (this.mSurfaceCbMode && n2 >= 0) {
            this.mSurfaceTextureId = n2;
            if (this.mSurfaceTexture != null) {
                this.mSurfaceTexture.release();
                this.mSurfaceTexture = null;
            }
            this.mSurfaceTexture = new SurfaceTexture(this.mSurfaceTextureId);
        } else if (this.mSurfaceCbMode && n2 < 0) {
            this.mSurfaceCbMode = false;
            if (this.mSurfaceTexture == null) {
                this.mSurfaceTexture = new SurfaceTexture(10);
            }
        }
        this.startInner();
    }

    public void startInner() {
        try {
            this.startPreview0();
        }
        catch (Throwable throwable) {
            this.stopInner();
            this.startPreview0();
        }
        if (this.mFlashOn) {
            this.setFlashOn(this.mFlashOn);
        }
        if (this.mAutoFocus) {
            this.setAutoFocus(this.mAutoFocus);
        }
        if (this.mSensorManager != null && this.mSensorFocus) {
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mAccelSensor, 2);
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mMagneticSensor, 2);
        }
    }

    private boolean isHasPermission() {
        try {
            Field field = this.mCamera.getClass().getDeclaredField("mHasPermission");
            field.setAccessible(true);
            return (Boolean)field.get(this.mCamera);
        }
        catch (Exception exception) {
            return true;
        }
    }

    private void startPreview0() {
        if (this.mPreviewRunning) {
            return;
        }
        this.mCamera = Camera.open((int)this.mParam.getCameraId());
        Camera.Parameters parameters = null;
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (Exception exception) {
            this.mCamera.release();
            this.mCamera = null;
            throw new Exception("permission not allowed");
        }
        if (!sSupportedResolutionMap.containsKey(this.mParam.getCameraId())) {
            sSupportedResolutionMap.put(this.mParam.getCameraId(), parameters.getSupportedPreviewSizes());
        }
        if (sSupportedFormat.size() <= 0) {
            sSupportedFormat = parameters.getSupportedPictureFormats();
        }
        if (!this.isHasPermission()) {
            this.mCamera.release();
            this.mCamera = null;
            throw new Exception("permission not allowed");
        }
        if (!this.mSurfaceCbMode) {
            parameters.setPreviewFormat(17);
        } else {
            parameters.setRecordingHint(true);
        }
        if (parameters.isZoomSupported()) {
            if (this.mParam.getCurrentZoom() >= parameters.getMaxZoom()) {
                this.mParam.setCurrentZoom(parameters.getMaxZoom());
            }
            parameters.setZoom(this.mParam.getCurrentZoom());
            this.mParam.setMaxZoom(parameters.getMaxZoom());
        }
        this.setPreviewSize(parameters);
        this.setPreviewFpsRange(parameters);
        this.setPreviewOrientation(parameters, this.mParam.getRotation());
        try {
            this.mCamera.setParameters(parameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogUtil.d(TAG, "start camera, parameters " + parameters.getPreviewSize().width + ", " + parameters.getPreviewSize().height);
        if (buffer == null) {
            buffer = new byte[this.mParam.getWidth() * this.mParam.getHeight() * 3 / 2];
        }
        if (buffer1 == null) {
            buffer1 = new byte[this.mParam.getWidth() * this.mParam.getHeight() * 3 / 2];
        }
        if (buffer2 == null) {
            buffer2 = new byte[this.mParam.getWidth() * this.mParam.getHeight() * 3 / 2];
        }
        if (this.mSurfaceCbMode && this.mSurfaceTextureId >= 0) {
            this.mSurfaceTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
        } else {
            this.mCamera.setPreviewCallbackWithBuffer(null);
            this.mCamera.addCallbackBuffer(buffer);
            this.mCamera.addCallbackBuffer(buffer1);
            this.mCamera.addCallbackBuffer(buffer2);
            this.mCamera.setPreviewCallbackWithBuffer(this.mPreviewCallback);
        }
        this.mCamera.setPreviewTexture(this.mSurfaceTexture);
        this.mCamera.startPreview();
        this.mPreviewRunning = true;
        LogUtil.d(TAG, "start preivew over.");
    }

    public void pause(boolean bl) {
        LogUtil.d(TAG, "pause preview.");
        this.mPause = true;
    }

    public void resume() {
        LogUtil.d(TAG, "resume preview.");
        if (!this.mPause) {
            return;
        }
        this.stopInner();
        try {
            this.startInner();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.mPause = false;
    }

    private void setPreviewSize(Camera.Parameters parameters) {
        Integer n22;
        List list = parameters.getSupportedPreviewFormats();
        for (Integer n22 : list) {
            System.out.println("\u652f\u6301:" + n22);
        }
        List list2 = parameters.getSupportedPreviewSizes();
        n22 = null;
        Integer n3 = null;
        int n4 = 0;
        Integer n5 = null;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Camera.Size size = (Camera.Size)iterator.next();
            LogUtil.d(TAG, "\u652f\u6301 " + size.width + "x" + size.height);
            if (size.width == this.mParam.getWidth() && size.height == this.mParam.getHeight() || size.width == this.mParam.getHeight() && size.height == this.mParam.getWidth()) {
                n5 = size;
            }
            if (size.width == 720 && size.height == 1280 || size.width == 1280 && size.height == 720) {
                n3 = size;
            }
            if (size.width >= this.mParam.getWidth() && size.height >= this.mParam.getHeight() || size.width >= this.mParam.getHeight() && size.height >= this.mParam.getWidth()) {
                if (n4 == 0) {
                    n4 = size.width * size.height;
                    n22 = size;
                } else if (size.width * size.height < n4) {
                    n4 = size.width * size.height;
                    n22 = size;
                } else if (size.width * size.height == n4 && (size.width < size.height && this.mParam.getWidth() < this.mParam.getHeight() || size.width > size.height && this.mParam.getWidth() > this.mParam.getHeight())) {
                    n22 = size;
                }
            }
            supportMaxWH = size.width * size.height > supportMaxWH ? size.width * size.height : supportMaxWH;
        }
        if (n5 == null && n3 != null) {
            n5 = n3;
        }
        if (n5 == null && n22 != null) {
            n5 = n22;
        }
        if (n5 == null) {
            n5 = (Camera.Size)list2.get(0);
        }
        if (buffer == null && supportMaxWH > 0) {
            buffer = new byte[supportMaxWH * 3 / 2];
        }
        if (buffer1 == null && supportMaxWH > 0) {
            buffer1 = new byte[supportMaxWH * 3 / 2];
        }
        if (buffer2 == null && supportMaxWH > 0) {
            buffer2 = new byte[supportMaxWH * 3 / 2];
        }
        this.mParam.setWidth(((Camera.Size)n5).width);
        this.mParam.setHeight(((Camera.Size)n5).height);
        try {
            parameters.setPreviewSize(this.mParam.getWidth(), this.mParam.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogUtil.d(TAG, "\u9884\u89c8\u5206\u8fa8\u7387 width:" + this.mParam.getWidth() + " height:" + this.mParam.getHeight());
    }

    private void setPreviewFpsRange(Camera.Parameters parameters) {
        int n2 = this.mParam.getFps() * 1000;
        int n3 = 0;
        List list = parameters.getSupportedPreviewFpsRange();
        int[] nArray = new int[2];
        if (list.size() > 0) {
            int[] nArray2 = (int[])list.get(0);
            n3 = Math.abs(nArray2[0] - n2) + Math.abs(nArray2[1] - n2);
            nArray[0] = nArray2[0];
            nArray[1] = nArray2[1];
        }
        for (int i2 = 1; i2 < list.size(); ++i2) {
            int[] nArray3 = (int[])list.get(i2);
            int n4 = Math.abs(nArray3[0] - n2) + Math.abs(nArray3[1] - n2);
            if (n4 >= n3) continue;
            nArray[0] = nArray3[0];
            nArray[1] = nArray3[1];
            n3 = n4;
        }
        try {
            parameters.setPreviewFpsRange(nArray[0], nArray[1]);
            parameters.setPreviewFrameRate(this.mParam.getFps());
        }
        catch (Exception exception) {
            // empty catch block
        }
        LogUtil.d(TAG, "\u9884\u89c8\u5e27\u7387 fps:" + nArray[0] + " - " + nArray[1]);
        nArray = null;
    }

    private void preparePublisher(int n2, int n3) {
        LogUtil.d(TAG, "prepare publisher. " + this.mOrientation + " " + this.mParam.getCameraId());
        if (!this.mSwitchCamera && !this.mPause) {
            LogUtil.d(TAG, "prepare publisher over.");
        } else {
            this.mSwitchCamera = false;
        }
    }

    private void setPreviewOrientation(Camera.Parameters parameters, int n2) {
        int n3;
        LogUtil.d(TAG, "SetRotation : " + n2);
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)this.mParam.getCameraId(), (Camera.CameraInfo)cameraInfo);
        this.mScreen = 0;
        switch (n2) {
            case 0: {
                if (cameraInfo.facing == 1) {
                    this.mDataOrientation = (cameraInfo.orientation + this.mOrientation) % 360;
                    this.mDataOrientation = (360 - this.mDataOrientation + 180) % 360;
                    break;
                }
                this.mDataOrientation = (cameraInfo.orientation - this.mOrientation + 360) % 360;
                break;
            }
            case 90: {
                if (cameraInfo.facing == 1) {
                    this.mDataOrientation = (cameraInfo.orientation + this.mOrientation) % 360;
                    this.mDataOrientation = (360 - this.mDataOrientation + 270) % 360;
                    break;
                }
                this.mDataOrientation = (cameraInfo.orientation - this.mOrientation + 360 + 270) % 360;
                break;
            }
            case 270: {
                if (cameraInfo.facing == 1) {
                    this.mDataOrientation = (cameraInfo.orientation + this.mOrientation) % 360;
                    this.mDataOrientation = (360 - this.mDataOrientation + 90) % 360;
                    break;
                }
                this.mDataOrientation = (cameraInfo.orientation - this.mOrientation + 360 + 90) % 360;
                break;
            }
        }
        if (cameraInfo.facing == 1) {
            n3 = (cameraInfo.orientation + n2) % 360;
            n3 = (360 - n3) % 360;
        } else {
            n3 = (cameraInfo.orientation - n2 + 360) % 360;
        }
        this.mCamera.setDisplayOrientation(n3);
        cameraInfo = null;
    }

    public void setFlashOn(boolean bl) {
        if (this.mCamera != null) {
            if (bl && this.mParam.getCameraId() == 0) {
                VideoPusher.turnLightOn(this.mCamera);
            } else {
                VideoPusher.turnLightOff(this.mCamera);
            }
        }
        this.mFlashOn = bl;
    }

    public void setAutoFocus(boolean bl) {
        if (this.mCamera != null && this.mParam.getCameraId() == 0) {
            this.mCamera.cancelAutoFocus();
            Camera.Parameters parameters = this.mCamera.getParameters();
            if (bl) {
                if (this.mSensorFocus) {
                    parameters.setFocusMode("auto");
                    this.mCamera.autoFocus(null);
                } else {
                    parameters.setFocusMode("continuous-video");
                }
            } else {
                parameters.setFocusMode("auto");
            }
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.mAutoFocus = bl;
    }

    public boolean isSupportAutoFocus() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()).getSupportedFocusModes() != null && parameters.getSupportedFocusModes().size() > 0) {
            return parameters.getSupportedFocusModes().contains("continuous-video");
        }
        return false;
    }

    public boolean isSupportFlash() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()).getSupportedFlashModes() != null && parameters.getSupportedFlashModes().size() > 0) {
            return parameters.getSupportedFlashModes().contains("torch");
        }
        return false;
    }

    public void setExposure(int n2) {
        Camera.Parameters parameters;
        if (this.mCamera != null && n2 >= (parameters = this.mCamera.getParameters()).getMinExposureCompensation() && n2 <= parameters.getMaxExposureCompensation()) {
            parameters.setExposureCompensation(this.mParam.getCurrentZoom());
        }
    }

    public int getCurrentExposure() {
        if (this.mCamera != null) {
            Camera.Parameters parameters = this.mCamera.getParameters();
            return parameters.getExposureCompensation();
        }
        return 0;
    }

    public void setZoom(int n2) {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()).isZoomSupported() && n2 >= 0 && n2 <= parameters.getMaxZoom()) {
            this.mParam.setCurrentZoom(n2);
            parameters.setZoom(this.mParam.getCurrentZoom());
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public int getCurrentZoom() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()).isZoomSupported()) {
            return parameters.getZoom();
        }
        return 1;
    }

    public int getMaxZoom() {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()).isZoomSupported()) {
            return parameters.getMaxZoom();
        }
        return 0;
    }

    public void setZoom(float f2) {
        Camera.Parameters parameters;
        if (this.mCamera != null && (parameters = this.mCamera.getParameters()).isZoomSupported()) {
            int n2 = (int)(f2 * (float)this.mParam.getCurrentZoom());
            if (n2 <= 1) {
                this.mParam.setCurrentZoom(1);
            } else if (n2 >= parameters.getMaxZoom()) {
                this.mParam.setCurrentZoom(parameters.getMaxZoom());
            } else {
                this.mParam.setCurrentZoom(n2);
            }
            parameters.setZoom(this.mParam.getCurrentZoom());
            try {
                this.mCamera.setParameters(parameters);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void setFocus(float f2, float f3) {
        if (this.mCamera == null) {
            return;
        }
        if (this.mParam.getCameraId() == 1) {
            return;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        LogUtil.d(TAG, "focusAreas is " + parameters.getMaxNumFocusAreas());
        if (parameters != null && parameters.getMaxNumFocusAreas() == 0) {
            return;
        }
        if (this.mCamera != null) {
            this.mCamera.cancelAutoFocus();
        }
        int n2 = (int)(f2 * 2000.0f - 1000.0f);
        int n3 = (int)(f3 * 2000.0f - 1000.0f);
        Camera.Area area = new Camera.Area(new Rect(n2 - 50, n3 - 50, n2 + 50, n3 + 50), 1);
        ArrayList<Camera.Area> arrayList = new ArrayList<Camera.Area>();
        arrayList.add(area);
        parameters.setFocusAreas(arrayList);
        try {
            this.mCamera.setParameters(parameters);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

            public void onAutoFocus(boolean bl, Camera camera) {
                camera.cancelAutoFocus();
            }
        });
    }

    public void setVideoSourceListener(VideoSourceListener videoSourceListener) {
        this.mVideoSourceListener = videoSourceListener;
    }

    public void setVideoSourceTextureListener(VideoSourceTextureListener videoSourceTextureListener) {
        this.mVideoSourceTextureListener = videoSourceTextureListener;
    }

    public long getLastCaptureTime() {
        return this.mLastCaptureTime;
    }

    public void setLastCaptureTime(long l2) {
        this.mLastCaptureTime = l2;
    }

    public int getCurrentFps() {
        return this.mCurrentFps;
    }

    public int updateTexImage() {
        if (this.mSurfaceTexture == null) {
            return -1;
        }
        this.mSurfaceTexture.updateTexImage();
        return 0;
    }

    public void getTransformMatrix(float[] fArray) {
        if (this.mSurfaceTexture == null) {
            LogUtil.d("VideoPusherRotation", "getTransformMatrix return null !");
            return;
        }
        this.mSurfaceTexture.getTransformMatrix(fArray);
    }

    public static List<Camera.Size> getSupportedResolutions(int n2) {
        if (!sSupportedResolutionMap.containsKey(n2)) {
            Camera camera = Camera.open((int)n2);
            Camera.Parameters parameters = null;
            try {
                parameters = camera.getParameters();
            }
            catch (Exception exception) {
                return null;
            }
            camera.release();
            sSupportedResolutionMap.put(n2, parameters.getSupportedPreviewSizes());
        }
        return sSupportedResolutionMap.get(n2);
    }

    public static List<Integer> getSupportedFormats() {
        if (sSupportedFormat.size() <= 0) {
            Camera camera = Camera.open((int)0);
            Camera.Parameters parameters = null;
            try {
                parameters = camera.getParameters();
            }
            catch (Exception exception) {
                return null;
            }
            camera.release();
            sSupportedFormat = parameters.getSupportedPreviewFormats();
        }
        return sSupportedFormat;
    }

    public boolean isPreviewRunning() {
        return this.mPreviewRunning;
    }

    private void cameraAutoFocus() {
        this.mAutoFocusing = true;
        if (!this.mCamera.getParameters().getFocusMode().equals("continuous-video")) {
            if (!this.mCamera.getParameters().getFocusMode().equals("auto")) {
                try {
                    Camera.Parameters parameters = this.mCamera.getParameters();
                    parameters.setFocusMode("auto");
                    this.mCamera.setParameters(parameters);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean bl, Camera camera) {
                    VideoPusher.this.mAutoFocusing = false;
                }
            });
        }
    }

    public static interface VideoSourceTextureListener {
        public void onVideoFrame(long var1, int var3, int var4, int var5, int var6, int var7);
    }

    public static interface VideoSourceListener {
        public void onVideoFrame(byte[] var1, long var2, int var4, int var5, int var6, int var7, int var8);
    }
}

