/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.capture;

import android.content.Context;
import android.hardware.Camera;
import com.alivc.component.capture.VideoPusher;
import com.alivc.live.pusher.LogUtil;
import com.alivc.live.pusher.b;
import java.util.List;

public class VideoPusherJNI {
    private long mNativeHandler = 0L;
    private VideoPusher mVideoPusher = null;
    private VideoPusher.VideoSourceListener mVideoPusherDataListener = new VideoPusher.VideoSourceListener(){

        @Override
        public void onVideoFrame(byte[] byArray, long l2, int n2, int n3, int n4, int n5, int n6) {
            VideoPusherJNI.this.onData(byArray, l2, n2, n3, n4, n5, n6);
        }
    };
    private VideoPusher.VideoSourceTextureListener mVideoPusherTextureListener = new VideoPusher.VideoSourceTextureListener(){

        @Override
        public void onVideoFrame(long l2, int n2, int n3, int n4, int n5, int n6) {
            VideoPusherJNI.this.onTexture(l2, n2, n3, n4, n5, n6);
        }
    };

    public long getVideoHandler() {
        return this.mNativeHandler;
    }

    public VideoPusherJNI(long l2) {
        LogUtil.d("VideoPusherJNI", "ME ME ME, VideoPusherJNI construct");
        if (this.mVideoPusher == null) {
            this.mVideoPusher = new VideoPusher();
            this.mVideoPusher.setVideoSourceListener(this.mVideoPusherDataListener);
            this.mVideoPusher.setVideoSourceTextureListener(this.mVideoPusherTextureListener);
        }
        this.mNativeHandler = l2;
    }

    public void init(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, Context context) {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI init source " + n2 + ", widht " + n3 + ",height " + n4 + ", fps " + n5 + ", rotation " + n6);
        if (this.mVideoPusher != null) {
            this.mVideoPusher.init(n2, n3, n4, n5, n6, n7, bl, bl2, context);
        }
    }

    public int start(int n2) {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI start");
        if (this.mVideoPusher != null) {
            try {
                this.mVideoPusher.start(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public void pause(boolean bl) {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI pause " + bl);
        if (this.mVideoPusher != null) {
            this.mVideoPusher.pause(bl);
        }
    }

    public int resume() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI resume");
        if (this.mVideoPusher != null) {
            try {
                this.mVideoPusher.resume();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public void stop() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI stop");
        if (this.mVideoPusher != null) {
            this.mVideoPusher.stop();
        }
    }

    public void destroy() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI destroy");
        if (this.mVideoPusher != null) {
            this.mVideoPusher.destroy();
            this.mVideoPusher = null;
        }
        this.mNativeHandler = 0L;
    }

    public void switchCamera() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI switchCamera");
        if (this.mVideoPusher != null) {
            try {
                this.mVideoPusher.switchCamera();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setOrientation(int n2) {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI setOrientation");
        if (this.mVideoPusher != null) {
            try {
                this.mVideoPusher.setOrientation(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setAutoFocus(boolean bl, float f2, float f3) {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI setAutoFocus " + bl + ", x" + f2 + ", y" + f3);
        if (this.mVideoPusher != null) {
            this.mVideoPusher.setAutoFocus(bl);
            if (f2 > 0.0f || f3 > 0.0f) {
                this.mVideoPusher.setFocus(f2, f3);
            }
        }
    }

    public void setZoom(int n2) {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI setzoom " + n2);
        if (this.mVideoPusher != null) {
            this.mVideoPusher.setZoom(n2);
        }
    }

    public int getMaxZoom() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI getMaxZoom ");
        if (this.mVideoPusher != null) {
            LogUtil.d("VideoPusherJNI", "VideoPusherJNI getMaxZoom " + this.mVideoPusher.getMaxZoom());
            return this.mVideoPusher.getMaxZoom();
        }
        return 0;
    }

    public int getCurrentZoom() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI getCurrentZoom ");
        if (this.mVideoPusher != null) {
            return this.mVideoPusher.getCurrentZoom();
        }
        return 0;
    }

    public void setExposureCompensation(int n2) {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI setExposureCompensation " + n2);
        if (this.mVideoPusher != null) {
            this.mVideoPusher.setExposure(n2);
        }
    }

    public int getCurrentExposureCompensation() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI getCurrentExposureCompensation ");
        if (this.mVideoPusher != null) {
            return this.mVideoPusher.getCurrentExposure();
        }
        return 0;
    }

    public void setTorch(boolean bl) {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI setTorch " + bl);
        if (this.mVideoPusher != null) {
            this.mVideoPusher.setFlashOn(bl);
        }
    }

    public boolean isSupportAutoFocus() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI isSupportAutoFocus ");
        if (this.mVideoPusher != null) {
            return this.mVideoPusher.isSupportAutoFocus();
        }
        return false;
    }

    public boolean isSupportFlash() {
        LogUtil.d("VideoPusherJNI", "VideoPusherJNI isSupportFlash ");
        if (this.mVideoPusher != null) {
            return this.mVideoPusher.isSupportFlash();
        }
        return false;
    }

    public int updateTexImage() {
        if (this.mVideoPusher != null) {
            return this.mVideoPusher.updateTexImage();
        }
        return -1;
    }

    public void getTransformMatrix(float[] fArray) {
        if (this.mVideoPusher != null) {
            this.mVideoPusher.getTransformMatrix(fArray);
        }
    }

    public static String getSupportedResolutions(int n2) {
        List<Camera.Size> list = VideoPusher.getSupportedResolutions(n2);
        String string = null;
        for (Camera.Size size : list) {
            if (string == null) {
                string = size.width + "," + size.height;
                continue;
            }
            string = string + "," + size.width + "," + size.height;
        }
        return string;
    }

    public static String getSupportedFormats() {
        List<Integer> list = VideoPusher.getSupportedFormats();
        String string = null;
        for (Integer n2 : list) {
            Integer n3 = b.e(n2);
            if (string == null) {
                string = n3.toString();
                continue;
            }
            string = string + "," + n3.toString();
        }
        return string;
    }

    public boolean isCapturing() {
        if (this.mVideoPusher != null) {
            return this.mVideoPusher.isPreviewRunning();
        }
        return false;
    }

    private native int onStarted();

    private native int onStopped();

    private native int onData(byte[] var1, long var2, int var4, int var5, int var6, int var7, int var8);

    private native int onTexture(long var1, int var3, int var4, int var5, int var6, int var7);
}

