/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.encoder;

import android.media.MediaCodec;
import android.os.Build;
import android.util.Log;
import com.alivc.component.encoder.LiveNativeUsed;
import java.nio.ByteBuffer;

@LiveNativeUsed
public class AudioCodecData {
    public static final int DATA_TYPE_SPECIFIC = 1;
    public static final int DATA_NORMAL_FRAME = 2;
    public static final int ERROR_CODE_OK = 0;
    public static final int ERROR_CODE_TRY_AGAIN = 1;
    public static final int ERROR_UNKNOWN = -88;
    private int mDataType;
    private int mCode = 0;
    private long mPts;
    private ByteBuffer mCodecData;
    private MediaCodec mMediaCodec;
    private int mOutputBufferId;
    private boolean mEos = false;

    @LiveNativeUsed
    public int getDataType() {
        return this.mDataType;
    }

    public void setDataType(int n2) {
        this.mDataType = n2;
    }

    @LiveNativeUsed
    public int getCode() {
        return this.mCode;
    }

    public void setCode(int n2) {
        this.mCode = n2;
    }

    @LiveNativeUsed
    public long getPts() {
        return this.mPts;
    }

    public void setPts(long l2) {
        this.mPts = l2;
    }

    @LiveNativeUsed
    public boolean getEos() {
        return this.mEos;
    }

    public void setEos(boolean bl) {
        this.mEos = bl;
    }

    @LiveNativeUsed
    public ByteBuffer getCodecData() {
        return this.mCodecData;
    }

    public void setCodecData(ByteBuffer byteBuffer, MediaCodec mediaCodec, int n2) {
        this.mCodecData = byteBuffer;
        this.mMediaCodec = mediaCodec;
        this.mOutputBufferId = n2;
    }

    public int getPosition() {
        Log.d((String)"AndroidAudio", (String)("dequeueOutputBuffer get position " + this.mCodecData.limit()));
        return this.mCodecData == null ? 0 : this.mCodecData.limit();
    }

    @LiveNativeUsed
    public void release() {
        if (Build.VERSION.SDK_INT >= 16 && this.mMediaCodec != null && this.mOutputBufferId >= 0) {
            this.mMediaCodec.releaseOutputBuffer(this.mOutputBufferId, false);
            this.mMediaCodec = null;
            this.mOutputBufferId = 0;
        }
        this.mCodecData = null;
    }

    public String toString() {
        return "MediaCodecData{mDataType=" + this.mDataType + ", mCode=" + this.mCode + ", mPts=" + this.mPts + '}';
    }
}

