/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.component.encoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.os.Build;
import android.util.Log;
import com.alivc.component.encoder.AudioCodecData;
import com.alivc.component.encoder.LiveNativeUsed;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

@LiveNativeUsed
public class AudioCodecEncoder {
    int mAudioBytes = 0;
    long mAudioTime = 0L;
    long mFirstPts = 0L;
    final int[] kSampleRates = new int[]{8000, 11025, 22050, 44100, 48000};
    final int[] kBitRates = new int[]{64000, 128000};
    public static final int OK = 0;
    public static final int ERROR_API_LEVEL = 0x10003100;
    public static final int ERROR_STATE = 0x10003101;
    public static final int ERROR_INPUT_BUFFER_ERROR = 268448002;
    public static final int ERROR_NO_BUFFER_AVAILABLE = 0x10003103;
    private static final String TAG = AudioCodecEncoder.class.getName();
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_INITIALIZED = 1;
    private static final int STATE_ENCODING = 2;
    private MediaCodec mMediaCodec;
    private int mState = 0;
    private ByteBuffer[] mOutputBuffers;
    private ByteBuffer[] mInputBuffers;
    private int mSampleRateInHz = 0;
    private int mChannels = 2;
    private int mBitrate = 0;
    private long mBytesPerSecond = 0L;
    private int mCurInputBufferIndex = -1;
    private BufferedOutputStream mSaveAAC = null;
    MediaCodecInfo.CodecCapabilities mCodecCaps = null;
    MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();

    private boolean isSupportFormat(int n2) {
        if (this.mCodecCaps != null && Build.VERSION.SDK_INT >= 21) {
            MediaFormat mediaFormat = new MediaFormat();
            mediaFormat.setInteger("aac-profile", n2);
            return this.mCodecCaps.isFormatSupported(mediaFormat);
        }
        return false;
    }

    @LiveNativeUsed
    public boolean init(String string, int n2, int n3, int n4, int n5) {
        this.mSampleRateInHz = n3;
        this.mChannels = n2;
        this.mBitrate = n4;
        if (this.mState == 0) {
            try {
                boolean bl;
                MediaCodecInfo mediaCodecInfo = this.selectCodecInfo(string);
                if (mediaCodecInfo == null) {
                    Log.d((String)TAG, (String)("not supported mime type (" + string + ")"));
                    return false;
                }
                Log.e((String)TAG, (String)("Create MediaCodec " + mediaCodecInfo.getName()));
                this.mMediaCodec = MediaCodec.createByCodecName((String)mediaCodecInfo.getName());
                this.mCodecCaps = mediaCodecInfo.getCapabilitiesForType(string);
                if (n5 == 23) {
                    n5 = 2;
                }
                if (Build.VERSION.SDK_INT >= 21 && !(bl = this.isSupportFormat(n5))) {
                    n5 = 2;
                }
                MediaFormat mediaFormat = new MediaFormat();
                mediaFormat.setString("mime", string);
                mediaFormat.setInteger("channel-count", n2);
                mediaFormat.setInteger("sample-rate", n3);
                mediaFormat.setInteger("bitrate", n4);
                mediaFormat.setInteger("aac-profile", n5);
                mediaFormat.setInteger("max-input-size", 8000);
                try {
                    this.mMediaCodec.configure(mediaFormat, null, null, 1);
                }
                catch (IllegalStateException illegalStateException) {
                    Log.e((String)TAG, (String)("codec '" + string + "' failed configuration."));
                }
                this.mBytesPerSecond = this.mSampleRateInHz * this.mChannels * 2;
                this.mState = 1;
                Log.d((String)TAG, (String)("Phone Model: " + Build.MODEL));
                return true;
            }
            catch (IOException iOException) {
                Log.e((String)TAG, (String)"Create MediaCodec Failed");
                iOException.printStackTrace();
                return false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
        return true;
    }

    @LiveNativeUsed
    public int start() {
        if (this.mMediaCodec != null && this.mState == 1) {
            try {
                this.mMediaCodec.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0x10003101;
            }
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            this.mInputBuffers = this.mMediaCodec.getInputBuffers();
            this.mState = 2;
            return 0;
        }
        return 0x10003101;
    }

    public static void clone(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        byteBuffer.rewind();
        byteBuffer2.put(byteBuffer);
        byteBuffer.rewind();
        byteBuffer2.flip();
    }

    @LiveNativeUsed
    public ByteBuffer getBuffer(long l2) {
        this.mCurInputBufferIndex = this.mMediaCodec.dequeueInputBuffer(l2);
        if (this.mCurInputBufferIndex >= 0) {
            ByteBuffer byteBuffer = null;
            byteBuffer = Build.VERSION.SDK_INT >= 21 ? this.mMediaCodec.getInputBuffer(this.mCurInputBufferIndex) : this.mInputBuffers[this.mCurInputBufferIndex];
            return byteBuffer;
        }
        Log.d((String)"AndroidAudio", (String)("dequeueInputBuffer failed " + this.mCurInputBufferIndex));
        return null;
    }

    @LiveNativeUsed
    public int inputFrame(int n2, long l2) {
        if (n2 <= 0 || l2 < 0L) {
            if (this.mCurInputBufferIndex < 0) {
                this.mCurInputBufferIndex = this.mMediaCodec.dequeueInputBuffer(-1L);
            }
            this.mMediaCodec.queueInputBuffer(this.mCurInputBufferIndex, 0, 0, 0L, 4);
        } else if (this.mCurInputBufferIndex >= 0) {
            this.mMediaCodec.queueInputBuffer(this.mCurInputBufferIndex, 0, n2, l2, 0);
        }
        return 0;
    }

    @LiveNativeUsed
    public AudioCodecData tryRead(long l2) {
        AudioCodecData audioCodecData = new AudioCodecData();
        this.mBufferInfo.size = 0;
        int n2 = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, l2);
        if (n2 >= 0) {
            Log.d((String)"AndroidAudio", (String)("dequeueOutputBuffer suc " + this.mBufferInfo.size + ", outindex " + n2 + ", dts " + this.mBufferInfo.presentationTimeUs + ", cur " + System.currentTimeMillis()));
            if (this.mOutputBuffers != null) {
                this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            }
            ByteBuffer byteBuffer = null;
            byteBuffer = Build.VERSION.SDK_INT >= 21 ? this.mMediaCodec.getOutputBuffer(n2) : this.mOutputBuffers[n2];
            if (this.mBufferInfo.size != 0) {
                byteBuffer.position(this.mBufferInfo.offset);
                byteBuffer.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
            }
            if (this.mSaveAAC != null) {
                int n3 = this.mBufferInfo.size;
                int n4 = n3 + 7;
                byte[] byArray = new byte[n4];
                this.addADTStoPacket(byArray, n4);
                byteBuffer.get(byArray, 7, n3);
                try {
                    this.mSaveAAC.write(byArray, 0, byArray.length);
                    this.mSaveAAC.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            audioCodecData.setCodecData(byteBuffer, this.mMediaCodec, n2);
            audioCodecData.setPts(System.currentTimeMillis() * 1000L);
            if ((this.mBufferInfo.flags & 2) > 0) {
                audioCodecData.setDataType(1);
            } else if ((this.mBufferInfo.flags & 4) > 0) {
                audioCodecData.setEos(true);
            } else {
                audioCodecData.setDataType(2);
            }
        } else if (n2 == -2) {
            Log.d((String)"AndroidAudio", (String)"dequeueOutputBuffer INFO_OUTPUT_FORMAT_CHANGED");
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            audioCodecData.setCode(1);
        } else if (n2 == -1) {
            Log.d((String)"AndroidAudio", (String)"dequeueOutputBuffer INFO_TRY_AGAIN_LATER");
            audioCodecData.setCode(1);
        } else if (n2 == -3) {
            Log.d((String)"AndroidAudio", (String)"dequeueOutputBuffer INFO_OUTPUT_BUFFERS_CHANGED");
            this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
            audioCodecData.setCode(1);
        } else {
            Log.d((String)"AndroidAudio", (String)"dequeueOutputBuffer ERROR");
            audioCodecData.setCode(-88);
        }
        return audioCodecData;
    }

    @LiveNativeUsed
    public int stop() {
        if (this.mState == 2 && this.mMediaCodec != null) {
            this.mMediaCodec.stop();
            this.mState = 1;
            return 0;
        }
        return 0x10003101;
    }

    @LiveNativeUsed
    public int release() {
        if (this.mState == 1) {
            this.mMediaCodec.release();
            this.mMediaCodec = null;
            this.mState = 0;
            return 0;
        }
        return 0x10003101;
    }

    private MediaCodecInfo selectCodecInfo(String string) {
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(string)) continue;
                return mediaCodecInfo;
            }
        }
        return null;
    }

    private void addADTStoPacket(byte[] byArray, int n2) {
        int n3 = 2;
        int n4 = 5;
        int n5 = 2;
        byArray[0] = -1;
        byArray[1] = -7;
        byArray[2] = (byte)((n3 - 1 << 6) + (n4 << 2) + (n5 >> 2));
        byArray[3] = (byte)(((n5 & 3) << 6) + (n2 >> 11));
        byArray[4] = (byte)((n2 & 0x7FF) >> 3);
        byArray[5] = (byte)(((n2 & 7) << 5) + 31);
        byArray[6] = -4;
    }
}

