/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.debug;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.alivc.debug.DebugViewManager;
import com.alivc.videochat.R;

public class DebugBigView
extends LinearLayout
implements View.OnClickListener {
    public static int viewWidth;
    public static int viewHeight;
    private WindowManager windowManager;
    private WindowManager.LayoutParams mParams;
    private float xInScreen;
    private float yInScreen;
    private float xDownInScreen;
    private float yDownInScreen;
    private float xInView;
    private float yInView;
    private TextView mLogCheck;
    private TextView mDataList;
    private TextView mDiagramList;
    private TextView mCurrentCpu;
    private TextView mCpuChange;
    private TextView mCurrentMem;
    private TextView mMemChange;
    private float cpuValue = 0.0f;
    private float memValue = 0.0f;

    public DebugBigView(final Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.debug_view_big, (ViewGroup)this);
        View view = this.findViewById(R.id.big_window_layout);
        this.windowManager = (WindowManager)context.getApplicationContext().getSystemService("window");
        viewWidth = view.getLayoutParams().width;
        viewHeight = view.getLayoutParams().height;
        this.mLogCheck = (TextView)this.findViewById(R.id.log_check);
        this.mDataList = (TextView)this.findViewById(R.id.data_list);
        this.mDiagramList = (TextView)this.findViewById(R.id.diagram_list);
        this.mCurrentCpu = (TextView)this.findViewById(R.id.current_cpu);
        this.mCpuChange = (TextView)this.findViewById(R.id.cpu_change);
        this.mCurrentMem = (TextView)this.findViewById(R.id.current_mem);
        this.mMemChange = (TextView)this.findViewById(R.id.mem_change);
        this.mLogCheck.setOnClickListener((View.OnClickListener)this);
        this.mDataList.setOnClickListener((View.OnClickListener)this);
        this.mDiagramList.setOnClickListener((View.OnClickListener)this);
        Button button = (Button)this.findViewById(R.id.close);
        TextView textView = (TextView)this.findViewById(R.id.back);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DebugViewManager.removeBigWindow(context);
                DebugViewManager.removeSmallWindow(context);
            }
        });
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DebugViewManager.removeBigWindow(context);
                DebugViewManager.createSmallWindow(context);
            }
        });
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.xInView = motionEvent.getX();
                this.yInView = motionEvent.getY();
                this.xDownInScreen = motionEvent.getRawX();
                this.yDownInScreen = motionEvent.getRawY();
                this.xInScreen = motionEvent.getRawX();
                this.yInScreen = motionEvent.getRawY();
                break;
            }
            case 2: {
                this.xInScreen = motionEvent.getRawX();
                this.yInScreen = motionEvent.getRawY();
                this.updateViewPosition();
                break;
            }
        }
        return true;
    }

    private void updateViewPosition() {
        this.mParams.x = (int)(this.xInScreen - this.xInView);
        this.mParams.y = (int)(this.yInScreen - this.yInView);
        this.windowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
    }

    public void setParams(WindowManager.LayoutParams layoutParams) {
        this.mParams = layoutParams;
    }

    public void updateInfo(float f2, float f3) {
        this.mCurrentMem.setText((CharSequence)String.format("%.2f", Float.valueOf(f3)));
        if (f3 - this.memValue >= 0.0f) {
            this.mMemChange.setText((CharSequence)("+" + String.format("%.2f", Float.valueOf(f3 - this.memValue))));
            this.mMemChange.setTextColor(this.getResources().getColor(R.color.light_red));
        } else {
            this.mMemChange.setText((CharSequence)String.format("%.2f", Float.valueOf(f3 - this.memValue)));
            this.mMemChange.setTextColor(this.getResources().getColor(R.color.light_green));
        }
        this.mCurrentCpu.setText((CharSequence)String.format("%.2f", Float.valueOf(f2)));
        if (f2 - this.cpuValue >= 0.0f) {
            this.mCpuChange.setText((CharSequence)("+" + String.format("%.2f", Float.valueOf(f2 - this.cpuValue))));
            this.mCpuChange.setTextColor(this.getResources().getColor(R.color.light_red));
        } else {
            this.mCpuChange.setText((CharSequence)String.format("%.2f", Float.valueOf(f2 - this.cpuValue)));
            this.mCpuChange.setTextColor(this.getResources().getColor(R.color.light_green));
        }
        this.memValue = f3;
        this.cpuValue = f2;
    }

    public void onClick(View view) {
        int n2 = view.getId();
        if (n2 == R.id.log_check) {
            DebugViewManager.removeBigWindow(this.getContext().getApplicationContext());
            DebugViewManager.createPushLogWindow(this.getContext().getApplicationContext());
        } else if (n2 == R.id.data_list) {
            DebugViewManager.removeBigWindow(this.getContext().getApplicationContext());
            DebugViewManager.createPushDataWindow(this.getContext().getApplicationContext());
        } else if (n2 == R.id.diagram_list) {
            DebugViewManager.removeBigWindow(this.getContext().getApplicationContext());
            DebugViewManager.createPushDiagramView(this.getContext().getApplicationContext());
        }
    }
}

