/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.debug;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.alivc.debug.DebugViewManager;
import com.alivc.videochat.R;
import java.lang.reflect.Field;

public class DebugSmallView
extends LinearLayout {
    public static int viewWidth;
    public static int viewHeight;
    private static int statusBarHeight;
    private WindowManager windowManager;
    private WindowManager.LayoutParams mParams;
    private float xInScreen;
    private float yInScreen;
    private float xDownInScreen;
    private float yDownInScreen;
    private float xInView;
    private float yInView;

    public DebugSmallView(Context context) {
        super(context);
        this.windowManager = (WindowManager)context.getSystemService("window");
        LayoutInflater.from((Context)context).inflate(R.layout.debug_view_small, (ViewGroup)this);
        View view = this.findViewById(R.id.small_window_layout);
        viewWidth = view.getLayoutParams().width;
        viewHeight = view.getLayoutParams().height;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                this.xInView = motionEvent.getX();
                this.yInView = motionEvent.getY();
                this.xDownInScreen = motionEvent.getRawX();
                this.yDownInScreen = motionEvent.getRawY();
                this.xInScreen = motionEvent.getRawX();
                this.yInScreen = motionEvent.getRawY();
                break;
            }
            case 2: {
                this.xInScreen = motionEvent.getRawX();
                this.yInScreen = motionEvent.getRawY();
                this.updateViewPosition();
                break;
            }
            case 1: {
                if (!(Math.abs(this.xDownInScreen - this.xInScreen) < 5.0f) || !(Math.abs(this.yDownInScreen - this.yInScreen) < 5.0f)) break;
                this.openBigWindow();
                break;
            }
        }
        return true;
    }

    public void setParams(WindowManager.LayoutParams layoutParams) {
        this.mParams = layoutParams;
    }

    private void updateViewPosition() {
        this.mParams.x = (int)(this.xInScreen - this.xInView);
        this.mParams.y = (int)(this.yInScreen - this.yInView);
        this.windowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mParams);
    }

    private void openBigWindow() {
        DebugViewManager.openBigWindow(this.getContext());
        DebugViewManager.removeSmallWindow(this.getContext());
    }

    private int getStatusBarHeight() {
        if (statusBarHeight == 0) {
            try {
                Class<?> clazz = Class.forName("com.android.internal.R$dimen");
                Object obj = clazz.newInstance();
                Field field = clazz.getField("status_bar_height");
                int n2 = (Integer)field.get(obj);
                statusBarHeight = this.getResources().getDimensionPixelSize(n2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return statusBarHeight;
    }
}

