/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.debug;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.alivc.debug.AlivcLivePushDebugInfo;
import com.alivc.debug.DebugBigView;
import com.alivc.debug.DebugSmallView;
import com.alivc.debug.ParameterUtil;
import com.alivc.debug.PushDataView;
import com.alivc.debug.PushDiagramView;
import com.alivc.debug.PushLogView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class DebugViewManager {
    private static DebugSmallView smallWindow;
    private static DebugBigView bigWindow;
    private static PushLogView pushLogWindow;
    private static PushDataView pushDataWindow;
    private static PushDiagramView pushDiagramWindow;
    private static WindowManager.LayoutParams smallWindowParams;
    private static WindowManager.LayoutParams bigWindowParams;
    private static WindowManager.LayoutParams pushLogWindowParams;
    private static WindowManager.LayoutParams pushDataWindowParams;
    private static WindowManager.LayoutParams pushDiagramWindowParams;
    private static String SD_DIR;
    private static WindowManager mWindowManager;
    private static Handler mHandler;
    private static AlivcLivePushDebugInfo mAlivcLivePushDebugInfo;
    private static final long REFRESH_INTERVAL = 2000L;
    private static Context mContext;
    private static Runnable mRunnable;
    private static UpdateDebugInfo mUpdateDebugInfo;

    public static void createSmallWindow(Context context) {
        WindowManager windowManager = DebugViewManager.getWindowManager(context);
        int n2 = windowManager.getDefaultDisplay().getWidth();
        int n3 = windowManager.getDefaultDisplay().getHeight();
        if (smallWindow == null) {
            smallWindow = new DebugSmallView(context);
            if (smallWindowParams == null) {
                smallWindowParams = new WindowManager.LayoutParams();
                DebugViewManager.smallWindowParams.type = 2002;
                DebugViewManager.smallWindowParams.format = 1;
                DebugViewManager.smallWindowParams.flags = 40;
                DebugViewManager.smallWindowParams.gravity = 51;
                DebugViewManager.smallWindowParams.width = DebugSmallView.viewWidth;
                DebugViewManager.smallWindowParams.height = DebugSmallView.viewHeight;
                DebugViewManager.smallWindowParams.x = n2;
                DebugViewManager.smallWindowParams.y = n3 / 2;
            }
            smallWindow.setParams(smallWindowParams);
            windowManager.addView((View)smallWindow, (ViewGroup.LayoutParams)smallWindowParams);
        }
        if (mHandler != null) {
            mHandler.removeCallbacks(mRunnable);
        }
    }

    public static void createBigWindow(Context context) {
        WindowManager windowManager = DebugViewManager.getWindowManager(context);
        int n2 = windowManager.getDefaultDisplay().getWidth();
        int n3 = windowManager.getDefaultDisplay().getHeight();
        if (bigWindow == null) {
            bigWindow = new DebugBigView(context);
            if (bigWindowParams == null) {
                bigWindowParams = new WindowManager.LayoutParams();
                DebugViewManager.bigWindowParams.x = n2 / 2 - DebugBigView.viewWidth / 2;
                DebugViewManager.bigWindowParams.y = n3 / 2 - DebugBigView.viewHeight / 2;
                DebugViewManager.bigWindowParams.type = 2002;
                DebugViewManager.bigWindowParams.format = 1;
                DebugViewManager.bigWindowParams.flags = 40;
                DebugViewManager.bigWindowParams.gravity = 51;
                DebugViewManager.bigWindowParams.width = DebugBigView.viewWidth;
                DebugViewManager.bigWindowParams.height = DebugBigView.viewHeight;
            }
            bigWindow.setParams(bigWindowParams);
            windowManager.addView((View)bigWindow, (ViewGroup.LayoutParams)bigWindowParams);
        }
    }

    public static void createPushLogWindow(Context context) {
        WindowManager windowManager = DebugViewManager.getWindowManager(context);
        if (pushLogWindow == null) {
            pushLogWindow = new PushLogView(context);
            if (pushLogWindowParams == null) {
                pushLogWindowParams = new WindowManager.LayoutParams();
                DebugViewManager.pushLogWindowParams.type = 2002;
                DebugViewManager.pushLogWindowParams.format = 1;
                DebugViewManager.pushLogWindowParams.gravity = 17;
            }
        }
        windowManager.addView((View)pushLogWindow, (ViewGroup.LayoutParams)pushLogWindowParams);
    }

    private static void createPushLogView(Context context) {
        if (pushLogWindow == null) {
            pushLogWindow = new PushLogView(context);
            if (pushLogWindowParams == null) {
                pushLogWindowParams = new WindowManager.LayoutParams();
                DebugViewManager.pushLogWindowParams.type = 2002;
                DebugViewManager.pushLogWindowParams.format = 1;
                DebugViewManager.pushLogWindowParams.gravity = 17;
            }
        }
    }

    public static void createPushDataWindow(Context context) {
        WindowManager windowManager = DebugViewManager.getWindowManager(context);
        if (pushDataWindow == null) {
            pushDataWindow = new PushDataView(context);
            if (pushDataWindowParams == null) {
                pushDataWindowParams = new WindowManager.LayoutParams();
                DebugViewManager.pushDataWindowParams.type = 2002;
                DebugViewManager.pushDataWindowParams.format = 1;
                DebugViewManager.pushDataWindowParams.gravity = 17;
            }
            windowManager.addView((View)pushDataWindow, (ViewGroup.LayoutParams)pushDataWindowParams);
        }
    }

    public static void createPushDiagramView(Context context) {
        WindowManager windowManager = DebugViewManager.getWindowManager(context);
        if (pushDiagramWindow == null) {
            pushDiagramWindow = new PushDiagramView(context);
            if (pushDiagramWindowParams == null) {
                pushDiagramWindowParams = new WindowManager.LayoutParams();
                DebugViewManager.pushDiagramWindowParams.type = 2002;
                DebugViewManager.pushDiagramWindowParams.format = 1;
                DebugViewManager.pushDiagramWindowParams.gravity = 17;
            }
        }
        windowManager.addView((View)pushDiagramWindow, (ViewGroup.LayoutParams)pushDiagramWindowParams);
    }

    public static void removeSmallWindow(Context context) {
        if (smallWindow != null) {
            WindowManager windowManager = DebugViewManager.getWindowManager(context);
            windowManager.removeView((View)smallWindow);
            smallWindow = null;
        }
    }

    public static void removeBigWindow(Context context) {
        if (bigWindow != null) {
            WindowManager windowManager = DebugViewManager.getWindowManager(context);
            windowManager.removeView((View)bigWindow);
            bigWindow = null;
        }
    }

    public static void removePushLogWindow(Context context) {
        if (pushLogWindow != null) {
            WindowManager windowManager = DebugViewManager.getWindowManager(context);
            windowManager.removeView((View)pushLogWindow);
        }
    }

    public static void removePushDataWindow(Context context) {
        if (pushDataWindow != null) {
            WindowManager windowManager = DebugViewManager.getWindowManager(context);
            windowManager.removeView((View)pushDataWindow);
            pushDataWindow = null;
        }
    }

    public static void removePushDiagramWindow(Context context) {
        if (pushDiagramWindow != null) {
            WindowManager windowManager = DebugViewManager.getWindowManager(context);
            windowManager.removeView((View)pushDiagramWindow);
        }
    }

    public static void openBigWindow(Context context) {
        DebugViewManager.createBigWindow(context);
        if (mHandler != null) {
            mHandler.post(mRunnable);
        }
    }

    private static WindowManager getWindowManager(Context context) {
        if (mWindowManager == null) {
            mWindowManager = (WindowManager)context.getSystemService("window");
        }
        return mWindowManager;
    }

    public static void showView(Context context) {
        mContext = context;
        if (DebugViewManager.permission(context)) {
            DebugViewManager.createSmallWindow(context);
            DebugViewManager.createPushLogView(context);
        }
    }

    public static void hideDebugView(Context context) {
        DebugViewManager.removePushLogWindow(context);
        DebugViewManager.removeBigWindow(context);
        DebugViewManager.removePushDataWindow(context);
        DebugViewManager.removeSmallWindow(context);
        DebugViewManager.removePushDiagramWindow(context);
        pushLogWindow = null;
        pushDiagramWindow = null;
        if (mHandler != null) {
            mHandler.removeCallbacks(mRunnable);
            mHandler = null;
        }
    }

    public static void recordFunction(final String string2) {
        if (pushLogWindow != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    pushLogWindow.updateData(string2);
                }
            });
        }
    }

    public static boolean permission(Context context) {
        boolean bl = true;
        if (Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)context)) {
            Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            bl = false;
        }
        return bl;
    }

    public static void setUpdateDebigListener(UpdateDebugInfo updateDebugInfo) {
        mUpdateDebugInfo = updateDebugInfo;
    }

    public static void copyFaceAsset(Context context) {
        int n2;
        byte[] byArray;
        String string2;
        FileOutputStream fileOutputStream;
        InputStream inputStream;
        AssetManager assetManager;
        Boolean bl;
        if (!new File(SD_DIR + "ldClassifier.jpg").exists()) {
            bl = true;
            assetManager = context.getAssets();
            inputStream = null;
            fileOutputStream = null;
            try {
                inputStream = assetManager.open("ldClassifier.jpg");
                string2 = SD_DIR + "ldClassifier.jpg";
                fileOutputStream = new FileOutputStream(string2);
                byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                }
                inputStream.close();
                inputStream = null;
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                fileOutputStream = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        if (!new File(SD_DIR + "fdmodel.jpg").exists()) {
            bl = true;
            assetManager = context.getAssets();
            inputStream = null;
            fileOutputStream = null;
            try {
                inputStream = assetManager.open("fdmodel.jpg");
                string2 = SD_DIR + "fdmodel.jpg";
                fileOutputStream = new FileOutputStream(string2);
                byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                }
                inputStream.close();
                inputStream = null;
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                fileOutputStream = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
        if (!new File(SD_DIR + "fa68_37v2_0308_5.jpg").exists()) {
            bl = true;
            assetManager = context.getAssets();
            inputStream = null;
            fileOutputStream = null;
            try {
                inputStream = assetManager.open("fa68_37v2_0308_5.jpg");
                string2 = SD_DIR + "fa68_37v2_0308_5.jpg";
                fileOutputStream = new FileOutputStream(string2);
                byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                }
                inputStream.close();
                inputStream = null;
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
                fileOutputStream = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
        }
    }

    static {
        SD_DIR = Environment.getExternalStorageDirectory().getPath() + File.separator;
        mHandler = new Handler();
        mAlivcLivePushDebugInfo = null;
        mRunnable = new Runnable(){

            @Override
            public void run() {
                Log.d((String)"DebugView", (String)"====== mRunnable run ======");
                new AsyncTask<AlivcLivePushDebugInfo, Void, AlivcLivePushDebugInfo>(){

                    protected AlivcLivePushDebugInfo doInBackground(AlivcLivePushDebugInfo ... alivcLivePushDebugInfoArray) {
                        try {
                            if (mUpdateDebugInfo != null) {
                                mAlivcLivePushDebugInfo = mUpdateDebugInfo.updateInfo();
                            }
                            if (mAlivcLivePushDebugInfo != null) {
                                mAlivcLivePushDebugInfo.setCpu(ParameterUtil.getProcessCpuRate());
                                mAlivcLivePushDebugInfo.setMemory(ParameterUtil.getRunningAppProcessInfo(mContext));
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        return mAlivcLivePushDebugInfo;
                    }

                    protected void onPostExecute(AlivcLivePushDebugInfo alivcLivePushDebugInfo) {
                        super.onPostExecute((Object)alivcLivePushDebugInfo);
                        if (bigWindow != null) {
                            bigWindow.updateInfo(alivcLivePushDebugInfo.getCpu(), alivcLivePushDebugInfo.getMemory());
                        }
                        if (alivcLivePushDebugInfo != null) {
                            if (pushDataWindow != null) {
                                pushDataWindow.updataData(alivcLivePushDebugInfo);
                            }
                            if (pushDiagramWindow != null && alivcLivePushDebugInfo.isPush()) {
                                pushDiagramWindow.updateData(alivcLivePushDebugInfo, ParameterUtil.getSecondTime());
                            }
                        }
                        if (mHandler != null) {
                            mHandler.postDelayed(mRunnable, 2000L);
                        }
                    }
                }.execute((Object[])new AlivcLivePushDebugInfo[0]);
            }
        };
        mUpdateDebugInfo = null;
    }

    public static interface UpdateDebugInfo {
        public AlivcLivePushDebugInfo updateInfo();
    }
}

