/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.debug;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Debug;
import android.os.Process;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ParameterUtil {
    public static int getInteger(Map<String, String> map, String string2) {
        if (map != null && string2 != null && map.containsKey(string2)) {
            String string3 = map.get(string2);
            if (string3 == null) {
                return 0;
            }
            try {
                int n2 = Integer.parseInt(string3);
                return n2;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return 0;
    }

    public static long getLong(Map<String, String> map, String string2) {
        if (map != null && string2 != null && map.containsKey(string2)) {
            String string3 = map.get(string2);
            if (string3 == null) {
                return 0L;
            }
            try {
                long l2 = Long.parseLong(string3);
                return l2;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return 0L;
    }

    public static float getProcessCpuRate() {
        float f2 = ParameterUtil.getTotalCpuTime();
        float f3 = ParameterUtil.getAppCpuTime();
        try {
            Thread.sleep(360L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        float f4 = ParameterUtil.getTotalCpuTime();
        float f5 = ParameterUtil.getAppCpuTime();
        float f6 = 100.0f * (f5 - f3) / (f4 - f2);
        return f6;
    }

    private static long getTotalCpuTime() {
        String[] stringArray = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            stringArray = string2.split(" ");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        long l2 = Long.parseLong((String)stringArray[2]) + Long.parseLong((String)stringArray[3]) + Long.parseLong((String)stringArray[4]) + Long.parseLong(stringArray[6]) + Long.parseLong(stringArray[5]) + Long.parseLong(stringArray[7]) + Long.parseLong(stringArray[8]);
        return l2;
    }

    private static long getAppCpuTime() {
        String[] stringArray = null;
        try {
            int n2 = Process.myPid();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + n2 + "/stat")), 1000);
            String string2 = bufferedReader.readLine();
            bufferedReader.close();
            stringArray = string2.split(" ");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        long l2 = Long.parseLong((String)stringArray[13]) + Long.parseLong((String)stringArray[14]) + Long.parseLong((String)stringArray[15]) + Long.parseLong((String)stringArray[16]);
        return l2;
    }

    public static float getRunningAppProcessInfo(Context context) {
        float f2 = 0.0f;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
            int n2 = runningAppProcessInfo.pid;
            int n3 = runningAppProcessInfo.uid;
            String string2 = runningAppProcessInfo.processName;
            int[] nArray = new int[]{n2};
            if (n2 != Process.myPid()) continue;
            Debug.MemoryInfo[] memoryInfoArray = activityManager.getProcessMemoryInfo(nArray);
            f2 = (float)memoryInfoArray[0].getTotalPss() / 1024.0f;
            break;
        }
        return f2;
    }

    public static String getTodayDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }

    public static String getSecondTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("mm:ss", Locale.getDefault());
        return simpleDateFormat.format(new Date());
    }
}

