/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.debug;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.alivc.debug.AlivcLivePushDebugInfo;
import com.alivc.debug.DebugViewManager;
import com.alivc.debug.LineChartData;
import com.alivc.debug.LineChartView;
import com.alivc.videochat.R;
import java.util.ArrayList;
import java.util.List;

public class PushDiagramView
extends LinearLayout {
    private static final int DATA_SIZE = 240;
    private TextView mClose;
    private TextView mClear;
    private TextView mStop;
    private LineChartView mPts;
    private LineChartView mVideoFps;
    private LineChartView mAudioFps;
    private LineChartView mVideoBit;
    private LineChartView mAudioBit;
    private List<LineChartData> mVPtsData = new ArrayList<LineChartData>();
    private List<LineChartData> mAPtsData = new ArrayList<LineChartData>();
    private List<LineChartData> mVFps = new ArrayList<LineChartData>();
    private List<LineChartData> mAFps = new ArrayList<LineChartData>();
    private List<LineChartData> mVBit = new ArrayList<LineChartData>();
    private List<LineChartData> mABit = new ArrayList<LineChartData>();
    private boolean isStop = false;

    public PushDiagramView(final Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.push_chart_log, (ViewGroup)this);
        View view = this.findViewById(R.id.push_chart_log);
        this.mPts = (LineChartView)view.findViewById(R.id.pts);
        this.mPts.setSize(1000000.0f);
        this.mVideoFps = (LineChartView)view.findViewById(R.id.video_fps);
        this.mAudioFps = (LineChartView)view.findViewById(R.id.audio_fps);
        this.mVideoBit = (LineChartView)view.findViewById(R.id.video_bitrate);
        this.mVideoBit.setSize(3000.0f);
        this.mAudioBit = (LineChartView)view.findViewById(R.id.audio_bitrate);
        this.mAudioBit.setSize(200.0f);
        this.mPts.setMdata(this.mVPtsData, this.mAPtsData);
        this.mVideoFps.setMdata(this.mVFps);
        this.mAudioFps.setMdata(this.mAFps);
        this.mVideoBit.setMdata(this.mVBit);
        this.mAudioBit.setMdata(this.mABit);
        this.mClose = (TextView)view.findViewById(R.id.close);
        this.mClear = (TextView)view.findViewById(R.id.clear);
        this.mStop = (TextView)view.findViewById(R.id.stop);
        this.mStop.setSelected(false);
        this.mClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DebugViewManager.removePushDiagramWindow(context);
                DebugViewManager.createBigWindow(context);
            }
        });
        this.mClear.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PushDiagramView.this.clearData();
            }
        });
        this.mStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PushDiagramView.this.mStop.setText((CharSequence)(PushDiagramView.this.mStop.isSelected() ? "stop" : "start"));
                PushDiagramView.this.isStop = !PushDiagramView.this.mStop.isSelected();
                PushDiagramView.this.mStop.setSelected(PushDiagramView.this.isStop);
            }
        });
    }

    public void updateData(AlivcLivePushDebugInfo alivcLivePushDebugInfo, String string) {
        if (this.isStop) {
            return;
        }
        if (this.mPts != null) {
            if (this.mPts.getSize() < (float)alivcLivePushDebugInfo.getCurrentlyUploadedVideoFramePts()) {
                this.mPts.setSize(this.mPts.getSize() * 100.0f);
            }
            this.mVPtsData.add(new LineChartData(string, alivcLivePushDebugInfo.getCurrentlyUploadedVideoFramePts()));
            this.mAPtsData.add(new LineChartData(string, alivcLivePushDebugInfo.getCurrentlyUploadedAudioFramePts()));
            if (this.mVPtsData.size() > 240) {
                this.mVPtsData.remove(0);
            }
            if (this.mAPtsData.size() > 240) {
                this.mAPtsData.remove(0);
            }
            this.mPts.setMdata(this.mVPtsData, this.mAPtsData);
        }
        if (this.mVideoFps != null) {
            this.mVFps.add(new LineChartData(string, alivcLivePushDebugInfo.getVideoEncodeFps()));
            if (this.mVFps.size() > 240) {
                this.mVFps.remove(0);
            }
            this.mVideoFps.setMdata(this.mVFps);
        }
        if (this.mAudioFps != null) {
            this.mAFps.add(new LineChartData(string, alivcLivePushDebugInfo.getAudioEncodeFps()));
            if (this.mAFps.size() > 240) {
                this.mAFps.remove(0);
            }
            this.mAudioFps.setMdata(this.mAFps);
        }
        if (this.mVideoBit != null) {
            this.mVBit.add(new LineChartData(string, alivcLivePushDebugInfo.getVideoUploadBitrate()));
            if (this.mVBit.size() > 240) {
                this.mVBit.remove(0);
            }
            this.mVideoBit.setMdata(this.mVBit);
        }
        if (this.mAudioBit != null) {
            this.mABit.add(new LineChartData(string, alivcLivePushDebugInfo.getAudioUploadBitrate()));
            if (this.mABit.size() > 240) {
                this.mABit.remove(0);
            }
            this.mAudioBit.setMdata(this.mABit);
        }
    }

    private void clearData() {
        this.mVPtsData.clear();
        this.mAPtsData.clear();
        this.mVFps.clear();
        this.mAFps.clear();
        this.mVBit.clear();
        this.mABit.clear();
    }
}

