/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.live.pusher;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.AudioManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.alivc.component.custom.AlivcLivePushCustomDetect;
import com.alivc.component.custom.AlivcLivePushCustomFilter;
import com.alivc.debug.AlivcLivePushDebugInfo;
import com.alivc.debug.DebugViewManager;
import com.alivc.live.pusher.AlivcEncodeModeEnum;
import com.alivc.live.pusher.AlivcImageFormat;
import com.alivc.live.pusher.AlivcLivePlayStats;
import com.alivc.live.pusher.AlivcLivePushBGMListener;
import com.alivc.live.pusher.AlivcLivePushCameraTypeEnum;
import com.alivc.live.pusher.AlivcLivePushConfig;
import com.alivc.live.pusher.AlivcLivePushError;
import com.alivc.live.pusher.AlivcLivePushErrorListener;
import com.alivc.live.pusher.AlivcLivePushInfoListener;
import com.alivc.live.pusher.AlivcLivePushLogLevel;
import com.alivc.live.pusher.AlivcLivePushNetworkListener;
import com.alivc.live.pusher.AlivcLivePushStats;
import com.alivc.live.pusher.AlivcLivePushStatsInfo;
import com.alivc.live.pusher.AlivcLivePusherRenderContextListener;
import com.alivc.live.pusher.AlivcPreviewDisplayMode;
import com.alivc.live.pusher.AlivcPreviewOrientationEnum;
import com.alivc.live.pusher.AlivcQualityModeEnum;
import com.alivc.live.pusher.AlivcResolutionEnum;
import com.alivc.live.pusher.AlivcSnapshotListener;
import com.alivc.live.pusher.AlivcSoundFormat;
import com.alivc.live.pusher.ILivePusher;
import com.alivc.live.pusher.LivePusherJNI;
import com.alivc.live.pusher.LogUtil;
import com.alivc.live.pusher.SurfaceStatus;
import com.alivc.live.pusher.WaterMarkInfo;
import com.alivc.live.pusher.a;
import com.alivc.live.pusher.a.a;
import com.alivc.live.pusher.a.b;
import com.alivc.live.pusher.a.c;
import com.alivc.live.pusher.a.d;
import com.alivc.live.pusher.a.e;
import com.alivc.live.pusher.a.f;
import com.alivc.live.pusher.a.g;
import com.alivc.live.pusher.a.h;
import com.alivc.live.pusher.a.i;
import com.alivc.live.pusher.a.j;
import com.alivc.live.pusher.a.k;
import com.alivc.live.pusher.a.l;
import com.alivc.live.pusher.a.m;
import com.alivc.live.pusher.a.n;
import com.alivc.live.pusher.a.o;
import com.alivc.live.pusher.a.p;
import com.alivc.live.pusher.a.q;
import com.alivc.live.pusher.a.r;
import com.alivc.live.pusher.a.s;
import com.alivc.live.pusher.a.t;
import com.alivc.live.pusher.a.u;
import com.alivc.live.pusher.a.v;
import com.alivc.live.pusher.a.w;
import com.alivc.live.pusher.a.x;
import com.aliyun.clientinforeport.AlivcEventPublicParam;
import com.aliyun.clientinforeport.util.RLog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class AlivcLivePusher
implements ILivePusher {
    private static LivePusherJNI mNativeAlivcLivePusher = null;
    private AlivcLivePushStats mPushStatus = AlivcLivePushStats.IDLE;
    private AlivcLivePlayStats mPlayStats = AlivcLivePlayStats.IDLE;
    private AlivcLivePushError mLastError = AlivcLivePushError.ALIVC_COMMON_RETURN_SUCCESS;
    private AlivcLivePushInfoListener mPushInfoListener = null;
    private AlivcLivePushErrorListener mPushErrorListener = null;
    private AlivcLivePushNetworkListener mPushNetworkListener = null;
    private AlivcLivePushBGMListener mPushBGMListener = null;
    private AlivcLivePusherRenderContextListener mRenderContextListener = null;
    private SurfaceStatus mSurfaceStatus = SurfaceStatus.UNINITED;
    private SurfaceView mPreviewView = null;
    private AudioManager mAudioManager = null;
    private Context mContext = null;
    private AlivcLivePushConfig mAlivcLivePushConfig = null;
    private static AlivcResolutionEnum res = AlivcResolutionEnum.RESOLUTION_540P;
    private static final int NTP_TIME_OUT_MILLISECOND = 1000;
    private static final String AUTH_KEY = "auth_key=";
    private static final int TIMESTAMP_LENGTH = 10;
    private static final int MAX_CHATS = 4000;
    private static final float TEXTURE_RANGE_MIN = 0.0f;
    private static final float TEXTURE_RANGE_MAX = 1.0f;
    private static final int MAX_DYNAMIC_ADDSON_COUNT = 5;
    private Map<Integer, AlivcLivePushError> mErrorMap = new HashMap<Integer, AlivcLivePushError>();
    private int mSkinSmooth = 40;
    private int mWhiten = 70;
    private int mBright = 0;
    private int mCheekPink = 15;
    private int mWholePink = 40;
    private int mSlimFace = 40;
    private int mShortenFace = 50;
    private int mBigEye = 30;
    private static String mPushUrl = null;
    private int mBGMVolume = 50;
    private int mCaptureVolume = 50;
    private boolean mMute = false;
    private TelephonyManager manager = null;
    private AlivcLivePushLogLevel mLogLevel = AlivcLivePushLogLevel.AlivcLivePushLogLevelError;
    private static final int SECOND = 1000;
    private static final int MESSAGE_RECONNECT_SUCCESS = 18;
    private boolean registeredCallback = false;
    protected a mBluetoothHelper;
    private boolean isReconnect = false;
    private AlivcEventPublicParam mAlivcEventPublicParam = null;
    private static boolean isDebugView = false;
    private long mTimeStamp = -1L;
    private int mExpiryTime = -1;
    private boolean mixRequireMain = false;
    private static String SD_DIR = Environment.getExternalStorageDirectory().getPath() + File.separator;
    private int mDynamicAddsonCount = 0;
    private ScreenRecordStatus mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_NONE;
    private String mDebugFunctionText = "[%1$s] <thread:%2$s> ";
    private Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            LogUtil.d("AlivcLivePusher", "AlivcLivePusher reconnect success");
            AlivcLivePusher.this.isReconnect = false;
            if (AlivcLivePusher.this.mPushNetworkListener != null) {
                AlivcLivePusher.this.mPushNetworkListener.onReconnectSucceed(AlivcLivePusher.this);
            }
        }
    };
    private SurfaceHolder.Callback mPreviewCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            LogUtil.d("AlivcLivePusher", "LiveActivity-->Preview surface created");
            if (AlivcLivePusher.this.mPreviewView == null) {
                return;
            }
            if (AlivcLivePusher.this.mSurfaceStatus == SurfaceStatus.UNINITED) {
                AlivcLivePusher.this.mSurfaceStatus = SurfaceStatus.CREATED;
            } else if (AlivcLivePusher.this.mSurfaceStatus == SurfaceStatus.DESTROYED) {
                AlivcLivePusher.this.mSurfaceStatus = SurfaceStatus.RECREATED;
                if (mNativeAlivcLivePusher != null) {
                    mNativeAlivcLivePusher.notifySurfaceReCreate(AlivcLivePusher.this.mPreviewView.getHolder().getSurface());
                }
            }
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
            LogUtil.d("AlivcLivePusher", "LiveActivity-->Preview surface changed");
            if (AlivcLivePusher.this.mPreviewView == null) {
                return;
            }
            AlivcLivePusher.this.mSurfaceStatus = SurfaceStatus.CHANGED;
            if (mNativeAlivcLivePusher != null) {
                mNativeAlivcLivePusher.notifySurfaceChange(surfaceHolder.getSurface(), AlivcLivePusher.this.mAlivcLivePushConfig.getPreviewOrientation());
            }
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            LogUtil.d("AlivcLivePusher", "LiveActivity-->Preview surface destroyed");
            if (AlivcLivePusher.this.mPreviewView == null) {
                return;
            }
            if (mNativeAlivcLivePusher != null) {
                mNativeAlivcLivePusher.notifySurfaceDestroy();
            }
            AlivcLivePusher.this.mSurfaceStatus = SurfaceStatus.DESTROYED;
        }
    };
    private ScheduledExecutorService executor5 = null;
    private BroadcastReceiver mHeadsetPlugReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String string = intent.getAction();
            if ("android.media.AUDIO_BECOMING_NOISY".equals(string)) {
                LogUtil.d("BluetoothHeadsetUtils", "ACTION_AUDIO_BECOMING_NOISY headset out");
                AlivcLivePusher.this.mAudioManager.setMode(0);
                AlivcLivePusher.this.mAudioManager.setSpeakerphoneOn(true);
                LivePusherJNI.headSetOn = false;
                if (mNativeAlivcLivePusher != null) {
                    mNativeAlivcLivePusher.setHeadSet(false);
                }
            } else if ("android.intent.action.HEADSET_PLUG".equals(string) && intent.hasExtra("state")) {
                if (intent.getIntExtra("state", 0) == 0) {
                    LogUtil.d("BluetoothHeadsetUtils", "headset out");
                    AlivcLivePusher.this.mAudioManager.setMode(0);
                    AlivcLivePusher.this.mAudioManager.setSpeakerphoneOn(true);
                    if (LivePusherJNI.headSetOn) {
                        LivePusherJNI.headSetOn = false;
                        if (mNativeAlivcLivePusher != null) {
                            mNativeAlivcLivePusher.setHeadSet(false);
                        }
                    }
                } else if (intent.getIntExtra("state", 0) == 1) {
                    LogUtil.d("BluetoothHeadsetUtils", "headset in");
                    AlivcLivePusher.this.mAudioManager.setSpeakerphoneOn(false);
                    LivePusherJNI.headSetOn = true;
                    if (mNativeAlivcLivePusher != null) {
                        mNativeAlivcLivePusher.setHeadSet(true);
                    }
                }
            }
        }
    };
    private BroadcastReceiver mTelephoneReceiver = new BroadcastReceiver(){
        PhoneStateListener stateListener = new PhoneStateListener(){

            public void onCallStateChanged(int n2, String string) {
                super.onCallStateChanged(n2, string);
                switch (n2) {
                    case 0: {
                        LogUtil.d("AlivcLivePusher", "PHONE: CALL_STATE_IDLE");
                        if (mNativeAlivcLivePusher == null) break;
                        mNativeAlivcLivePusher.setMute(false);
                        break;
                    }
                    case 2: {
                        LogUtil.d("AlivcLivePusher", "PHONE: CALL_STATE_OFFHOOK");
                        if (mNativeAlivcLivePusher == null) break;
                        mNativeAlivcLivePusher.setMute(true);
                        break;
                    }
                    case 1: {
                        LogUtil.d("AlivcLivePusher", "PHONE: CALL_STATE_RINGING");
                        if (mNativeAlivcLivePusher == null) break;
                        mNativeAlivcLivePusher.setMute(true);
                        break;
                    }
                }
            }
        };

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.intent.action.NEW_OUTGOING_CALL") && AlivcLivePusher.this.manager == null) {
                AlivcLivePusher.this.manager = (TelephonyManager)context.getSystemService("phone");
                AlivcLivePusher.this.manager.listen(this.stateListener, 32);
            }
        }
    };

    @Override
    public void init(Context context, AlivcLivePushConfig alivcLivePushConfig) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->init");
        if (this.mPushStatus != AlivcLivePushStats.IDLE && this.mPushStatus != AlivcLivePushStats.INIT) {
            throw new IllegalStateException("init state error, current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        RLog.setOpen((boolean)false);
        this.mContext = context;
        try {
            DebugViewManager.copyFaceAsset(this.mContext);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioManager.setMode(0);
        this.mAudioManager.setSpeakerphoneOn(true);
        this.registerHeadsetPlugReceiver();
        this.mBluetoothHelper = new a(this.mContext);
        this.mBluetoothHelper.a(new a.a(){

            @Override
            public void onBlueTooth(boolean bl) {
                LivePusherJNI.headSetOn = bl;
                if (!bl) {
                    AlivcLivePusher.this.mAudioManager.setMode(0);
                    AlivcLivePusher.this.mAudioManager.setSpeakerphoneOn(true);
                } else {
                    AlivcLivePusher.this.mAudioManager.setSpeakerphoneOn(false);
                }
                if (mNativeAlivcLivePusher != null) {
                    mNativeAlivcLivePusher.setHeadSet(bl);
                }
            }
        });
        this.mAlivcLivePushConfig = alivcLivePushConfig;
        this.checkConfig(alivcLivePushConfig);
        res = this.mAlivcLivePushConfig.getResolution();
        for (AlivcLivePushError alivcLivePushError : AlivcLivePushError.values()) {
            this.mErrorMap.put(alivcLivePushError.getCode(), alivcLivePushError);
        }
        mNativeAlivcLivePusher = new LivePusherJNI(this.mContext, alivcLivePushConfig, new LivePusherJNI.a(){

            @Override
            public void onNotify(int n2, String string, int n3, int n4, int n5, int n6, int n7, long l2) {
                if (n2 == AlivcLivePushError.ALIVC_PUSHER_ERROR_SDK_LIVE_PUSH_NETWORK_TOO_POOR.getCode()) {
                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Network Too Poor");
                    AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Network Too Poor");
                    if (AlivcLivePusher.this.mPushNetworkListener != null) {
                        AlivcLivePusher.this.mPushNetworkListener.onNetworkPoor(AlivcLivePusher.this);
                    }
                } else if (n2 == com.alivc.live.pusher.c.v.a()) {
                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Network Recovery");
                    AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Network Recovery");
                    if (AlivcLivePusher.this.mPushNetworkListener != null) {
                        AlivcLivePusher.this.mPushNetworkListener.onNetworkRecovery(AlivcLivePusher.this);
                    }
                } else if (n2 == com.alivc.live.pusher.c.w.a()) {
                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Reconnect Start");
                    AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Reconnect Start");
                    if (!AlivcLivePusher.this.isReconnect) {
                        AlivcLivePusher.this.isReconnect = true;
                        if (AlivcLivePusher.this.mPushNetworkListener != null) {
                            AlivcLivePusher.this.mPushNetworkListener.onReconnectStart(AlivcLivePusher.this);
                        }
                    }
                } else if (n2 == com.alivc.live.pusher.c.x.a()) {
                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Reconnect Success");
                    AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Reconnect Success");
                    if (AlivcLivePusher.this.mHandler != null) {
                        AlivcLivePusher.this.mHandler.removeMessages(18);
                        AlivcLivePusher.this.mHandler.sendEmptyMessageDelayed(18, 500L);
                    }
                    if (AlivcLivePusher.this.mPushStatus != AlivcLivePushStats.PAUSED) {
                        AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.PUSHED;
                    }
                } else if (n2 == AlivcLivePushError.ALIVC_PUSHER_ERROR_SDK_RTMP_RECONNECT_FAIL.getCode()) {
                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Reconnect Fail");
                    AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Reconnect Fail");
                    AlivcLivePusher.this.isReconnect = false;
                    if (AlivcLivePusher.this.mHandler != null) {
                        AlivcLivePusher.this.mHandler.removeMessages(18);
                    }
                    if (AlivcLivePusher.this.mPushNetworkListener != null) {
                        AlivcLivePusher.this.mPushNetworkListener.onReconnectFail(AlivcLivePusher.this);
                    }
                    AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.ERROR;
                    AlivcLivePusher.this.mLastError = AlivcLivePushError.ALIVC_PUSHER_ERROR_SDK_RTMP_RECONNECT_FAIL;
                } else if (n2 == AlivcLivePushError.ALIVC_PUSHER_ERROR_SDK_RTMP_SEND_DATA_TIMEOUT.getCode()) {
                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Send Data Timeout");
                    AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Send Data Timeout");
                    if (AlivcLivePusher.this.mPushNetworkListener != null) {
                        AlivcLivePusher.this.mPushNetworkListener.onSendDataTimeout(AlivcLivePusher.this);
                    }
                } else if (n2 == AlivcLivePushError.ALIVC_PUSHER_ERROR_SDK_RTMP_CONNECT.getCode()) {
                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback RTMP Connect Fail");
                    AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- RTMP Connect Fail");
                    if (AlivcLivePusher.this.mPushNetworkListener != null) {
                        AlivcLivePusher.this.mPushNetworkListener.onConnectFail(AlivcLivePusher.this);
                    }
                    AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.ERROR;
                    AlivcLivePusher.this.mLastError = AlivcLivePushError.ALIVC_PUSHER_ERROR_SDK_RTMP_CONNECT;
                } else if (n2 != com.alivc.live.pusher.c.a.a()) {
                    if (n2 == com.alivc.live.pusher.c.b.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Preview Started");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Preview Started");
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onPreviewStarted(AlivcLivePusher.this);
                        }
                        AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.PREVIEWED;
                        AlivcLivePusher.this.addWaterMark();
                    } else if (n2 == com.alivc.live.pusher.c.c.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Preview Stoped");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Preview Stoped");
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onPreviewStoped(AlivcLivePusher.this);
                        }
                        AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.INIT;
                    } else if (n2 == com.alivc.live.pusher.c.s.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Push Started");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Push Started");
                        AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.PUSHED;
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onPushStarted(AlivcLivePusher.this);
                        }
                    } else if (n2 == com.alivc.live.pusher.c.t.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Push Stoped");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Push Stoped");
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onPushStoped(AlivcLivePusher.this);
                        }
                    } else if (n2 == com.alivc.live.pusher.c.d.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Push Paused");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Push Paused");
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onPushPauesed(AlivcLivePusher.this);
                        }
                    } else if (n2 == com.alivc.live.pusher.c.e.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Push Resumed");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Push Resumed");
                        if (mNativeAlivcLivePusher.isPushing()) {
                            AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.PUSHED;
                        } else {
                            AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.PREVIEWED;
                        }
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onPushResumed(AlivcLivePusher.this);
                        }
                    } else if (n2 == AlivcLivePushError.ALIVC_FRAMEWORK_RENDER_FIRST_FRAME_PREVIEWED.getCode()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Preview First Frame");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Preview First Frame");
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onFirstFramePreviewed(AlivcLivePusher.this);
                        }
                    } else if (n2 == com.alivc.live.pusher.c.f.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Push Restarted");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Push Restarted");
                        AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.PUSHED;
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onPushRestarted(AlivcLivePusher.this);
                        }
                    } else if (n2 == com.alivc.live.pusher.c.y.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Drop Frame");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Drop Frame");
                        k.a a2 = new k.a();
                        a2.a = n3;
                        a2.b = n4;
                        a2.c = n5;
                        a2.d = n6;
                        k.a(AlivcLivePusher.this.mAlivcEventPublicParam, a2, AlivcLivePusher.this.mContext);
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onDropFrame(AlivcLivePusher.this, n3, n4);
                        }
                    } else if (n2 == com.alivc.live.pusher.c.i.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Adjust Bitrate");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Adjust Bitrate");
                        a.a a3 = new a.a();
                        a3.a = n3 / 1000;
                        a3.b = n4 / 1000;
                        Map map = AlivcLivePusher.this.getPerformanceMap();
                        if (map != null) {
                            a3.c = com.alivc.live.pusher.d.a(map, "mVideoEncodeBitrate") + com.alivc.live.pusher.d.a(map, "mAudioEncodeBitrate");
                            a3.d = com.alivc.live.pusher.d.a(map, "mAudioUploadBitrate") + com.alivc.live.pusher.d.a(map, "mVideoUploadBitrate");
                        }
                        com.alivc.live.pusher.a.a.a(AlivcLivePusher.this.mAlivcEventPublicParam, a3, AlivcLivePusher.this.mContext);
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onAdjustBitRate(AlivcLivePusher.this, n3 / 1000, n4 / 1000);
                        }
                    } else if (n2 == com.alivc.live.pusher.c.j.a()) {
                        LogUtil.d("AlivcLivePusher", "AlivcLivePusher Callback Change FPS");
                        AlivcLivePusher.this.recordFunction(AlivcLivePusher.this.mContext, "CallBack -- Change FPS");
                        b.a a4 = new b.a();
                        a4.a = n3;
                        a4.b = n4;
                        b.a(AlivcLivePusher.this.mAlivcEventPublicParam, a4, AlivcLivePusher.this.mContext);
                        if (AlivcLivePusher.this.mPushInfoListener != null) {
                            AlivcLivePusher.this.mPushInfoListener.onAdjustFps(AlivcLivePusher.this, n3, n4);
                        }
                    } else if (n2 != com.alivc.live.pusher.c.k.a()) {
                        if (n2 == com.alivc.live.pusher.c.z.a()) {
                            v.a a5 = new v.a();
                            a5.b = n4;
                            a5.a = n3;
                            a5.c = AlivcLivePusher.this.mAlivcLivePushConfig.getResolution().toString().substring(11);
                            a5.d = AlivcLivePusher.this.mAlivcLivePushConfig.getAudioChannels() == 1 ? "single" : "dual";
                            a5.e = AlivcLivePusher.this.mAlivcLivePushConfig.isAudioOnly();
                            a5.f = AlivcLivePusher.this.mAlivcLivePushConfig.isVideoOnly();
                            a5.g = AlivcLivePusher.this.mAlivcLivePushConfig.getVideoEncodeMode().equals((Object)AlivcEncodeModeEnum.Encode_MODE_HARD);
                            a5.h = AlivcLivePusher.this.mAlivcLivePushConfig.getWaterMarkInfos().size();
                            a5.i = AlivcLivePusher.this.mAlivcLivePushConfig.isPushMirror();
                            a5.j = AlivcLivePusher.this.mAlivcLivePushConfig.getFps();
                            a5.k = AlivcLivePusher.this.mAlivcLivePushConfig.getInitialVideoBitrate();
                            a5.l = AlivcLivePusher.this.mAlivcLivePushConfig.getTargetVideoBitrate();
                            a5.m = AlivcLivePusher.this.mAlivcLivePushConfig.getMinVideoBitrate();
                            a5.n = AlivcLivePusher.this.mAlivcLivePushConfig.getAudioSamepleRate().getAudioSampleRate();
                            a5.o = AlivcLivePusher.this.mAlivcLivePushConfig.getPreviewOrientation();
                            a5.p = AlivcLivePusher.this.mAlivcLivePushConfig.getCameraType();
                            a5.q = AlivcLivePusher.this.mAlivcLivePushConfig.isBeautyOn();
                            a5.s = AlivcLivePusher.this.mAlivcLivePushConfig.getBeautyWhite();
                            a5.t = AlivcLivePusher.this.mAlivcLivePushConfig.getBeautyBuffing();
                            a5.u = AlivcLivePusher.this.mAlivcLivePushConfig.getBeautyRuddy();
                            a5.v = AlivcLivePusher.this.mAlivcLivePushConfig.getBeautyThinFace();
                            a5.r = AlivcLivePusher.this.mAlivcLivePushConfig.getBeautyCheekPink();
                            a5.w = AlivcLivePusher.this.mAlivcLivePushConfig.getBeautyShortenFace();
                            a5.x = AlivcLivePusher.this.mAlivcLivePushConfig.getBeautyBigEye();
                            a5.y = AlivcLivePusher.this.mAlivcLivePushConfig.isFlash();
                            a5.z = AlivcLivePusher.this.mAlivcLivePushConfig.getConnectRetryCount();
                            a5.A = AlivcLivePusher.this.mAlivcLivePushConfig.getConnectRetryInterval();
                            a5.B = AlivcLivePusher.this.mAlivcLivePushConfig.isPreviewMirror();
                            a5.C = AlivcLivePusher.this.mAlivcLivePushConfig.getVideoEncodeGop();
                            a5.D = AlivcLivePusher.this.mAlivcLivePushConfig.getConnectRetryCount() * AlivcLivePusher.this.mAlivcLivePushConfig.getConnectRetryInterval() / 1000;
                            v.a(AlivcLivePusher.this.mAlivcEventPublicParam, a5, AlivcLivePusher.this.mContext);
                            if (AlivcLivePusher.this.mPushInfoListener != null) {
                                AlivcLivePusher.this.mPushInfoListener.onFirstAVFramePushed(AlivcLivePusher.this);
                            }
                        } else if (n2 != com.alivc.live.pusher.c.n.a() && n2 != com.alivc.live.pusher.c.o.a() && n2 != com.alivc.live.pusher.c.p.a() && n2 != com.alivc.live.pusher.c.g.a() && n2 != com.alivc.live.pusher.c.h.a()) {
                            if (n2 == com.alivc.live.pusher.c.A.a()) {
                                if (AlivcLivePusher.this.mPushNetworkListener != null) {
                                    AlivcLivePusher.this.mPushNetworkListener.onSendMessage(AlivcLivePusher.this);
                                }
                            } else if (n2 == AlivcLivePushError.ALIVC_PUSHER_ERROR_BGM_OPEN_FAILED.getCode()) {
                                AlivcLivePusher.this.mPlayStats = AlivcLivePlayStats.IDLE;
                                if (AlivcLivePusher.this.mPushBGMListener != null) {
                                    AlivcLivePusher.this.mPushBGMListener.onOpenFailed();
                                }
                                if (mNativeAlivcLivePusher != null) {
                                    mNativeAlivcLivePusher.stopBGM();
                                }
                            } else if (n2 == AlivcLivePushError.ALIVC_PUSHER_ERROR_BGM_TIMEOUT.getCode()) {
                                AlivcLivePusher.this.mPlayStats = AlivcLivePlayStats.IDLE;
                                if (AlivcLivePusher.this.mPushBGMListener != null) {
                                    AlivcLivePusher.this.mPushBGMListener.onDownloadTimeout();
                                }
                            } else if (n2 == com.alivc.live.pusher.c.B.a()) {
                                AlivcLivePusher.this.mPlayStats = AlivcLivePlayStats.STARTED;
                                if (AlivcLivePusher.this.mPushBGMListener != null) {
                                    AlivcLivePusher.this.mPushBGMListener.onStarted();
                                }
                            } else if (n2 == com.alivc.live.pusher.c.C.a()) {
                                AlivcLivePusher.this.mPlayStats = AlivcLivePlayStats.STOPED;
                                if (AlivcLivePusher.this.mPushBGMListener != null) {
                                    AlivcLivePusher.this.mPushBGMListener.onStoped();
                                }
                            } else if (n2 == com.alivc.live.pusher.c.D.a()) {
                                AlivcLivePusher.this.mPlayStats = AlivcLivePlayStats.PAUSED;
                                if (AlivcLivePusher.this.mPushBGMListener != null) {
                                    AlivcLivePusher.this.mPushBGMListener.onPaused();
                                }
                            } else if (n2 == com.alivc.live.pusher.c.E.a()) {
                                AlivcLivePusher.this.mPlayStats = AlivcLivePlayStats.STARTED;
                                if (AlivcLivePusher.this.mPushBGMListener != null) {
                                    AlivcLivePusher.this.mPushBGMListener.onResumed();
                                }
                            } else if (n2 == com.alivc.live.pusher.c.F.a()) {
                                if (AlivcLivePusher.this.mPushBGMListener != null) {
                                    AlivcLivePusher.this.mPushBGMListener.onCompleted();
                                }
                                AlivcLivePusher.this.mPlayStats = AlivcLivePlayStats.IDLE;
                            } else if (n2 == com.alivc.live.pusher.c.G.a()) {
                                if (AlivcLivePusher.this.mPushBGMListener != null) {
                                    AlivcLivePusher.this.mPushBGMListener.onProgress(n3, n4);
                                }
                            } else if (n2 != com.alivc.live.pusher.c.q.a() && n2 != com.alivc.live.pusher.c.r.a()) {
                                if (n2 == com.alivc.live.pusher.c.l.a()) {
                                    if (AlivcLivePusher.this.mRenderContextListener != null) {
                                        AlivcLivePusher.this.mRenderContextListener.onSharedContextCreated(l2);
                                    }
                                } else if (n2 == com.alivc.live.pusher.c.m.a()) {
                                    if (AlivcLivePusher.this.mRenderContextListener != null) {
                                        AlivcLivePusher.this.mRenderContextListener.onSharedContextDestroyed(l2);
                                    }
                                } else if (n2 > 0x30010000 && n2 < 0x30020000) {
                                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher SystemError Callback error: " + n2);
                                    if (AlivcLivePusher.this.mErrorMap.get(n2) != null) {
                                        ((AlivcLivePushError)((Object)AlivcLivePusher.this.mErrorMap.get(n2))).setMsg(string);
                                    }
                                    if (AlivcLivePusher.this.mPushErrorListener != null) {
                                        AlivcLivePusher.this.mPushErrorListener.onSystemError(AlivcLivePusher.this, (AlivcLivePushError)((Object)AlivcLivePusher.this.mErrorMap.get(n2)));
                                    }
                                    l.a a6 = new l.a();
                                    Map map = AlivcLivePusher.this.getPerformanceMap();
                                    if (map != null) {
                                        a6.c = com.alivc.live.pusher.d.b(map, "mTotalSizeOfUploadedPackets");
                                        a6.d = com.alivc.live.pusher.d.b(map, "mTotalTimeOfPublishing");
                                        a6.a = n2;
                                        if (AlivcLivePusher.this.mErrorMap.get(n2) != null) {
                                            a6.b = string;
                                        }
                                        l.a(AlivcLivePusher.this.mAlivcEventPublicParam, a6, AlivcLivePusher.this.mContext);
                                    }
                                    AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.ERROR;
                                    AlivcLivePusher.this.mLastError = AlivcLivePushError.getErrorByCode(n2);
                                } else {
                                    LogUtil.d("AlivcLivePusher", "AlivcLivePusher SDKError Callback error: " + n2);
                                    if (AlivcLivePusher.this.mErrorMap.get(n2) != null) {
                                        ((AlivcLivePushError)((Object)AlivcLivePusher.this.mErrorMap.get(n2))).setMsg(string);
                                    }
                                    if (AlivcLivePusher.this.mPushErrorListener != null) {
                                        AlivcLivePusher.this.mPushErrorListener.onSDKError(AlivcLivePusher.this, (AlivcLivePushError)((Object)AlivcLivePusher.this.mErrorMap.get(n2)));
                                    }
                                    l.a a7 = new l.a();
                                    Map map = AlivcLivePusher.this.getPerformanceMap();
                                    if (map != null) {
                                        a7.c = com.alivc.live.pusher.d.b(map, "mTotalSizeOfUploadedPackets");
                                        a7.d = com.alivc.live.pusher.d.b(map, "mTotalTimeOfPublishing");
                                        a7.a = n2;
                                        if (AlivcLivePusher.this.mErrorMap.get(n2) != null) {
                                            a7.b = string;
                                        }
                                        l.a(AlivcLivePusher.this.mAlivcEventPublicParam, a7, AlivcLivePusher.this.mContext);
                                    }
                                    AlivcLivePusher.this.mPushStatus = AlivcLivePushStats.ERROR;
                                    AlivcLivePusher.this.mLastError = AlivcLivePushError.getErrorByCode(n2);
                                    LogUtil.d("AlivcLivePusher", "error is " + n2 + " msg is " + n2);
                                }
                            }
                        }
                    }
                }
            }
        });
        mNativeAlivcLivePusher.init();
        this.recordFunction(this.mContext, "Init");
        this.setLogLevel(this.mLogLevel);
        this.mPushStatus = AlivcLivePushStats.INIT;
        this.mAlivcEventPublicParam = new AlivcEventPublicParam(this.mContext);
        this.mAlivcEventPublicParam.setModule("publisher");
        this.mAlivcEventPublicParam.setVideoType(AlivcEventPublicParam.VideoType.live);
        this.mAlivcEventPublicParam.setUi(null);
        this.mAlivcEventPublicParam.setProduct("pusher");
        this.mAlivcEventPublicParam.setSubModule("pusher");
        this.mAlivcEventPublicParam.setLogStore("pubchat");
        this.mAlivcEventPublicParam.setAppVersion(AlivcLivePusher.getSDKVersion());
        this.mAlivcEventPublicParam.setLogLevel(AlivcEventPublicParam.LogLevel.info);
        this.mAlivcEventPublicParam.setCdnIp("0.0.0.0");
        this.mAlivcEventPublicParam.setUserAgent("");
        this.mAlivcEventPublicParam.setReferer("aliyun");
    }

    @Override
    public void destroy() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->destroy");
        this.recordFunction(this.mContext, "Destroy");
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.release();
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.release();
        }
        this.mDynamicAddsonCount = 0;
        if (this.registeredCallback) {
            try {
                this.mContext.unregisterReceiver(this.mHeadsetPlugReceiver);
                this.mContext.unregisterReceiver(this.mTelephoneReceiver);
            }
            catch (Exception exception) {
                LogUtil.d("AlivcLivePusher", "unregisterReceiver exception");
            }
            this.registeredCallback = false;
        }
        if (this.mBluetoothHelper != null) {
            this.mBluetoothHelper.a();
        }
        this.mPushStatus = AlivcLivePushStats.IDLE;
        this.stop5Interval();
        mNativeAlivcLivePusher = null;
        this.mPushInfoListener = null;
        this.mPushErrorListener = null;
        this.mPushNetworkListener = null;
        this.mPreviewView = null;
        this.mContext = null;
        this.mAlivcLivePushConfig = null;
        this.mErrorMap = null;
        this.mPreviewCallback = null;
        if (this.mHandler != null) {
            this.mHandler.removeMessages(18);
        }
        this.mHandler = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startPreview(SurfaceView surfaceView) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->startPreview");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.INIT && this.mPushStatus != AlivcLivePushStats.PREVIEWED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mPreviewView = surfaceView;
        int n2 = 0;
        if (surfaceView == null) {
            n2 = mNativeAlivcLivePusher.startPreview(null, true);
            if (n2 != 0) throw new IllegalStateException("start preview error");
            this.mPushStatus = AlivcLivePushStats.PREVIEWED;
        } else {
            n2 = mNativeAlivcLivePusher.startPreview(surfaceView.getHolder().getSurface(), true);
            if (n2 != 0) throw new IllegalStateException("start preview error");
            surfaceView.getHolder().addCallback(this.mPreviewCallback);
            this.mPushStatus = AlivcLivePushStats.PREVIEWED;
        }
        if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() != null) {
            mNativeAlivcLivePusher.setBeauty(false, 0, 0);
        }
        this.recordFunction(this.mContext, "StartPreview -- Sync:Sync Return " + n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startPreviewAysnc(SurfaceView surfaceView) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->startPreviewAysnc");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.INIT && this.mPushStatus != AlivcLivePushStats.PREVIEWED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mPushStatus = AlivcLivePushStats.PREVIEING;
        this.mPreviewView = surfaceView;
        int n2 = 0;
        if (surfaceView == null) {
            n2 = mNativeAlivcLivePusher.startPreview(null, false);
            if (n2 != 0) throw new IllegalStateException("start preview aysnc error");
            this.mPushStatus = AlivcLivePushStats.PREVIEWED;
        } else {
            n2 = mNativeAlivcLivePusher.startPreview(surfaceView.getHolder().getSurface(), false);
            if (n2 != 0) throw new IllegalStateException("start preview aysnc error");
            surfaceView.getHolder().addCallback(this.mPreviewCallback);
            this.mPushStatus = AlivcLivePushStats.PREVIEWED;
        }
        if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() != null) {
            mNativeAlivcLivePusher.setBeauty(false, 0, 0);
        }
        this.recordFunction(this.mContext, "StartPreview -- Sync:Async Return " + n2);
    }

    @Override
    public void stopPreview() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->stopPreview");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        this.mDynamicAddsonCount = 0;
        if (this.mPushStatus != AlivcLivePushStats.INIT && this.mPushStatus != AlivcLivePushStats.PREVIEWED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        int n2 = mNativeAlivcLivePusher.stopPreview();
        if (n2 != 0) {
            throw new IllegalStateException("stop preview error");
        }
        this.mPushStatus = AlivcLivePushStats.INIT;
        this.recordFunction(this.mContext, "StopPreview -- Sync:Sync Return " + n2);
    }

    @Override
    public void startPush(String string) {
        int n2;
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->startPush");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.INIT && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        if (this.mPushStatus.equals((Object)AlivcLivePushStats.INIT)) {
            this.mPreviewView = null;
            n2 = mNativeAlivcLivePusher.startPreview(null, true);
            if (n2 != 0) {
                throw new IllegalStateException("start push error : create gl resource failed");
            }
        }
        if ((mPushUrl = string).contains(AUTH_KEY)) {
            this.getNetworkTime();
        }
        if (this.mAlivcEventPublicParam != null) {
            this.mAlivcEventPublicParam.setVideoUrl(string);
        }
        if ((n2 = mNativeAlivcLivePusher.startPush(string, true)) == 0) {
            if (this.mPushStatus != AlivcLivePushStats.PUSHED) {
                this.mPushStatus = AlivcLivePushStats.PUSHED;
                if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() != null) {
                    this.mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_NORMAL;
                }
            }
        } else {
            throw new IllegalStateException("start push error");
        }
        String string2 = this.mAlivcLivePushConfig.getPausePushImage() == null ? "" : this.mAlivcLivePushConfig.getPausePushImage();
        String string3 = this.mAlivcLivePushConfig.getNetworkPoorPushImage() == null ? "" : this.mAlivcLivePushConfig.getNetworkPoorPushImage();
        mNativeAlivcLivePusher.addPushImage(string2, string3);
        this.start5Interval();
        this.recordFunction(this.mContext, "StartPush -- Sync:Sync Return " + n2);
    }

    @Override
    public void startPushAysnc(String string) {
        int n2;
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->startPushAysnc");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.INIT && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        if (this.mPushStatus.equals((Object)AlivcLivePushStats.INIT)) {
            this.mPreviewView = null;
            n2 = mNativeAlivcLivePusher.startPreview(null, true);
            if (n2 != 0) {
                throw new IllegalStateException("start push error : create gl resource failed");
            }
        }
        if ((mPushUrl = string).contains(AUTH_KEY)) {
            this.getNetworkTime();
        }
        if (this.mAlivcEventPublicParam != null) {
            this.mAlivcEventPublicParam.setVideoUrl(string);
        }
        if ((n2 = mNativeAlivcLivePusher.startPush(string, false)) == 0) {
            if (this.mPushStatus != AlivcLivePushStats.PUSHED) {
                this.mPushStatus = AlivcLivePushStats.PUSHED;
                if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() != null) {
                    this.mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_NORMAL;
                }
            }
        } else {
            throw new IllegalStateException("start push aysnc error");
        }
        String string2 = this.mAlivcLivePushConfig.getPausePushImage() == null ? "" : this.mAlivcLivePushConfig.getPausePushImage();
        String string3 = this.mAlivcLivePushConfig.getNetworkPoorPushImage() == null ? "" : this.mAlivcLivePushConfig.getNetworkPoorPushImage();
        mNativeAlivcLivePusher.addPushImage(string2, string3);
        this.start5Interval();
        this.recordFunction(this.mContext, "StartPush -- Sync:Async Return " + n2);
    }

    @Override
    public void restartPush() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->restartPush");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPreviewView == null && this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() == null && !this.mAlivcLivePushConfig.isAudioOnly()) {
            throw new IllegalArgumentException("illegal argument");
        }
        if (this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.ERROR) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mDynamicAddsonCount = 0;
        this.stop5Interval();
        int n2 = mNativeAlivcLivePusher.restartPush(this.mPreviewView.getHolder().getSurface(), true, 1000);
        if (n2 == 0) {
            this.mPushStatus = AlivcLivePushStats.PUSHED;
            if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() != null) {
                this.mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_NORMAL;
            }
        } else {
            throw new IllegalStateException("restart push error");
        }
        String string = this.mAlivcLivePushConfig.getPausePushImage() == null ? "" : this.mAlivcLivePushConfig.getPausePushImage();
        String string2 = this.mAlivcLivePushConfig.getNetworkPoorPushImage() == null ? "" : this.mAlivcLivePushConfig.getNetworkPoorPushImage();
        mNativeAlivcLivePusher.addPushImage(string, string2);
        this.recordFunction(this.mContext, "RestartPush -- Sync:Sync Return " + n2);
        t.a a2 = new t.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.b = com.alivc.live.pusher.d.a(map, "mVideoDurationFromeCaptureToUpload");
            a2.a = com.alivc.live.pusher.d.a(map, "mAudioDurationFromeCaptureToUpload");
            a2.c = this.mAlivcLivePushConfig.getResolution().toString().substring(11);
            a2.d = this.mAlivcLivePushConfig.getAudioChannels() == 1 ? "single" : "dual";
            a2.e = this.mAlivcLivePushConfig.isAudioOnly();
            a2.f = this.mAlivcLivePushConfig.getVideoEncodeMode().equals((Object)AlivcEncodeModeEnum.Encode_MODE_HARD);
            a2.g = this.mAlivcLivePushConfig.getWaterMarkInfos().size();
            a2.h = this.mAlivcLivePushConfig.isPushMirror();
            a2.i = this.mAlivcLivePushConfig.getFps();
            a2.j = this.mAlivcLivePushConfig.getInitialVideoBitrate();
            a2.k = this.mAlivcLivePushConfig.getTargetVideoBitrate();
            a2.l = this.mAlivcLivePushConfig.getMinVideoBitrate();
            a2.m = this.mAlivcLivePushConfig.getAudioSamepleRate().getAudioSampleRate();
            a2.n = this.mAlivcLivePushConfig.getPreviewOrientation();
            a2.o = this.mAlivcLivePushConfig.getCameraType();
            a2.p = this.mAlivcLivePushConfig.isBeautyOn();
            a2.q = this.mAlivcLivePushConfig.getBeautyWhite();
            a2.r = this.mAlivcLivePushConfig.getBeautyBuffing();
            a2.s = this.mAlivcLivePushConfig.getBeautyRuddy();
            a2.t = this.mAlivcLivePushConfig.getBeautyThinFace();
            a2.w = this.mAlivcLivePushConfig.getBeautyCheekPink();
            a2.u = this.mAlivcLivePushConfig.getBeautyShortenFace();
            a2.v = this.mAlivcLivePushConfig.getBeautyBigEye();
            a2.x = this.mAlivcLivePushConfig.isFlash();
            a2.y = this.mAlivcLivePushConfig.getConnectRetryCount();
            a2.z = this.mAlivcLivePushConfig.getConnectRetryInterval();
            a2.A = this.mAlivcLivePushConfig.isPreviewMirror();
            a2.B = this.mAlivcLivePushConfig.getVideoEncodeGop();
            a2.C = this.mAlivcLivePushConfig.getConnectRetryCount() * this.mAlivcLivePushConfig.getConnectRetryInterval() / 1000;
            t.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
        this.start5Interval();
    }

    @Override
    public void restartPushAync() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->restartPushAync");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPreviewView == null && this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() == null && !this.mAlivcLivePushConfig.isAudioOnly()) {
            throw new IllegalArgumentException("illegal argument");
        }
        if (this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.ERROR) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        int n2 = mNativeAlivcLivePusher.restartPush(this.mPreviewView.getHolder().getSurface(), false, 1000);
        if (n2 != 0) {
            throw new IllegalStateException("restart push aysnc error");
        }
        this.mPushStatus = AlivcLivePushStats.RESTARTING;
        String string = this.mAlivcLivePushConfig.getPausePushImage() == null ? "" : this.mAlivcLivePushConfig.getPausePushImage();
        String string2 = this.mAlivcLivePushConfig.getNetworkPoorPushImage() == null ? "" : this.mAlivcLivePushConfig.getNetworkPoorPushImage();
        mNativeAlivcLivePusher.addPushImage(string, string2);
        this.recordFunction(this.mContext, "RestartPush -- Sync:Async Return " + n2);
        this.stop5Interval();
        t.a a2 = new t.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.b = com.alivc.live.pusher.d.b(map, "mVideoDurationFromeCaptureToUpload");
            a2.a = com.alivc.live.pusher.d.b(map, "mAudioDurationFromeCaptureToUpload");
            a2.c = this.mAlivcLivePushConfig.getResolution().toString().substring(11);
            a2.d = this.mAlivcLivePushConfig.getAudioChannels() == 1 ? "single" : "dual";
            a2.e = this.mAlivcLivePushConfig.isAudioOnly();
            a2.f = this.mAlivcLivePushConfig.getVideoEncodeMode().equals((Object)AlivcEncodeModeEnum.Encode_MODE_HARD);
            a2.g = this.mAlivcLivePushConfig.getWaterMarkInfos().size();
            a2.h = this.mAlivcLivePushConfig.isPushMirror();
            a2.i = this.mAlivcLivePushConfig.getFps();
            a2.j = this.mAlivcLivePushConfig.getInitialVideoBitrate();
            a2.k = this.mAlivcLivePushConfig.getTargetVideoBitrate();
            a2.l = this.mAlivcLivePushConfig.getMinVideoBitrate();
            a2.m = this.mAlivcLivePushConfig.getAudioSamepleRate().getAudioSampleRate();
            a2.n = this.mAlivcLivePushConfig.getPreviewOrientation();
            a2.o = this.mAlivcLivePushConfig.getCameraType();
            a2.p = this.mAlivcLivePushConfig.isBeautyOn();
            a2.q = this.mAlivcLivePushConfig.getBeautyWhite();
            a2.r = this.mAlivcLivePushConfig.getBeautyBuffing();
            a2.s = this.mAlivcLivePushConfig.getBeautyRuddy();
            a2.t = this.mAlivcLivePushConfig.getBeautyThinFace();
            a2.w = this.mAlivcLivePushConfig.getBeautyCheekPink();
            a2.u = this.mAlivcLivePushConfig.getBeautyShortenFace();
            a2.v = this.mAlivcLivePushConfig.getBeautyBigEye();
            a2.x = this.mAlivcLivePushConfig.isFlash();
            a2.y = this.mAlivcLivePushConfig.getConnectRetryCount();
            a2.z = this.mAlivcLivePushConfig.getConnectRetryInterval();
            a2.A = this.mAlivcLivePushConfig.isPreviewMirror();
            a2.B = this.mAlivcLivePushConfig.getVideoEncodeGop();
            a2.C = this.mAlivcLivePushConfig.getConnectRetryCount() * this.mAlivcLivePushConfig.getConnectRetryInterval() / 1000;
            t.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
        this.start5Interval();
    }

    @Override
    public void reconnectPushAsync(String string) {
        int n2;
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->reconnectPushAsync");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.PAUSED && this.mPushStatus != AlivcLivePushStats.ERROR) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        if ((string == null || "".equals(string)) && this.isNetworkPushing()) {
            return;
        }
        if (string != null && !"".equals(string)) {
            mPushUrl = string;
            this.getNetworkTime();
        }
        if ((n2 = mNativeAlivcLivePusher.reconnect(string, false)) == 0) {
            this.isReconnect = false;
            if (this.mHandler != null) {
                this.mHandler.removeMessages(18);
            }
            this.mPushStatus = AlivcLivePushStats.PUSHED;
            if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() != null) {
                this.mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_NORMAL;
            }
        } else {
            throw new IllegalStateException("reconnect push async error");
        }
        this.recordFunction(this.mContext, "ReconnectPushAsync -- Sync:Async Return " + n2);
        s.a a2 = new s.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.b = com.alivc.live.pusher.d.b(map, "mVideoDurationFromeCaptureToUpload");
            a2.a = com.alivc.live.pusher.d.b(map, "mAudioDurationFromeCaptureToUpload");
            s.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
    }

    @Override
    public void stopPush() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->stopPush");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.PAUSED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        int n2 = mNativeAlivcLivePusher.stopPush();
        if (n2 != 0) {
            throw new IllegalStateException("stop push error");
        }
        this.mPushStatus = AlivcLivePushStats.PREVIEWED;
        if (this.mPreviewView == null) {
            mNativeAlivcLivePusher.stopPreview();
            this.mPushStatus = AlivcLivePushStats.INIT;
        }
        this.recordFunction(this.mContext, "StopPush -- Sync:Sync Return " + n2);
        w.a a2 = new w.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.a = com.alivc.live.pusher.d.b(map, "mTotalSizeOfUploadedPackets");
            a2.b = com.alivc.live.pusher.d.b(map, "mTotalTimeOfPublishing");
            w.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
        if (this.mAlivcEventPublicParam != null) {
            this.mAlivcEventPublicParam.setVideoUrl(null);
        }
        this.stop5Interval();
    }

    @Override
    public void pause() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->pause");
        if (this.mAlivcLivePushConfig.isExternMainStream()) {
            return;
        }
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.PAUSED && this.mPushStatus != AlivcLivePushStats.PREVIEWED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mPushStatus = AlivcLivePushStats.PAUSED;
        mNativeAlivcLivePusher.pause();
        this.recordFunction(this.mContext, "Pause -- Sync:Async");
        r.a a2 = new r.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.a = com.alivc.live.pusher.d.b(map, "mTotalSizeOfUploadedPackets");
            a2.b = com.alivc.live.pusher.d.b(map, "mTotalTimeOfPublishing");
            r.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
    }

    @Override
    public void resume() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->resume");
        if (this.mAlivcLivePushConfig.isExternMainStream()) {
            return;
        }
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PAUSED && this.mPushStatus != AlivcLivePushStats.ERROR) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.resume(true);
        this.recordFunction(this.mContext, "Resume -- Sync:sync");
        u.a a2 = new u.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.a = com.alivc.live.pusher.d.b(map, "mTotalSizeOfUploadedPackets");
            a2.b = com.alivc.live.pusher.d.b(map, "mTotalTimeOfPublishing");
            a2.c = System.currentTimeMillis() - r.a;
            u.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
        this.mPushStatus = mNativeAlivcLivePusher.isPushing() ? AlivcLivePushStats.PUSHED : AlivcLivePushStats.PREVIEWED;
    }

    @Override
    public void resumeAsync() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->resumeAsync");
        if (this.mAlivcLivePushConfig.isExternMainStream()) {
            return;
        }
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PAUSED && this.mPushStatus != AlivcLivePushStats.ERROR) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mPushStatus = AlivcLivePushStats.RESUMING;
        mNativeAlivcLivePusher.resume(false);
        this.recordFunction(this.mContext, "StopPush -- Sync:Async");
        u.a a2 = new u.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.a = com.alivc.live.pusher.d.b(map, "mTotalSizeOfUploadedPackets");
            a2.b = com.alivc.live.pusher.d.b(map, "mTotalTimeOfPublishing");
            a2.c = System.currentTimeMillis() - r.a;
            u.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
    }

    @Override
    public void pauseScreenCapture() {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.PAUSED && this.mPushStatus != AlivcLivePushStats.PREVIEWED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mPushStatus = AlivcLivePushStats.PAUSED;
        mNativeAlivcLivePusher.pauseScreenCapture();
        this.recordFunction(this.mContext, "Pause -- Sync:Async");
        r.a a2 = new r.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.a = com.alivc.live.pusher.d.b(map, "mTotalSizeOfUploadedPackets");
            a2.b = com.alivc.live.pusher.d.b(map, "mTotalTimeOfPublishing");
            r.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
    }

    @Override
    public void resumeScreenCapture() {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PAUSED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.resumeScreenCapture();
        this.recordFunction(this.mContext, "Resume -- Sync:sync");
        u.a a2 = new u.a();
        Map<String, String> map = this.getPerformanceMap();
        if (map != null) {
            a2.a = com.alivc.live.pusher.d.b(map, "mTotalSizeOfUploadedPackets");
            a2.b = com.alivc.live.pusher.d.b(map, "mTotalTimeOfPublishing");
            a2.c = System.currentTimeMillis() - r.a;
            u.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
        this.mPushStatus = mNativeAlivcLivePusher.isPushing() ? AlivcLivePushStats.PUSHED : AlivcLivePushStats.PREVIEWED;
    }

    @Override
    public void setBeautyOn(boolean bl) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setBeautyOn beautyOn : " + bl);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.PAUSED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.setBeauty(bl, 0, 0);
        this.recordFunction(this.mContext, "SetBeautyOn -- beautyOn:" + bl);
        this.mAlivcLivePushConfig.setBeautyOn(bl);
        if (!bl) {
            i.a a2 = new i.a();
            i.a(this.mAlivcEventPublicParam, a2, this.mContext);
        } else {
            j.a a3 = new j.a();
            j.a(this.mAlivcEventPublicParam, a3, this.mContext);
        }
    }

    @Override
    public void setBeautyWhite(int n2) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setBeautyWhite white: " + n2);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mWhiten = n2;
        this.setFaceBeauty();
        this.recordFunction(this.mContext, "SetBeautyWhite -- beautyWhite:" + n2);
    }

    @Override
    public void setBeautyBuffing(int n2) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setBeautyBuffing buffing: " + n2);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mSkinSmooth = n2;
        this.setFaceBeauty();
        this.recordFunction(this.mContext, "SetBeautyBuffing -- beautyBuffing:" + n2);
    }

    private int setFaceBeauty() {
        float f2 = ((float)this.mBright + 100.0f) / 100.0f;
        float f3 = (float)this.mSkinSmooth / 100.0f;
        float f4 = (float)this.mWhiten / 100.0f;
        float f5 = (float)this.mCheekPink / 100.0f;
        float f6 = (float)this.mWholePink / 100.0f;
        float f7 = (float)this.mSlimFace / 100.0f;
        float f8 = (float)this.mShortenFace / 100.0f;
        float f9 = (float)this.mBigEye / 100.0f;
        int n2 = mNativeAlivcLivePusher.setFaceBeauty(f3, f4, f2, f5, f6, f7, f8, f9);
        this.mAlivcLivePushConfig.setBeautyCheekPink(this.mCheekPink);
        this.mAlivcLivePushConfig.setBeautyBrightness(this.mBright);
        this.mAlivcLivePushConfig.setBeautyBuffing(this.mSkinSmooth);
        this.mAlivcLivePushConfig.setBeautyRuddy(this.mWholePink);
        this.mAlivcLivePushConfig.setBeautyThinFace(this.mSlimFace);
        this.mAlivcLivePushConfig.setBeautyShortenFace(this.mShortenFace);
        this.mAlivcLivePushConfig.setBeautyBigEye(this.mBigEye);
        j.a a2 = new j.a();
        a2.f = this.mCheekPink;
        a2.b = this.mSkinSmooth;
        a2.a = this.mWhiten;
        a2.g = this.mWholePink;
        a2.c = this.mSlimFace;
        a2.e = this.mShortenFace;
        a2.d = this.mBigEye;
        j.a(this.mAlivcEventPublicParam, a2, this.mContext);
        return n2;
    }

    @Override
    public void setBeautyBrightness(int n2) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setBeautyBrightness brightness: " + n2);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mBright = n2;
        this.setFaceBeauty();
        this.recordFunction(this.mContext, "SetBeautyBrightness -- beautyBrightness:" + n2);
    }

    @Override
    public void setBeautyRuddy(int n2) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setBeautyRuddy ruddy: " + n2);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mWholePink = n2;
        this.setFaceBeauty();
        this.recordFunction(this.mContext, "SetBeautyRuddy -- beautyRuddy:" + n2);
    }

    @Override
    public void setBeautyCheekPink(int n2) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mCheekPink = n2;
        this.setFaceBeauty();
        this.recordFunction(this.mContext, "SetBeautyCheekPink -- cheekpink:" + n2);
    }

    @Override
    public void setBeautySlimFace(int n2) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mSlimFace = n2;
        this.setFaceBeauty();
        this.recordFunction(this.mContext, "SetBeautySlimFace -- slimFace:" + n2);
    }

    @Override
    public void setBeautyShortenFace(int n2) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mShortenFace = n2;
        this.setFaceBeauty();
        this.recordFunction(this.mContext, "SetBeautyShortenFace -- shortenFace:" + n2);
    }

    @Override
    public void setBeautyBigEye(int n2) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        this.mBigEye = n2;
        this.setFaceBeauty();
        this.recordFunction(this.mContext, "SetBeautyBigEye -- bigEye:" + n2);
    }

    @Override
    public void switchCamera() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->switchCamera");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        int n2 = mNativeAlivcLivePusher.switchCamera();
        this.recordFunction(this.mContext, "SwitchCamera -- Retrun:" + n2);
        if (this.mAlivcLivePushConfig.getCameraType() == AlivcLivePushCameraTypeEnum.CAMERA_TYPE_FRONT.getCameraId()) {
            this.mAlivcLivePushConfig.setCameraType(AlivcLivePushCameraTypeEnum.CAMERA_TYPE_BACK);
        } else {
            this.mAlivcLivePushConfig.setCameraType(AlivcLivePushCameraTypeEnum.CAMERA_TYPE_FRONT);
        }
        x.a a2 = new x.a();
        a2.a = this.mAlivcLivePushConfig.getCameraType() == 0 ? "back" : "front";
        x.a(this.mAlivcEventPublicParam, a2, this.mContext);
    }

    @Override
    public void setAutoFocus(boolean bl) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setAutoFocus auto: " + bl);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.setCameraFocus(bl, 0.0f, 0.0f);
        this.recordFunction(this.mContext, "SetAutoFocus -- autoFocus:" + bl);
    }

    @Override
    public void focusCameraAtAdjustedPoint(float f2, float f3, boolean bl) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->focusCameraAtAdjustedPoint x: " + f2 + " y: " + f3 + " auto: " + bl);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        int n2 = mNativeAlivcLivePusher.setCameraFocus(bl, f2, f3);
        this.recordFunction(this.mContext, "FocusCameraAtAdjustedPoint -- x:" + f2 + " y:" + f3 + " Return:" + n2);
    }

    @Override
    public void setZoom(int n2) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setZoom zoom: " + n2);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        int n3 = mNativeAlivcLivePusher.setCameraZoom(n2);
        this.recordFunction(this.mContext, "SetZoom -- zoom:" + n2 + " Return:" + n3);
    }

    @Override
    public int getMaxZoom() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->getMaxZoom");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.getCameraMaxZoom();
        }
        return 0;
    }

    @Override
    public int getCurrentZoom() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->getCurrentZoom");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.getCameraCurrentZoom();
        }
        return 0;
    }

    @Override
    public void setMute(boolean bl) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setMute mute: " + bl);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.PAUSED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.setMute(bl);
        this.mMute = bl;
        if (bl) {
            q.a a2 = new q.a();
            q.a(this.mAlivcEventPublicParam, a2, this.mContext);
        } else {
            p.a a3 = new p.a();
            p.a(this.mAlivcEventPublicParam, a3, this.mContext);
        }
        this.recordFunction(this.mContext, "SetMute -- mute:" + bl);
    }

    @Override
    public void setFlash(boolean bl) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setFlash flash: " + bl);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.setFlash(bl);
        this.mAlivcLivePushConfig.setFlash(bl);
        if (bl) {
            n.a a2 = new n.a();
            n.a(this.mAlivcEventPublicParam, a2, this.mContext);
        } else {
            m.a a3 = new m.a();
            m.a(this.mAlivcEventPublicParam, a3, this.mContext);
        }
        this.recordFunction(this.mContext, "SetFlash -- flash:" + bl);
    }

    @Override
    public void setPushMirror(boolean bl) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setPushMirror pushMirror: " + bl);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.setPusherMirror(bl);
        this.recordFunction(this.mContext, "SetPushMirror -- mirror:" + bl);
    }

    @Override
    public void setPreviewMirror(boolean bl) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setPreviewMirror previewMirror: " + bl);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.setPreviewMirror(bl);
        this.recordFunction(this.mContext, "SetPreviewMirror -- mirror:" + bl);
    }

    @Override
    public void setTargetVideoBitrate(int n2) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setTargetVideoBitrate targetVideoBitrate: " + n2);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.setVideoBitrateRange(0, n2, n2);
        this.recordFunction(this.mContext, "SetTargetVideoBitrate -- targetVideoBitrate:" + n2);
    }

    @Override
    public void setMinVideoBitrate(int n2) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setMinVideoBitrate minVideoBitrate: " + n2);
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        mNativeAlivcLivePusher.setVideoBitrateRange(n2, 0, 0);
        this.recordFunction(this.mContext, "SetMinVideoBitrate -- minVideoBitrate:" + n2);
    }

    @Override
    public boolean isCameraSupportAutoFocus() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->isCameraSupportAutoFocus");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        return mNativeAlivcLivePusher.isCameraSupportAutoFocus();
    }

    @Override
    public boolean isCameraSupportFlash() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->isCameraSupportFlash");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        return mNativeAlivcLivePusher.isCameraSupportFlash();
    }

    @Override
    public boolean isPushing() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->isPushing");
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.isPushing();
        }
        return false;
    }

    @Override
    public AlivcLivePushStats getCurrentStatus() {
        return this.mPushStatus;
    }

    @Override
    public AlivcLivePushError getLastError() {
        return this.mLastError;
    }

    private void snapshot(int n2, int n3, AlivcSnapshotListener alivcSnapshotListener) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.snapshot(n2, n3, alivcSnapshotListener);
        }
    }

    @Override
    public boolean isNetworkPushing() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->isNetworkPushing");
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.isNetworkPushing();
        }
        return false;
    }

    @Override
    public void setLivePushErrorListener(AlivcLivePushErrorListener alivcLivePushErrorListener) {
        this.mPushErrorListener = alivcLivePushErrorListener;
    }

    @Override
    public void setLivePushInfoListener(AlivcLivePushInfoListener alivcLivePushInfoListener) {
        this.mPushInfoListener = alivcLivePushInfoListener;
    }

    @Override
    public void setLivePushNetworkListener(AlivcLivePushNetworkListener alivcLivePushNetworkListener) {
        this.mPushNetworkListener = alivcLivePushNetworkListener;
    }

    @Override
    public void setLivePushBGMListener(AlivcLivePushBGMListener alivcLivePushBGMListener) {
        this.mPushBGMListener = alivcLivePushBGMListener;
    }

    @Override
    public void setLivePushRenderContextListener(AlivcLivePusherRenderContextListener alivcLivePusherRenderContextListener) {
        this.mRenderContextListener = alivcLivePusherRenderContextListener;
    }

    public static String getSDKVersion() {
        return "3.3.7";
    }

    @Override
    public AlivcLivePushStatsInfo getLivePushStatsInfo() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->getLivePushStatsInfo");
        if (mNativeAlivcLivePusher == null) {
            return null;
        }
        AlivcLivePushStatsInfo alivcLivePushStatsInfo = new AlivcLivePushStatsInfo();
        String string = mNativeAlivcLivePusher.getPerformanceInfo();
        if (string == null || "".equals(string)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            hashMap.put(stringTokenizer2.nextToken(), stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null);
        }
        try {
            alivcLivePushStatsInfo.setCpu(com.alivc.live.pusher.d.a());
            alivcLivePushStatsInfo.setMemory(com.alivc.live.pusher.d.a(this.mContext));
            alivcLivePushStatsInfo.setVideoCaptureFps(com.alivc.live.pusher.d.a(hashMap, "mVideoCaptureFps"));
            alivcLivePushStatsInfo.setAudioEncodeBitrate(com.alivc.live.pusher.d.a(hashMap, "mAudioEncodeBitrate"));
            alivcLivePushStatsInfo.setVideoRenderFps(com.alivc.live.pusher.d.a(hashMap, "mVideoRenderingFPS"));
            alivcLivePushStatsInfo.setAudioEncodeFps(com.alivc.live.pusher.d.a(hashMap, "mAudioEncodeFps"));
            alivcLivePushStatsInfo.setVideoEncodeMode(AlivcEncodeModeEnum.values()[com.alivc.live.pusher.d.a(hashMap, "mPresetVideoEncoderMode")]);
            alivcLivePushStatsInfo.setVideoEncodeBitrate(com.alivc.live.pusher.d.a(hashMap, "mVideoEncodeBitrate"));
            alivcLivePushStatsInfo.setVideoEncodeFps(com.alivc.live.pusher.d.a(hashMap, "mVideoEncodedFps"));
            alivcLivePushStatsInfo.setTotalFramesOfEncodedVideo(com.alivc.live.pusher.d.b(hashMap, "mTotalFramesOfEncodedVideo"));
            alivcLivePushStatsInfo.setTotalTimeOfEncodedVideo(com.alivc.live.pusher.d.b(hashMap, "mTotalTimeOfEncodedVideo"));
            alivcLivePushStatsInfo.setVideoEncodeParam(com.alivc.live.pusher.d.a(hashMap, "mPresetVideoEncoderBitrate"));
            alivcLivePushStatsInfo.setAudioUploadBitrate(com.alivc.live.pusher.d.a(hashMap, "mAudioUploadBitrate"));
            alivcLivePushStatsInfo.setVideoUploadBitrate(com.alivc.live.pusher.d.a(hashMap, "mVideoUploadBitrate"));
            alivcLivePushStatsInfo.setAudioPacketsInUploadBuffer(com.alivc.live.pusher.d.a(hashMap, "mAudioPacketsInBuffer"));
            alivcLivePushStatsInfo.setVideoPacketsInUploadBuffer(com.alivc.live.pusher.d.a(hashMap, "mVideoPacketsInBuffer"));
            alivcLivePushStatsInfo.setVideoUploadeFps(com.alivc.live.pusher.d.a(hashMap, "mVideoUploadedFps"));
            alivcLivePushStatsInfo.setAudioUploadFps(com.alivc.live.pusher.d.a(hashMap, "mAudioUploadingPacketsPerSecond"));
            alivcLivePushStatsInfo.setCurrentlyUploadedVideoFramePts(com.alivc.live.pusher.d.b(hashMap, "mCurrentlyUploadedVideoFramePts"));
            alivcLivePushStatsInfo.setCurrentlyUploadedAudioFramePts(com.alivc.live.pusher.d.b(hashMap, "mCurrentlyUploadedAudioFramePts"));
            alivcLivePushStatsInfo.setPreviousVideoKeyFramePts(com.alivc.live.pusher.d.b(hashMap, "mPreviousKeyFramePts"));
            alivcLivePushStatsInfo.setLastVideoPtsInBuffer(com.alivc.live.pusher.d.b(hashMap, "mLastVideoFramePTSInQueue"));
            alivcLivePushStatsInfo.setLastAudioPtsInBuffer(com.alivc.live.pusher.d.b(hashMap, "mLastAudioFramePTSInQueue"));
            alivcLivePushStatsInfo.setTotalSizeOfUploadedPackets(com.alivc.live.pusher.d.b(hashMap, "mTotalSizeOfUploadedPackets"));
            alivcLivePushStatsInfo.setTotalTimeOfUploading(com.alivc.live.pusher.d.b(hashMap, "mTotalTimeOfPublishing"));
            alivcLivePushStatsInfo.setTotalFramesOfUploadedVideo(com.alivc.live.pusher.d.b(hashMap, "mTotalFramesOfVideoUploaded"));
            alivcLivePushStatsInfo.setTotalDurationOfDropingVideoFrames(com.alivc.live.pusher.d.b(hashMap, "mDropDurationOfVideoFrames"));
            alivcLivePushStatsInfo.setTotalTimesOfDropingVideoFrames(com.alivc.live.pusher.d.b(hashMap, "mTotalDroppedTimes"));
            alivcLivePushStatsInfo.setTotalTimesOfDisconnect(com.alivc.live.pusher.d.a(hashMap, "mTotalNetworkDisconnectedTimes"));
            alivcLivePushStatsInfo.setTotalTimesOfReconnect(com.alivc.live.pusher.d.a(hashMap, "mTotalNetworkReconnectedTimes"));
            alivcLivePushStatsInfo.setVideoDurationFromeCaptureToUpload(com.alivc.live.pusher.d.a(hashMap, "mVideoDurationFromeCaptureToUpload"));
            alivcLivePushStatsInfo.setAudioDurationFromeCaptureToUpload(com.alivc.live.pusher.d.a(hashMap, "mAudioDurationFromeCaptureToUpload"));
            alivcLivePushStatsInfo.setCurrentUploadPacketSize(com.alivc.live.pusher.d.a(hashMap, "mCurrentUploadingPacketSize"));
            alivcLivePushStatsInfo.setMaxSizeOfVideoPacketsInBuffer(com.alivc.live.pusher.d.a(hashMap, "mMaxVideoPacketSize"));
            alivcLivePushStatsInfo.setMaxSizeOfAudioPacketsInBuffer(com.alivc.live.pusher.d.a(hashMap, "mMaxAudioPacketSize"));
            alivcLivePushStatsInfo.setLastVideoFramePTSInQueue(com.alivc.live.pusher.d.b(hashMap, "mLastVideoFramePTSInQueue"));
            alivcLivePushStatsInfo.setLastAudioFramePTSInQueue(com.alivc.live.pusher.d.b(hashMap, "mLastAudioFramePTSInQueue"));
            alivcLivePushStatsInfo.setAvPTSInterval(com.alivc.live.pusher.d.b(hashMap, "mAvPTSInterval"));
            alivcLivePushStatsInfo.setAudioFrameInEncodeBuffer(com.alivc.live.pusher.d.a(hashMap, "mAudioFramesInEncoderQueue"));
            alivcLivePushStatsInfo.setVideoFramesInEncodeBuffer(com.alivc.live.pusher.d.a(hashMap, "mVideoFramesInEncoderQueue"));
            alivcLivePushStatsInfo.setVideoFramesInRenderBuffer(com.alivc.live.pusher.d.a(hashMap, "mVideoFramesInRenderQueue"));
            alivcLivePushStatsInfo.setVideoRenderConsumingTimePerFrame(com.alivc.live.pusher.d.a(hashMap, "mVideoRenderConsumingTimePerFrame"));
            alivcLivePushStatsInfo.setTotalDroppedAudioFrames(com.alivc.live.pusher.d.a(hashMap, "mTotalDroppedAudioFrames"));
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return alivcLivePushStatsInfo;
    }

    @Override
    public String getPushUrl() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->getPushUrl");
        return mPushUrl;
    }

    private void checkConfig(AlivcLivePushConfig alivcLivePushConfig) {
        if (alivcLivePushConfig == null) {
            throw new IllegalArgumentException("Invalid parameter, config is null.");
        }
        if (alivcLivePushConfig.isVideoOnly() && alivcLivePushConfig.isAudioOnly()) {
            throw new IllegalStateException("cannot set video only and audio only simultaneously");
        }
        if (alivcLivePushConfig.getTargetVideoBitrate() < 100 || alivcLivePushConfig.getTargetVideoBitrate() > 5000) {
            throw new IllegalStateException("video target bitrate error, Range:[100 5000]");
        }
        if (alivcLivePushConfig.getMinVideoBitrate() < 100 || alivcLivePushConfig.getMinVideoBitrate() > 5000) {
            throw new IllegalStateException("video min bitrate error, Range:[100 5000]");
        }
        if (alivcLivePushConfig.getBeautyWhite() < 0 || alivcLivePushConfig.getBeautyWhite() > 100) {
            throw new IllegalStateException("beautyWhite error, Range:[0 100]");
        }
        if (alivcLivePushConfig.getBeautyBuffing() < 0 || alivcLivePushConfig.getBeautyBuffing() > 100) {
            throw new IllegalStateException("beauty buffing error, Range:[0 100]");
        }
        if (alivcLivePushConfig.getInitialVideoBitrate() < alivcLivePushConfig.getMinVideoBitrate() || alivcLivePushConfig.getInitialVideoBitrate() < 100 || alivcLivePushConfig.getInitialVideoBitrate() > 5000) {
            throw new IllegalStateException("init bitrate error");
        }
        if (alivcLivePushConfig.getConnectRetryCount() <= 0 || alivcLivePushConfig.getConnectRetryCount() > 100) {
            throw new IllegalStateException("connect retry count error, Range:[0 100]");
        }
        if (alivcLivePushConfig.getConnectRetryInterval() <= 0 || alivcLivePushConfig.getConnectRetryInterval() > 10000) {
            throw new IllegalStateException("connect retry interval error, Range:[0 10000]");
        }
        if (alivcLivePushConfig.getMinFps() <= 0 || alivcLivePushConfig.getMinFps() > alivcLivePushConfig.getFps()) {
            throw new IllegalStateException("fps error");
        }
        if (alivcLivePushConfig.getVideoEncodeMode() == AlivcEncodeModeEnum.Encode_MODE_SOFT && alivcLivePushConfig.getResolution().ordinal() >= AlivcResolutionEnum.RESOLUTION_720P.ordinal()) {
            throw new IllegalStateException("Soft encode 720P not support");
        }
        for (int i2 = 0; i2 < alivcLivePushConfig.getWaterMarkInfos().size(); ++i2) {
            if (alivcLivePushConfig.getWaterMarkInfos().get((int)i2).mWaterMarkCoordX > 1.0f || alivcLivePushConfig.getWaterMarkInfos().get((int)i2).mWaterMarkWidth > 1.0f || alivcLivePushConfig.getWaterMarkInfos().get((int)i2).mWaterMarkCoordY > 1.0f || alivcLivePushConfig.getWaterMarkInfos().get((int)i2).mWaterMarkHeight > 1.0f) {
                throw new IllegalStateException("watermark param error");
            }
            if (!(alivcLivePushConfig.getWaterMarkInfos().get((int)i2).mWaterMarkCoordX < 0.0f || alivcLivePushConfig.getWaterMarkInfos().get((int)i2).mWaterMarkWidth <= 0.0f || alivcLivePushConfig.getWaterMarkInfos().get((int)i2).mWaterMarkCoordY < 0.0f) && !(alivcLivePushConfig.getWaterMarkInfos().get((int)i2).mWaterMarkHeight <= 0.0f)) continue;
            throw new IllegalStateException("watermark param error");
        }
    }

    protected int onNotification(int n2, int n3, int n4) {
        return 0;
    }

    @Override
    public void setPreviewOrientation(AlivcPreviewOrientationEnum alivcPreviewOrientationEnum) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setPreviewOrientation");
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.PUSHED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setOrientaion(alivcPreviewOrientationEnum.getOrientation());
            this.recordFunction(this.mContext, "SetPreviewOrientation -- orientation:" + alivcPreviewOrientationEnum.getOrientation());
        }
    }

    private Map<String, String> getPerformanceMap() {
        if (mNativeAlivcLivePusher == null) {
            return null;
        }
        String string = mNativeAlivcLivePusher.getPerformanceInfo();
        if (string == null || "".equals(string)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            hashMap.put(stringTokenizer2.nextToken(), stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null);
        }
        return hashMap;
    }

    @Override
    public void setLogLevel(AlivcLivePushLogLevel alivcLivePushLogLevel) {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->setLogLevel");
        if (mNativeAlivcLivePusher != null) {
            if (alivcLivePushLogLevel.getLevel() > AlivcLivePushLogLevel.AlivcLivePushLogLevelWarn.getLevel()) {
                LogUtil.disableDebug();
            } else {
                LogUtil.enalbeDebug();
            }
            mNativeAlivcLivePusher.setLogLevel(alivcLivePushLogLevel.getLevel());
            this.recordFunction(this.mContext, "setLogLevel -- level:" + alivcLivePushLogLevel.getLevel());
        }
    }

    public void sendMessage(String string, int n2, int n3, boolean bl) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalArgumentException("Invalid parameter");
        }
        if (!mNativeAlivcLivePusher.isPushing()) {
            throw new IllegalStateException("Status error, status should be PUSHED");
        }
        if (!string.isEmpty() && string.length() > 4000) {
            throw new IllegalArgumentException("The maximum length is 4000");
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.addSeiInfo(string, n2, n3, bl);
        }
    }

    private int getBGMVolume() {
        if (this.mMute) {
            return 0;
        }
        return this.mBGMVolume;
    }

    private int getCaptureVolume() {
        if (this.mMute) {
            return 0;
        }
        return this.mCaptureVolume;
    }

    private boolean getHeadSetPlugOn() {
        return LivePusherJNI.headSetOn;
    }

    private boolean getBlueToothHeadSetOn() {
        if (this.mBluetoothHelper != null) {
            return this.mBluetoothHelper.b();
        }
        return false;
    }

    @Override
    public void startBGMAsync(String string) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Invalid parameter");
        }
        if (this.mPushStatus == AlivcLivePushStats.IDLE || this.mPushStatus == AlivcLivePushStats.ERROR) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        if (this.mPlayStats == AlivcLivePlayStats.IDLE || this.mPlayStats == AlivcLivePlayStats.STOPED) {
            h.a a2 = new h.a();
            a2.b = this.getBGMVolume();
            a2.a = this.getCaptureVolume();
            h.a(this.mAlivcEventPublicParam, a2, this.mContext);
        }
        mNativeAlivcLivePusher.resumeBGM();
        mNativeAlivcLivePusher.stopBGM();
        mNativeAlivcLivePusher.startBGMAsync(string);
        this.recordFunction(this.mContext, "StartBGMAsync -- path:" + string);
    }

    @Override
    public void stopBGMAsync() {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Invalid parameter");
        }
        if (this.mPlayStats == AlivcLivePlayStats.IDLE) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePlayStats.values()[this.mPlayStats.ordinal()]));
        }
        mNativeAlivcLivePusher.stopBGM();
        this.recordFunction(this.mContext, "StopBGM -- Sync:Async");
        g.a a2 = new g.a();
        a2.b = this.getBGMVolume();
        a2.a = this.getCaptureVolume();
        g.a(this.mAlivcEventPublicParam, a2, this.mContext);
    }

    @Override
    public void pauseBGM() {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Invalid parameter");
        }
        if (this.mPlayStats != AlivcLivePlayStats.STARTED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePlayStats.values()[this.mPlayStats.ordinal()]));
        }
        mNativeAlivcLivePusher.pauseBGM();
        this.recordFunction(this.mContext, "PauseBGM");
    }

    @Override
    public void resumeBGM() {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Invalid parameter");
        }
        if (this.mPlayStats != AlivcLivePlayStats.PAUSED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePlayStats.values()[this.mPlayStats.ordinal()]));
        }
        mNativeAlivcLivePusher.resumeBGM();
        this.recordFunction(this.mContext, "ResumeBGM");
    }

    @Override
    public void setBGMLoop(boolean bl) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setBGMLoop(bl);
        }
        if (!bl) {
            e.a a2 = new e.a();
            e.a(this.mAlivcEventPublicParam, a2, this.mContext);
        } else {
            f.a a3 = new f.a();
            f.a(this.mAlivcEventPublicParam, a3, this.mContext);
        }
        this.recordFunction(this.mContext, "SetBGMLoop -- isLoop:" + bl);
    }

    @Override
    public void setBGMEarsBack(boolean bl) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setEarsBack(bl);
        }
        if (!bl) {
            c.a a2 = new c.a();
            a2.b = this.getBlueToothHeadSetOn() ? 1 : 0;
            a2.a = this.getHeadSetPlugOn() ? 1 : 0;
            c.a(this.mAlivcEventPublicParam, a2, this.mContext);
        } else {
            d.a a3 = new d.a();
            a3.b = this.getBlueToothHeadSetOn() ? 1 : 0;
            a3.a = this.getHeadSetPlugOn() ? 1 : 0;
            d.a(this.mAlivcEventPublicParam, a3, this.mContext);
        }
        this.recordFunction(this.mContext, "SetBGMEarsBack -- isOpen:" + bl);
    }

    @Override
    public void setBGMVolume(int n2) {
        if (mNativeAlivcLivePusher != null) {
            this.mBGMVolume = n2;
            if (n2 > 0 && n2 < 10) {
                n2 = 10;
            }
            mNativeAlivcLivePusher.setBackgroundMusicVolume(n2 / 10);
            this.recordFunction(this.mContext, "SetBGMVolume -- volume:" + n2);
        }
    }

    @Override
    public void setCaptureVolume(int n2) {
        if (mNativeAlivcLivePusher != null) {
            this.mCaptureVolume = n2;
            if (n2 > 0 && n2 < 10) {
                n2 = 10;
            }
            mNativeAlivcLivePusher.setAudioVolume(n2 / 10);
            this.recordFunction(this.mContext, "SetCaptureVolume -- volume:" + n2);
        }
    }

    @Override
    public void setAudioDenoise(boolean bl) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setAudioDenoise(bl);
            this.recordFunction(this.mContext, "SetAudioDenoise -- on:" + bl);
        }
    }

    @Override
    public void setQualityMode(AlivcQualityModeEnum alivcQualityModeEnum) {
        if (alivcQualityModeEnum.equals((Object)AlivcQualityModeEnum.QM_CUSTOM)) {
            throw new IllegalStateException("Cannot set QM_CUSTOM dynamically");
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setQualityMode(alivcQualityModeEnum.getQualityMode());
            this.recordFunction(this.mContext, "SetQualityMode -- mode:" + alivcQualityModeEnum.ordinal());
        }
    }

    @Override
    public void setPreviewMode(AlivcPreviewDisplayMode alivcPreviewDisplayMode) {
        if (mNativeAlivcLivePusher != null && this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() == null) {
            mNativeAlivcLivePusher.setDisplayMode(alivcPreviewDisplayMode.getPreviewDisplayMode());
            this.recordFunction(this.mContext, "SetQualityMode -- mode:" + alivcPreviewDisplayMode.ordinal());
        }
    }

    private void start5Interval() {
        if (this.executor5 != null) {
            return;
        }
        if (this.executor5 == null || this.executor5.isShutdown()) {
            this.executor5 = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
                private AtomicInteger atoInteger = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable);
                    thread.setName("LivePusher-report-Thread " + this.atoInteger.getAndIncrement());
                    return thread;
                }
            });
        }
        this.executor5.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Object object;
                if (AlivcLivePusher.this.mTimeStamp != -1L) {
                    if (AlivcLivePusher.this.mExpiryTime < 60) {
                        if (AlivcLivePusher.this.mPushNetworkListener != null) {
                            object = AlivcLivePusher.this.mPushNetworkListener.onPushURLAuthenticationOverdue(AlivcLivePusher.this);
                            if (object != null && !((String)object).isEmpty()) {
                                AlivcLivePusher.this.reconnectPushAsync((String)object);
                            }
                            LogUtil.d("AlivcLivePusher", "auth expiry time " + AlivcLivePusher.this.mExpiryTime);
                        }
                    } else {
                        AlivcLivePusher.this.mExpiryTime = AlivcLivePusher.this.mExpiryTime - 5;
                    }
                }
                object = AlivcLivePusher.this.getPerformanceMap();
                o.a a2 = new o.a();
                a2.a = com.alivc.live.pusher.d.b((Map<String, String>)object, "mTotalSizeOfUploadedPackets");
                a2.b = com.alivc.live.pusher.d.b((Map<String, String>)object, "mTotalTimeOfPublishing");
                a2.c = com.alivc.live.pusher.d.a();
                a2.d = com.alivc.live.pusher.d.a(AlivcLivePusher.this.mContext);
                a2.e = com.alivc.live.pusher.d.a((Map<String, String>)object, "mVideoFramesInRenderQueue");
                a2.f = com.alivc.live.pusher.d.a((Map<String, String>)object, "mVideoFramesInEncoderQueue");
                a2.g = com.alivc.live.pusher.d.a((Map<String, String>)object, "mVideoPacketsInBuffer");
                a2.h = com.alivc.live.pusher.d.a((Map<String, String>)object, "mAudioFramesInEncoderQueue");
                a2.i = com.alivc.live.pusher.d.a((Map<String, String>)object, "mAudioPacketsInBuffer");
                a2.j = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAvPTSInterval");
                a2.k = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoEncodedFps");
                a2.l = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoUploadedFps");
                a2.m = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoCaptureFps");
                a2.n = com.alivc.live.pusher.d.b((Map<String, String>)object, "mTotalFramesOfVideoUploaded");
                a2.o = com.alivc.live.pusher.d.b((Map<String, String>)object, "mDropDurationOfVideoFrames");
                a2.p = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioPacketsInBuffer");
                a2.q = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoPacketsInBuffer");
                a2.r = com.alivc.live.pusher.d.a((Map<String, String>)object, "mAudioUploadingPacketsPerSecond");
                a2.s = com.alivc.live.pusher.d.a((Map<String, String>)object, "mTotalDroppedAudioFrames");
                a2.t = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioEncodeBitrate");
                a2.u = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoEncodeBitrate");
                a2.v = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioUploadBitrate");
                a2.w = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoUploadBitrate");
                a2.x = com.alivc.live.pusher.d.b((Map<String, String>)object, "mPresetVideoEncoderBitrate");
                a2.y = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioDurationFromeCaptureToUpload");
                a2.z = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoDurationFromeCaptureToUpload");
                a2.G = com.alivc.live.pusher.d.b((Map<String, String>)object, "mCurrentlyUploadedVideoFramePts");
                a2.H = com.alivc.live.pusher.d.b((Map<String, String>)object, "mCurrentlyUploadedAudioFramePts");
                a2.I = com.alivc.live.pusher.d.b((Map<String, String>)object, "mPreviousKeyFramePts");
                a2.J = com.alivc.live.pusher.d.b((Map<String, String>)object, "mPreviousKeyFramePts");
                a2.A = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoCapturePts");
                a2.B = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioCapturePts");
                a2.C = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoRtmpPts");
                a2.D = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioRtmpPts");
                a2.E = com.alivc.live.pusher.d.b((Map<String, String>)object, "mVideoRtmpPushPts");
                a2.F = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioRtmpPushPts");
                a2.K = com.alivc.live.pusher.d.a((Map<String, String>)object, "mIsMultiSlice");
                a2.L = com.alivc.live.pusher.d.a((Map<String, String>)object, "mLatestVideoBitrate");
                a2.M = com.alivc.live.pusher.d.a((Map<String, String>)object, "mLatestAudioBitrate");
                a2.N = com.alivc.live.pusher.d.a((Map<String, String>)object, "mSocketBufferSize");
                a2.O = com.alivc.live.pusher.d.a((Map<String, String>)object, "mSocketSendTime");
                a2.P = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioRecvSize");
                a2.Q = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioSendSize");
                a2.R = com.alivc.live.pusher.d.b((Map<String, String>)object, "mAudioSrcSendSize");
                a2.S = com.alivc.live.pusher.d.b((Map<String, String>)object, "getAllPastTime");
                o.a(AlivcLivePusher.this.mAlivcEventPublicParam, a2, AlivcLivePusher.this.mContext);
            }
        }, 0L, 5000L, TimeUnit.MILLISECONDS);
    }

    private int[] getImageWidthHeight(String string) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        try {
            Bitmap bitmap = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        }
        catch (Exception exception) {
            return new int[]{0, 0};
        }
        return new int[]{options.outWidth, options.outHeight};
    }

    private void addWaterMark() {
        ArrayList<WaterMarkInfo> arrayList = this.mAlivcLivePushConfig.getWaterMarkInfos();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            float f2;
            float f3;
            int[] nArray = this.getImageWidthHeight(arrayList.get((int)i2).mWaterMarkPath);
            if (nArray == null || nArray[0] == 0 || nArray[1] == 0) continue;
            if (this.mAlivcLivePushConfig.getPreviewOrientation() == AlivcPreviewOrientationEnum.ORIENTATION_LANDSCAPE_HOME_LEFT.getOrientation() || this.mAlivcLivePushConfig.getPreviewOrientation() == AlivcPreviewOrientationEnum.ORIENTATION_LANDSCAPE_HOME_RIGHT.getOrientation()) {
                f3 = arrayList.get((int)i2).mWaterMarkWidth;
                f2 = arrayList.get((int)i2).mWaterMarkWidth * (float)nArray[1] / (float)nArray[0];
                f2 = f2 * (float)this.mAlivcLivePushConfig.getHeight() / (float)this.mAlivcLivePushConfig.getWidth();
                mNativeAlivcLivePusher.addWaterMark(arrayList.get((int)i2).mWaterMarkPath, f3, f2, arrayList.get((int)i2).mWaterMarkCoordX + arrayList.get((int)i2).mWaterMarkWidth / 2.0f, arrayList.get((int)i2).mWaterMarkCoordY + arrayList.get((int)i2).mWaterMarkHeight / 2.0f);
                continue;
            }
            f3 = arrayList.get((int)i2).mWaterMarkWidth;
            f2 = arrayList.get((int)i2).mWaterMarkWidth * (float)nArray[1] / (float)nArray[0];
            f2 = f2 * (float)this.mAlivcLivePushConfig.getWidth() / (float)this.mAlivcLivePushConfig.getHeight();
            mNativeAlivcLivePusher.addWaterMark(arrayList.get((int)i2).mWaterMarkPath, f3, f2, arrayList.get((int)i2).mWaterMarkCoordX + arrayList.get((int)i2).mWaterMarkWidth / 2.0f, arrayList.get((int)i2).mWaterMarkCoordY + arrayList.get((int)i2).mWaterMarkHeight / 2.0f);
        }
    }

    private void stop5Interval() {
        if (this.executor5 != null && !this.executor5.isShutdown()) {
            this.executor5.shutdown();
        }
        this.executor5 = null;
    }

    private void registerHeadsetPlugReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        this.mContext.registerReceiver(this.mHeadsetPlugReceiver, intentFilter);
        IntentFilter intentFilter2 = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
        this.mContext.registerReceiver(this.mHeadsetPlugReceiver, intentFilter2);
        IntentFilter intentFilter3 = new IntentFilter();
        intentFilter3.addAction("android.intent.action.PHONE_STATE");
        this.mContext.registerReceiver(this.mTelephoneReceiver, intentFilter3);
        this.registeredCallback = true;
    }

    public void setCustomFilter(AlivcLivePushCustomFilter alivcLivePushCustomFilter) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setCustomFilter(alivcLivePushCustomFilter);
        }
    }

    public static void showDebugView(Context context) {
        isDebugView = true;
        try {
            DebugViewManager.showView(context);
            DebugViewManager.setUpdateDebigListener(new DebugViewManager.UpdateDebugInfo(){

                @Override
                public AlivcLivePushDebugInfo updateInfo() {
                    return AlivcLivePusher.getDebugInfo();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static AlivcLivePushDebugInfo getDebugInfo() {
        LogUtil.d("AlivcLivePusher", "AlivcLivePusher-->getLivePushStatsInfo");
        AlivcLivePushDebugInfo alivcLivePushDebugInfo = new AlivcLivePushDebugInfo();
        if (mNativeAlivcLivePusher == null) {
            return alivcLivePushDebugInfo;
        }
        String string = mNativeAlivcLivePusher.getPerformanceInfo();
        if (string == null || "".equals(string)) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
            hashMap.put(stringTokenizer2.nextToken(), stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : null);
        }
        try {
            alivcLivePushDebugInfo.setCpu(com.alivc.live.pusher.d.a());
            alivcLivePushDebugInfo.setRes(AlivcResolutionEnum.values()[res.ordinal()].toString());
            alivcLivePushDebugInfo.setUrl(mPushUrl);
            alivcLivePushDebugInfo.setPush(mNativeAlivcLivePusher == null ? false : mNativeAlivcLivePusher.isPushing());
            alivcLivePushDebugInfo.setVideoCaptureFps(com.alivc.live.pusher.d.a(hashMap, "mVideoCaptureFps"));
            alivcLivePushDebugInfo.setVideoRenderFps(com.alivc.live.pusher.d.a(hashMap, "mVideoRenderingFPS"));
            alivcLivePushDebugInfo.setVideoEncodeFps(com.alivc.live.pusher.d.a(hashMap, "mVideoEncodedFps"));
            alivcLivePushDebugInfo.setAudioUploadBitrate(com.alivc.live.pusher.d.a(hashMap, "mAudioUploadBitrate"));
            alivcLivePushDebugInfo.setVideoUploadBitrate(com.alivc.live.pusher.d.a(hashMap, "mVideoUploadBitrate"));
            alivcLivePushDebugInfo.setAudioPacketsInUploadBuffer(com.alivc.live.pusher.d.a(hashMap, "mAudioPacketsInBuffer"));
            alivcLivePushDebugInfo.setVideoPacketsInUploadBuffer(com.alivc.live.pusher.d.a(hashMap, "mVideoPacketsInBuffer"));
            alivcLivePushDebugInfo.setVideoUploadeFps(com.alivc.live.pusher.d.a(hashMap, "mVideoUploadedFps"));
            alivcLivePushDebugInfo.setTotalDurationOfDropingVideoFrames(com.alivc.live.pusher.d.b(hashMap, "mDropDurationOfVideoFrames"));
            alivcLivePushDebugInfo.setAudioFrameInEncodeBuffer(com.alivc.live.pusher.d.a(hashMap, "mAudioFramesInEncoderQueue"));
            alivcLivePushDebugInfo.setVideoFramesInEncodeBuffer(com.alivc.live.pusher.d.a(hashMap, "mVideoFramesInEncoderQueue"));
            alivcLivePushDebugInfo.setVideoFramesInRenderBuffer(com.alivc.live.pusher.d.a(hashMap, "mVideoFramesInRenderQueue"));
            alivcLivePushDebugInfo.setTotalDroppedAudioFrames(com.alivc.live.pusher.d.a(hashMap, "mTotalDroppedAudioFrames"));
            alivcLivePushDebugInfo.setLatestVideoBitrate(com.alivc.live.pusher.d.a(hashMap, "mLatestVideoBitrate"));
            alivcLivePushDebugInfo.setLatestAudioBitrate(com.alivc.live.pusher.d.a(hashMap, "mLatestAudioBitrate"));
            alivcLivePushDebugInfo.setSocketBufferSize(com.alivc.live.pusher.d.a(hashMap, "mSocketBufferSize"));
            alivcLivePushDebugInfo.setSocketSendTime(com.alivc.live.pusher.d.a(hashMap, "mSocketSendTime"));
            alivcLivePushDebugInfo.setCurrentlyUploadedVideoFramePts(com.alivc.live.pusher.d.b(hashMap, "mCurrentlyUploadedVideoFramePts"));
            alivcLivePushDebugInfo.setCurrentlyUploadedAudioFramePts(com.alivc.live.pusher.d.b(hashMap, "mCurrentlyUploadedAudioFramePts"));
            alivcLivePushDebugInfo.setAudioEncodeFps(com.alivc.live.pusher.d.a(hashMap, "mAudioEncodeFps"));
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return alivcLivePushDebugInfo;
    }

    public void hideDebugView(Context context) {
        isDebugView = false;
        try {
            DebugViewManager.hideDebugView(context);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void recordFunction(Context context, String string) {
        if (isDebugView) {
            string = "AlivcLivePusher " + string;
            Thread thread = Thread.currentThread();
            DebugViewManager.recordFunction(String.format(this.mDebugFunctionText, com.alivc.live.pusher.d.b(), String.valueOf(thread.getId())) + string);
        }
    }

    public void setCustomDetect(AlivcLivePushCustomDetect alivcLivePushCustomDetect) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setCustomDetect(alivcLivePushCustomDetect);
            Thread thread = Thread.currentThread();
            DebugViewManager.recordFunction(String.format(this.mDebugFunctionText, com.alivc.live.pusher.d.b(), String.valueOf(thread.getId())));
        }
    }

    private void getNetworkTime() {
        new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
            private AtomicInteger atoInteger = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName("LivePusher-NTP-Time-Thread " + this.atoInteger.getAndIncrement());
                return thread;
            }
        }).execute(new Runnable(){

            @Override
            public void run() {
                for (int i2 = 0; i2 < 3; ++i2) {
                    AlivcLivePusher.this.mTimeStamp = AlivcLivePusher.this.getTimeFromNtpServer("time.pool.aliyun.com");
                    if (AlivcLivePusher.this.mTimeStamp <= 0L) continue;
                    AlivcLivePusher.this.mTimeStamp = AlivcLivePusher.this.mTimeStamp / 1000L;
                    break;
                }
                if (AlivcLivePusher.this.mTimeStamp < 0L) {
                    AlivcLivePusher.this.mTimeStamp = System.currentTimeMillis() / 1000L;
                }
                if (AlivcLivePusher.this.getTimestamp(mPushUrl) != -1) {
                    AlivcLivePusher.this.mExpiryTime = (int)((long)AlivcLivePusher.this.getTimestamp(mPushUrl) - AlivcLivePusher.this.mTimeStamp);
                }
            }
        });
    }

    private long getTimeFromNtpServer(String string) {
        LogUtil.d("", "get time from " + string);
        com.alivc.live.pusher.e e2 = new com.alivc.live.pusher.e();
        boolean bl = e2.a(string, 1000);
        if (bl) {
            return e2.a();
        }
        return -1L;
    }

    @Override
    public void setWaterMarkVisible(boolean bl) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Illegal State, you should init first");
        }
        if (this.mPushStatus != AlivcLivePushStats.PREVIEWED) {
            throw new IllegalStateException("status error current state is " + (Object)((Object)AlivcLivePushStats.values()[this.mPushStatus.ordinal()]));
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setWaterMarkVisible(bl);
        }
    }

    @Override
    public int startCamera(SurfaceView surfaceView) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Please excute init first ");
        }
        if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() == null) {
            throw new IllegalStateException("Not in ScreenCapture Mode");
        }
        if (!this.mScreenStatus.equals((Object)ScreenRecordStatus.SCREEN_RECORD_NORMAL)) {
            throw new IllegalStateException("you should start push screen first");
        }
        if (mNativeAlivcLivePusher != null) {
            Surface surface = null;
            if (surfaceView != null) {
                surface = surfaceView.getHolder().getSurface();
            }
            int n2 = mNativeAlivcLivePusher.startCamera(surface);
            this.mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_CAMERA_START;
            return n2;
        }
        return -1;
    }

    @Override
    public void setScreenOrientation(int n2) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Please excute init first ");
        }
        if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() == null) {
            throw new IllegalStateException("Not in ScreenCapture Mode");
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setScreenOrientation(n2);
        }
    }

    @Override
    public void stopCamera() {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Please excute init first ");
        }
        if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() == null) {
            throw new IllegalStateException("Not in ScreenCapture Mode");
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.stopCamera();
            this.mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_NORMAL;
        }
    }

    @Override
    public int startCameraMix(float f2, float f3, float f4, float f5) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Please excute init first ");
        }
        if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() == null) {
            throw new IllegalStateException("Not in ScreenCapture Mode");
        }
        if (!this.mScreenStatus.equals((Object)ScreenRecordStatus.SCREEN_RECORD_CAMERA_START)) {
            throw new IllegalStateException("You should start camera first");
        }
        if (mNativeAlivcLivePusher != null) {
            int n2 = mNativeAlivcLivePusher.startCameraMix(f2, f3, f4, f5);
            this.mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_CAMERA_MIX_START;
            return n2;
        }
        return -1;
    }

    @Override
    public void stopCameraMix() {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Please excute init first ");
        }
        if (this.mAlivcLivePushConfig.getMediaProjectionPermissionResultData() == null) {
            throw new IllegalStateException("Not in ScreenCapture Mode");
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.stopCameraMix();
            this.mScreenStatus = ScreenRecordStatus.SCREEN_RECORD_CAMERA_START;
        }
    }

    @Override
    public void changeResolution(AlivcResolutionEnum alivcResolutionEnum) {
        if (mNativeAlivcLivePusher == null) {
            throw new IllegalStateException("Please excute init first ");
        }
        if (this.mPushStatus != AlivcLivePushStats.PUSHED && this.mPushStatus != AlivcLivePushStats.PREVIEWED && this.mPushStatus != AlivcLivePushStats.INIT) {
            throw new IllegalStateException("changeResolution can only be called in inited or previewed status");
        }
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.changeResolution(AlivcResolutionEnum.GetResolutionWidth(alivcResolutionEnum), AlivcResolutionEnum.GetResolutionHeight(alivcResolutionEnum));
        }
    }

    public int mixStreamRequireMain(int n2, boolean bl) {
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.mixStreamRequireMain(n2, bl);
        }
        return -1;
    }

    public int mixStreamChangePosition(int n2, float f2, float f3, float f4, float f5) {
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.mixStreamChangePosition(n2, f2, f3, f4, f5);
        }
        return -1;
    }

    public void mixStreamMirror(int n2, boolean bl) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setMixStreamMirror(n2, bl);
        }
    }

    public int addMixVideo(AlivcImageFormat alivcImageFormat, int n2, int n3, int n4, float f2, float f3, float f4, float f5) {
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.addMixVideo(alivcImageFormat.getAlivcImageFormat(), n2, n3, n4, f2, f3, f4, f5);
        }
        return -1;
    }

    public void removeMixVideo(int n2) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.removeMixVideo(n2);
        }
    }

    public void inputMixTexture(int n2, int n3, int n4, int n5, long l2, int n6) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.inputMixTexture(n2, n3, n4, n5, l2, n6);
        }
    }

    public void inputMixVideoPtr(int n2, long l2, int n3, int n4, int n5, int n6, long l3, int n7) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.inputMixVideoPtr(n2, l2, n3, n4, n5, n6, l3, n7);
        }
    }

    public void inputMixVideoData(int n2, byte[] byArray, int n3, int n4, int n5, int n6, long l2, int n7) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.inputMixVideoData(n2, byArray, n3, n4, n5, n6, l2, n7);
        }
    }

    public int addMixAudio(int n2, AlivcSoundFormat alivcSoundFormat, int n3) {
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.addMixAudio(n2, alivcSoundFormat.getAlivcSoundFormat(), n3);
        }
        return -1;
    }

    public void removeMixAudio(int n2) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.removeMixAudio(n2);
        }
    }

    public boolean inputMixAudioPtr(int n2, long l2, int n3, long l3) {
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.inputMixAudioPtr(n2, l2, n3, l3);
        }
        return false;
    }

    public boolean inputMixAudioData(int n2, byte[] byArray, int n3, long l2) {
        if (mNativeAlivcLivePusher != null) {
            return mNativeAlivcLivePusher.inputMixAudioData(n2, byArray, n3, l2);
        }
        return false;
    }

    @Override
    public void inputStreamVideoPtr(long l2, int n2, int n3, int n4, int n5, long l3, int n6) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.inputStreamVideoPtr(l2, n2, n3, n4, n5, l3, n6);
        }
    }

    public void inputStreamTexture(int n2, int n3, int n4, int n5, long l2, int n6, long l3) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.inputStreamTexture(n2, n3, n4, n5, l2, n6, l3);
        }
    }

    @Override
    public void inputStreamVideoData(byte[] byArray, int n2, int n3, int n4, int n5, long l2, int n6) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.inputStreamVideoData(byArray, n2, n3, n4, n5, l2, n6);
        }
    }

    @Override
    public void inputStreamAudioPtr(long l2, int n2, int n3, int n4, long l3) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.inputStreamAudioPtr(l2, n2, n3, n4, l3);
        }
    }

    @Override
    public void inputStreamAudioData(byte[] byArray, int n2, int n3, int n4, long l2) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.inputStreamAudioData(byArray, n2, n3, n4, l2);
        }
    }

    @Override
    public int addDynamicsAddons(String string, float f2, float f3, float f4, float f5) {
        if (f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f || f4 < 0.0f || f4 > 1.0f || f5 < 0.0f || f5 > 1.0f) {
            throw new IllegalArgumentException("x, y, w, h should in range [0~1.0f]");
        }
        if (this.mDynamicAddsonCount > 5) {
            return -1;
        }
        if (mNativeAlivcLivePusher != null) {
            ++this.mDynamicAddsonCount;
            return mNativeAlivcLivePusher.addDynamicsAddons(string, System.currentTimeMillis() * 1000L, 0L, f2, f3, f4, f5, 0, false);
        }
        return -1;
    }

    @Override
    public void removeDynamicsAddons(int n2) {
        if (mNativeAlivcLivePusher != null) {
            --this.mDynamicAddsonCount;
            mNativeAlivcLivePusher.removeDynamicsAddons(n2);
        }
    }

    public void setMainStreamPosition(float f2, float f3, float f4, float f5) {
        if (mNativeAlivcLivePusher != null) {
            mNativeAlivcLivePusher.setMainStreamPosition(f2, f3, f4, f5);
        }
    }

    private String getFormatString(String string) {
        String string2 = "";
        int n2 = string.indexOf(AUTH_KEY);
        if (n2 > 0) {
            String string3 = string.substring(n2);
            string2 = string3.indexOf("-") > 0 ? string3.substring(AUTH_KEY.length(), string3.indexOf("-")) : string3.substring(AUTH_KEY.length());
        }
        return string2;
    }

    private int getTimestamp(String string) {
        int n2 = -1;
        String string2 = this.getFormatString(string);
        if (string2.length() < 10) {
            return -1;
        }
        if (TextUtils.isDigitsOnly((CharSequence)string2)) {
            return new Long(Long.valueOf(string2)).intValue();
        }
        return n2;
    }

    protected static enum ScreenRecordStatus {
        SCREEN_RECORD_NONE,
        SCREEN_RECORD_NORMAL,
        SCREEN_RECORD_CAMERA_START,
        SCREEN_RECORD_CAMERA_MIX_START;

    }
}

