/*
 * Decompiled with CFR 0.152.
 */
package com.alivc.live.pusher;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Environment;
import android.view.Surface;
import com.alivc.component.custom.AlivcLivePushCustomDetect;
import com.alivc.component.custom.AlivcLivePushCustomFilter;
import com.alivc.live.pusher.AlivcBeautyLevelEnum;
import com.alivc.live.pusher.AlivcLivePushConfig;
import com.alivc.live.pusher.AlivcPreviewDisplayMode;
import com.alivc.live.pusher.AlivcPreviewOrientationEnum;
import com.alivc.live.pusher.AlivcPreviewRotationEnum;
import com.alivc.live.pusher.AlivcSnapshotListener;
import com.alivc.live.pusher.LogUtil;
import com.alivc.live.pusher.b;
import java.io.File;

public class LivePusherJNI {
    private long mNativeHandler = 0L;
    private int resolutionWidth = 0;
    private int resolutionHeight = 0;
    private int fps = 20;
    private int targetBitrate = 1500;
    private int minBitrate = 300;
    private int bitrate = 800;
    private int initialBitrate = 800;
    private int audioSample = 32000;
    private int audioChannel = 2;
    private int audioProfile = 2;
    private int audioBitRate = 64000;
    private int connectRetryCount = 5;
    private int connectRetryInterval = 1000;
    private int sendTimeout = 5000;
    private int orientaion = 0;
    private int customRotation = 0;
    private int cameraPosition = 1;
    private boolean pushMirror = false;
    private boolean previewMirror = false;
    private boolean audioOnly = false;
    private boolean videoOnly = false;
    private boolean autoFocus = true;
    private boolean focusBySensor = false;
    private boolean flash = false;
    private boolean beautyOn = true;
    private float beautyBuffing = 0.6f;
    private float beautyWhite = 1.0E-4f;
    private float beautyBright = 1.5f;
    private float beautyPink = 0.0f;
    private float beautyCheekPink = 0.0f;
    private float beautyThinFace = 0.0f;
    private float beautyShortenFace = 0.0f;
    private float beautyBigEye = 0.0f;
    private int beautyMode = 0;
    private int encoderMode = 0;
    private int audioEncoderMode = 0;
    private int videoFormat = 0;
    private int audioFormat = 0;
    private int exposure = 0;
    private int gop = 1;
    private int apiLevel = Build.VERSION.SDK_INT;
    private long ptsMaxDiff = 200000L;
    private int maxTimeoutCount = 10;
    private int maxVideoListSize = 200;
    private int dropKeepVideoListSize = 40;
    private int queueSizeNeedBitrateControl = 30;
    private int minBitrateControlInterval = 3000000;
    private int upBpsRequestFreeDuration = 60000000;
    private int rtmpUpBPsMinFreePrecent = 50;
    private int needUpBpsCacheSize = 1;
    private int maxControlFailedTime = 3;
    public Context context = null;
    public boolean surfaceCbMode = true;
    public int minFps;
    public boolean enableBitrateControl = true;
    public boolean enableAutoResolution = false;
    public static boolean headSetOn = false;
    private int qualityMode = 0;
    private int beautyLevel = 0;
    private int displayMode = 0;
    public static String SD_DIR = Environment.getExternalStorageDirectory().getPath() + File.separator;
    public Intent mediaProjectionPermissionResultData = null;
    private boolean requireGLSharedContext = false;
    private boolean audioCaptureWithouMix = false;
    private a mLivePusherListener = null;
    private AlivcLivePushCustomFilter customFilter = null;
    private boolean mCustomFilterInited = false;
    private AlivcLivePushCustomDetect customDetect = null;
    private boolean mCustomDetectorInited = false;
    private AlivcSnapshotListener mSnapshotListener = null;
    private boolean externMainStream = false;

    public LivePusherJNI(Context context, AlivcLivePushConfig alivcLivePushConfig, a a2) {
        this.context = context;
        this.resolutionWidth = alivcLivePushConfig.getWidth();
        this.resolutionHeight = alivcLivePushConfig.getHeight();
        this.fps = alivcLivePushConfig.getFps();
        this.gop = alivcLivePushConfig.getVideoEncodeGop();
        this.targetBitrate = alivcLivePushConfig.getTargetVideoBitrate();
        this.minBitrate = alivcLivePushConfig.getMinVideoBitrate();
        this.bitrate = alivcLivePushConfig.getInitialVideoBitrate();
        this.initialBitrate = alivcLivePushConfig.getInitialVideoBitrate();
        this.audioSample = alivcLivePushConfig.getAudioSamepleRate().getAudioSampleRate();
        this.audioChannel = b.d(alivcLivePushConfig.getAudioChannels() > 0 ? alivcLivePushConfig.getAudioChannels() : 12);
        this.connectRetryCount = alivcLivePushConfig.getConnectRetryCount();
        this.connectRetryInterval = alivcLivePushConfig.getConnectRetryInterval();
        this.orientaion = alivcLivePushConfig.getPreviewOrientation();
        this.customRotation = alivcLivePushConfig.getPreviewRotation();
        if (this.orientaion == AlivcPreviewOrientationEnum.ORIENTATION_LANDSCAPE_HOME_LEFT.getOrientation() || this.orientaion == AlivcPreviewOrientationEnum.ORIENTATION_LANDSCAPE_HOME_RIGHT.getOrientation()) {
            this.resolutionWidth = alivcLivePushConfig.getHeight();
            this.resolutionHeight = alivcLivePushConfig.getWidth();
        }
        if (this.customRotation == AlivcPreviewRotationEnum.ROTATION_90.getRotation() || this.customRotation == AlivcPreviewRotationEnum.ROTATION_270.getRotation()) {
            int n2 = this.resolutionWidth;
            this.resolutionWidth = this.resolutionHeight;
            this.resolutionHeight = n2;
        }
        this.cameraPosition = alivcLivePushConfig.getCameraType();
        this.pushMirror = alivcLivePushConfig.isPushMirror();
        this.previewMirror = alivcLivePushConfig.isPreviewMirror();
        this.audioOnly = alivcLivePushConfig.isAudioOnly();
        this.videoOnly = alivcLivePushConfig.isVideoOnly();
        this.autoFocus = alivcLivePushConfig.isAutoFocus();
        this.focusBySensor = alivcLivePushConfig.isFocusBySensor();
        this.flash = alivcLivePushConfig.isFlash();
        this.beautyOn = alivcLivePushConfig.isBeautyOn();
        this.displayMode = alivcLivePushConfig.getPreviewDisplayMode().getPreviewDisplayMode();
        this.beautyWhite = alivcLivePushConfig.getBeautyWhite() > 0 ? (float)alivcLivePushConfig.getBeautyWhite() / 100.0f : this.beautyWhite;
        this.beautyBuffing = alivcLivePushConfig.getBeautyBuffing() >= 0 ? (float)alivcLivePushConfig.getBeautyBuffing() / 100.0f : this.beautyBuffing;
        this.beautyBright = alivcLivePushConfig.getBeautyBrightness() >= 0 ? ((float)alivcLivePushConfig.getBeautyBrightness() + 100.0f) / 100.0f : this.beautyBright;
        this.beautyPink = alivcLivePushConfig.getBeautyRuddy() >= 0 ? (float)alivcLivePushConfig.getBeautyRuddy() / 100.0f : this.beautyPink;
        this.beautyCheekPink = alivcLivePushConfig.getBeautyCheekPink() >= 0 ? (float)alivcLivePushConfig.getBeautyCheekPink() / 100.0f : this.beautyCheekPink;
        this.beautyThinFace = alivcLivePushConfig.getBeautyThinFace() > 0 ? (float)alivcLivePushConfig.getBeautyThinFace() / 100.0f : this.beautyThinFace;
        this.beautyBigEye = alivcLivePushConfig.getBeautyBigEye() >= 0 ? (float)alivcLivePushConfig.getBeautyBigEye() / 100.0f : this.beautyBigEye;
        this.beautyShortenFace = alivcLivePushConfig.getBeautyShortenFace() >= 0 ? (float)alivcLivePushConfig.getBeautyShortenFace() / 100.0f : this.beautyShortenFace;
        this.beautyMode = 0;
        this.encoderMode = alivcLivePushConfig.getVideoEncodeMode().ordinal();
        this.audioEncoderMode = alivcLivePushConfig.getAudioEncodeMode().ordinal();
        this.videoFormat = b.e(alivcLivePushConfig.getVideoFormat());
        this.audioFormat = b.c(alivcLivePushConfig.getAudioFormat());
        this.exposure = 0;
        this.mLivePusherListener = a2;
        this.minFps = alivcLivePushConfig.getMinFps();
        this.qualityMode = alivcLivePushConfig.getQualityMode().getQualityMode();
        this.beautyLevel = alivcLivePushConfig.getBeautyLevel().getBeautyMode();
        if (this.beautyLevel == AlivcBeautyLevelEnum.BEAUTY_Professional.getBeautyMode()) {
            this.surfaceCbMode = false;
        }
        this.audioProfile = alivcLivePushConfig.getAudioProfile().getAudioProfile();
        this.audioBitRate = alivcLivePushConfig.getAudioBitRate();
        if (Build.VERSION.SDK_INT >= 21) {
            this.mediaProjectionPermissionResultData = alivcLivePushConfig.getMediaProjectionPermissionResultData();
        }
        if (this.mediaProjectionPermissionResultData != null) {
            this.beautyOn = false;
            this.displayMode = AlivcPreviewDisplayMode.ALIVC_LIVE_PUSHER_PREVIEW_ASPECT_FILL.getPreviewDisplayMode();
        }
        this.enableAutoResolution = alivcLivePushConfig.isEnableAutoResolution();
        this.enableBitrateControl = alivcLivePushConfig.isEnableBitrateControl();
        this.externMainStream = alivcLivePushConfig.isExternMainStream();
        if (this.externMainStream) {
            this.surfaceCbMode = false;
            this.videoFormat = alivcLivePushConfig.getAlivcExternMainImageFormat().getAlivcImageFormat();
            this.audioFormat = alivcLivePushConfig.getAlivcExternMainSoundFormat().getAlivcSoundFormat();
        }
        this.sendTimeout = alivcLivePushConfig.getSendDataTimeout();
        this.requireGLSharedContext = alivcLivePushConfig.getRequireRenderContextNotify();
        this.audioCaptureWithouMix = alivcLivePushConfig.getAudioCaptureWithoutMix();
    }

    public void init() {
        if (!this.externMainStream) {
            this.initLive(false);
        } else {
            this.initLive(true);
        }
        LogUtil.d("LivePusherJNI", "native handler " + this.mNativeHandler);
    }

    public int startPreview(Surface surface, boolean bl) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        if (!this.externMainStream) {
            return this.startLivePreview(surface, bl, false);
        }
        return this.startLivePreview(surface, bl, true);
    }

    public int stopPreview() {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.stopLivePreview();
    }

    public int startPush(String string, boolean bl) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        this.setNativeHeadSet(headSetOn);
        if (!this.externMainStream) {
            return this.startLivePush(string, bl, false);
        }
        return this.startLivePush(string, bl, true);
    }

    public int restartPush(Surface surface, boolean bl, int n2) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.restartLivePush(surface, bl, n2);
    }

    public int reconnect(String string, boolean bl) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.reconnectLive(string, bl);
    }

    public int stopPush() {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.stopLivePush();
    }

    public void pause() {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.pauseLive();
    }

    public void resume(boolean bl) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.resumeLive(bl);
    }

    public void release() {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.unInitLive();
        this.mNativeHandler = 0L;
    }

    public void setBeauty(boolean bl, int n2, int n3) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        if (this.mCustomFilterInited) {
            this.customFilter.customFilterSwitch(bl);
        }
        this.setLiveBeauty(bl, n2, n3);
        this.beautyOn = bl;
    }

    public int setFaceBeauty(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (f3 <= 0.0f) {
            f3 = 0.001f;
        }
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        if (this.mCustomFilterInited) {
            this.customFilter.customFilterUpdateParam(f2, f3, f6, f5, f7, f8, f9);
        }
        return this.setLiveFaceBeauty(f2, f3, f4, f5, f6, f7, f8, f9);
    }

    public void addWaterMark(String string, float f2, float f3, float f4, float f5) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.addLiveWaterMark(string, f2, f3, f4, f5);
    }

    public int switchCamera() {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.switchLiveCamera();
    }

    public void setOrientaion(int n2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setLiveScreenOrientation(n2);
    }

    public int setCameraFocus(boolean bl, float f2, float f3) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.setLiveCameraFocus(bl, f2, f3);
    }

    public int setCameraZoom(float f2) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.setLiveCameraZoom(f2);
    }

    public int getCameraMaxZoom() {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.getLiveCameraMaxZoom();
    }

    public int getCameraCurrentZoom() {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.getLiveCameraCurrentZoom();
    }

    public int setMute(boolean bl) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        LogUtil.d("LivePusherJNI", "setMute");
        return this.setLiveMute(bl);
    }

    public int setFlash(boolean bl) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.setLiveFlash(bl);
    }

    public void setPusherMirror(boolean bl) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setLivePusherMirror(bl);
    }

    public void setPreviewMirror(boolean bl) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setLivePreviewMirror(bl);
    }

    public void setVideoBitrateRange(int n2, int n3, int n4) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setLiveVideoBitrateRange(n2, n3, n4);
    }

    public boolean isPushing() {
        if (this.mNativeHandler == 0L) {
            return false;
        }
        return this.isLivePushing();
    }

    public boolean isNetworkPushing() {
        if (this.mNativeHandler == 0L) {
            return false;
        }
        return this.isLiveNetworkPushing();
    }

    public void notifySurfaceChange(Surface surface, int n2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.notifyLiveSurfaceChanged(surface, n2);
    }

    public void notifySurfaceDestroy() {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.notifyLiveSurfaceDestroy();
    }

    public void notifySurfaceReCreate(Surface surface) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.notifyLiveSurfaceRecreate(surface);
    }

    public String getPerformanceInfo() {
        if (this.mNativeHandler == 0L) {
            return null;
        }
        return this.getLivePerformanceInfo();
    }

    public int mixStreamRequireMain(int n2, boolean bl) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.mixVideoRequireMain(n2, bl);
    }

    public int mixStreamChangePosition(int n2, float f2, float f3, float f4, float f5) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.mixVideoChangePosition(n2, f2, f3, f4, f5);
    }

    public long getPusherHandler() {
        LogUtil.d("LivePusherJNI", "getPusherHandler " + this.mNativeHandler);
        return this.mNativeHandler;
    }

    public int onNotification(int n2, String string, int n3, int n4, int n5, int n6, int n7, long l2) {
        if (this.mLivePusherListener != null) {
            this.mLivePusherListener.onNotify(n2, string, n3, n4, n5, n6, n7, l2);
        }
        return 0;
    }

    public boolean isCameraSupportAutoFocus() {
        if (this.mNativeHandler == 0L) {
            return false;
        }
        return this.isLiveSupportAutoFocus();
    }

    public boolean isCameraSupportFlash() {
        if (this.mNativeHandler == 0L) {
            return false;
        }
        return this.isLiveSupportFlash();
    }

    public void setHeadSet(boolean bl) {
        headSetOn = bl;
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setNativeHeadSet(bl);
    }

    public void setAudioVolume(int n2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setNativeCaptureAudioVolume(n2);
    }

    public void setBackgroundMusicVolume(int n2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setNativeBackgroundMusicVolume(n2);
    }

    public void startBGMAsync(String string) {
        this.setNativeHeadSet(headSetOn);
        this.startNativeBGMAsync(string);
    }

    public void stopBGM() {
        this.stopNativeBGM();
    }

    public void pauseBGM() {
        this.pauseNativeBGM();
    }

    public void resumeBGM() {
        this.resumeNativeBGM();
    }

    public void setBGMLoop(boolean bl) {
        this.setNativeBGMLoop(bl);
    }

    public void setEarsBack(boolean bl) {
        this.setNativeEarsBack(bl);
    }

    public void setAudioDenoise(boolean bl) {
        this.setNativeDenoise(bl);
    }

    public void setQualityMode(int n2) {
        this.setNativeQualityMode(n2);
    }

    public void setDisplayMode(int n2) {
        this.setNativeDisplayMode(n2);
    }

    public void pauseScreenCapture() {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.pauseLiveScreenCapture();
    }

    public int resumeScreenCapture() {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.resumeLiveScreenCapture();
    }

    public void setWaterMarkVisible(boolean bl) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setNativeWatermarkVisible(bl);
    }

    public void setLogLevel(int n2) {
        this.setNativeLogLevel(n2);
    }

    public int addDynamicsAddons(String string, long l2, long l3, float f2, float f3, float f4, float f5, int n2, boolean bl) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.addNativeAddons(string, l2, l3, f2, f3, f4, f5, n2, bl);
    }

    public void removeDynamicsAddons(int n2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.removeNativeAddons(n2);
    }

    public void addPushImage(String string, String string2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.addNativePushImage(string, string2);
    }

    public void addSeiInfo(String string, int n2, int n3, boolean bl) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.addNativeSeiInfo(string, n2, n3, bl);
    }

    public void removePushImage() {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.removeNativePushImage();
    }

    public int startCamera(Surface surface) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.screenCaptureStartCamera(surface);
    }

    public void setScreenOrientation(int n2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.screenSetScreenOrientation(n2);
    }

    public void stopCamera() {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.screenCaptureStopCamera();
    }

    public int startCameraMix(float f2, float f3, float f4, float f5) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.screenCaptureStartMix(f2, f3, f4, f5);
    }

    public void stopCameraMix() {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.screenCaptureStopMix();
    }

    public int addMixVideo(int n2, int n3, int n4, int n5, float f2, float f3, float f4, float f5) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.addNativeMixVideo(n2, n3, n4, n5, f2, f3, f4, f5);
    }

    public void removeMixVideo(int n2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.removeNativeMixVideo(n2);
    }

    public void inputMixVideoPtr(int n2, long l2, int n3, int n4, int n5, int n6, long l3, int n7) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.inputNativeMixVideoPtr(n2, l2, n3, n4, n5, n6, l3, n7);
    }

    public void inputMixTexture(int n2, int n3, int n4, int n5, long l2, int n6) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.inputNativeMixTexture(n2, n3, n4, n5, l2, n6);
    }

    public void inputMixVideoData(int n2, byte[] byArray, int n3, int n4, int n5, int n6, long l2, int n7) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.inputNativeMixVideoData(n2, byArray, n3, n4, n5, n6, l2, n7);
    }

    public int addMixAudio(int n2, int n3, int n4) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.addNativeMixAudio(n2, n3, n4);
    }

    public void removeMixAudio(int n2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.removeNativeMixAudio(n2);
    }

    public boolean inputMixAudioPtr(int n2, long l2, int n3, long l3) {
        if (this.mNativeHandler == 0L) {
            return false;
        }
        return this.inputNativeMixAudioPtr(n2, l2, n3, l3);
    }

    public boolean inputMixAudioData(int n2, byte[] byArray, int n3, long l2) {
        if (this.mNativeHandler == 0L) {
            return false;
        }
        return this.inputNativeMixAudioData(n2, byArray, n3, l2);
    }

    public void setMainStreamPosition(float f2, float f3, float f4, float f5) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.setNativeMainStreamPosition(f2, f3, f4, f5);
    }

    public void setMixStreamMirror(int n2, boolean bl) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.mixVideoMirror(n2, bl);
    }

    public void inputStreamVideoPtr(long l2, int n2, int n3, int n4, int n5, long l3, int n6) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.inputNativeStreamVideoPtr(l2, n2, n3, n4, n5, l3, n6);
    }

    public void inputStreamTexture(int n2, int n3, int n4, int n5, long l2, int n6, long l3) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.inputNativeStreamTexture(n2, n3, n4, n5, l2, n6, l3);
    }

    public void inputStreamVideoData(byte[] byArray, int n2, int n3, int n4, int n5, long l2, int n6) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.inputNativeStreamVideoData(byArray, n2, n3, n4, n5, l2, n6);
    }

    public void inputStreamAudioPtr(long l2, int n2, int n3, int n4, long l3) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.inputNativeStreamAudioPtr(l2, n2, n3, n4, l3);
    }

    public void inputStreamAudioData(byte[] byArray, int n2, int n3, int n4, long l2) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.inputNativeStreamAudioData(byArray, n2, n3, n4, l2);
    }

    public void initStream() {
        this.initLive(true);
        LogUtil.d("LivePusherJNI", "native handler " + this.mNativeHandler);
    }

    public int startPreviewStream(Surface surface) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.startLivePreview(surface, true, true);
    }

    public int stopPreviewStream() {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.stopLivePreview();
    }

    public int startPushStream(String string) {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        this.setNativeHeadSet(headSetOn);
        return this.startLivePush(string, true, true);
    }

    public int stopPushStream() {
        if (this.mNativeHandler == 0L) {
            return -1;
        }
        return this.stopLivePush();
    }

    public void releaseStream() {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.unInitLive();
        this.mNativeHandler = 0L;
    }

    public void setCustomFilter(AlivcLivePushCustomFilter alivcLivePushCustomFilter) {
        this.customFilter = alivcLivePushCustomFilter;
    }

    public void setCustomDetect(AlivcLivePushCustomDetect alivcLivePushCustomDetect) {
        this.customDetect = alivcLivePushCustomDetect;
    }

    public void snapshot(int n2, int n3, AlivcSnapshotListener alivcSnapshotListener) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        this.mSnapshotListener = alivcSnapshotListener;
        this.snapshotNative(n2, n3);
    }

    void customBeautyCreate() {
        if (this.customFilter == null) {
            return;
        }
        this.customFilter.customFilterCreate();
        this.mCustomFilterInited = true;
        this.customFilter.customFilterSwitch(this.beautyOn);
    }

    int customBeautyProcess(int n2, int n3, int n4, long l2) {
        if (this.customFilter == null) {
            return n2;
        }
        if (this.mCustomFilterInited) {
            return this.customFilter.customFilterProcess(n2, n3, n4, l2);
        }
        return n2;
    }

    void customBeautyDestroy() {
        if (this.customFilter == null) {
            return;
        }
        if (this.mCustomFilterInited) {
            this.customFilter.customFilterDestroy();
        }
        this.mCustomFilterInited = false;
    }

    void customDetectCreate() {
        if (this.customDetect == null) {
            return;
        }
        this.customDetect.customDetectCreate();
        this.mCustomDetectorInited = true;
    }

    long customDetectProcess(long l2, int n2, int n3, int n4, int n5, long l3) {
        if (this.customDetect == null) {
            return 0L;
        }
        if (this.mCustomDetectorInited) {
            return this.customDetect.customDetectProcess(l2, n2, n3, n4, n5, l3);
        }
        return 0L;
    }

    void customDetectDestroy() {
        if (this.customDetect == null) {
            return;
        }
        if (this.mCustomDetectorInited) {
            this.customDetect.customDetectDestroy();
        }
        this.mCustomDetectorInited = false;
    }

    void changeResolution(int n2, int n3) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        if (this.orientaion == AlivcPreviewOrientationEnum.ORIENTATION_LANDSCAPE_HOME_LEFT.getOrientation() || this.orientaion == AlivcPreviewOrientationEnum.ORIENTATION_LANDSCAPE_HOME_RIGHT.getOrientation()) {
            this.resolutionWidth = n3;
            this.resolutionHeight = n2;
        } else {
            this.resolutionWidth = n2;
            this.resolutionHeight = n3;
        }
        this.changeNativeResolution(this.resolutionWidth, this.resolutionHeight);
    }

    void snapshotCallback(Bitmap bitmap) {
        if (bitmap != null && this.mSnapshotListener != null) {
            this.mSnapshotListener.onSnapshot(bitmap);
        }
    }

    private native long initLive(boolean var1);

    private native int startLivePreview(Surface var1, boolean var2, boolean var3);

    private native int stopLivePreview();

    private native int startLivePush(String var1, boolean var2, boolean var3);

    private native int restartLivePush(Surface var1, boolean var2, int var3);

    private native int reconnectLive(String var1, boolean var2);

    private native int stopLivePush();

    private native void pauseLive();

    private native void resumeLive(boolean var1);

    private native void unInitLive();

    private native void setLiveBeauty(boolean var1, int var2, int var3);

    private native int setLiveFaceBeauty(float var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8);

    private native void addLiveWaterMark(String var1, float var2, float var3, float var4, float var5);

    private native int switchLiveCamera();

    private native int setLiveCameraFocus(boolean var1, float var2, float var3);

    private native int setLiveCameraZoom(float var1);

    private native int getLiveCameraMaxZoom();

    private native int getLiveCameraCurrentZoom();

    private native int setLiveCameraExposure(int var1);

    private native int getLiveCameraCurrentExposure();

    private native int setLiveMute(boolean var1);

    private native int setLiveFlash(boolean var1);

    private native void setLivePusherMirror(boolean var1);

    private native void setLivePreviewMirror(boolean var1);

    private native void setLiveVideoBitrateRange(int var1, int var2, int var3);

    private native boolean isLivePushing();

    private native boolean isLiveNetworkPushing();

    private native void setLiveScreenOrientation(int var1);

    private native void notifyLiveSurfaceChanged(Surface var1, int var2);

    private native void notifyLiveSurfaceDestroy();

    private native void notifyLiveSurfaceRecreate(Surface var1);

    private native String getLivePerformanceInfo();

    public void setFps(int n2) {
        this.fps = n2;
    }

    public void setPreOrientaion(int n2) {
        this.orientaion = n2;
    }

    public void setGop(int n2) {
        this.gop = n2;
    }

    private native boolean isLiveSupportAutoFocus();

    private native boolean isLiveSupportFlash();

    private native void setNativeLogLevel(int var1);

    private native void setNativeHeadSet(boolean var1);

    private native void setNativeBackgroundMusicVolume(int var1);

    private native void setNativeCaptureAudioVolume(int var1);

    private native void startNativeBGMAsync(String var1);

    private native void stopNativeBGM();

    private native void pauseNativeBGM();

    private native void resumeNativeBGM();

    private native void setNativeBGMLoop(boolean var1);

    private native void setNativeEarsBack(boolean var1);

    private native void setNativeDenoise(boolean var1);

    private native void setNativeQualityMode(int var1);

    private native void setNativeDisplayMode(int var1);

    private native void pauseLiveScreenCapture();

    private native int resumeLiveScreenCapture();

    private native int addNativeAddons(String var1, long var2, long var4, float var6, float var7, float var8, float var9, int var10, boolean var11);

    private native void removeNativeAddons(int var1);

    private native int mixVideoRequireMain(int var1, boolean var2);

    private native int mixVideoChangePosition(int var1, float var2, float var3, float var4, float var5);

    private native void addNativePushImage(String var1, String var2);

    private native void removeNativePushImage();

    private native void setNativeWatermarkVisible(boolean var1);

    private native int screenCaptureStartCamera(Surface var1);

    private native void screenSetScreenOrientation(int var1);

    private native void screenCaptureStopCamera();

    private native int screenCaptureStartMix(float var1, float var2, float var3, float var4);

    private native void screenCaptureStopMix();

    private native void addNativeSeiInfo(String var1, int var2, int var3, boolean var4);

    private native int addNativeMixVideo(int var1, int var2, int var3, int var4, float var5, float var6, float var7, float var8);

    private native void removeNativeMixVideo(int var1);

    private native void inputNativeMixVideoPtr(int var1, long var2, int var4, int var5, int var6, int var7, long var8, int var10);

    private native void inputNativeMixTexture(int var1, int var2, int var3, int var4, long var5, int var7);

    private native void inputNativeMixVideoData(int var1, byte[] var2, int var3, int var4, int var5, int var6, long var7, int var9);

    private native int addNativeMixAudio(int var1, int var2, int var3);

    private native void removeNativeMixAudio(int var1);

    private native boolean inputNativeMixAudioPtr(int var1, long var2, int var4, long var5);

    private native boolean inputNativeMixAudioData(int var1, byte[] var2, int var3, long var4);

    private native void setNativeMainStreamPosition(float var1, float var2, float var3, float var4);

    private native void inputNativeStreamVideoPtr(long var1, int var3, int var4, int var5, int var6, long var7, int var9);

    private native void inputNativeStreamTexture(int var1, int var2, int var3, int var4, long var5, int var7, long var8);

    private native void inputNativeStreamVideoData(byte[] var1, int var2, int var3, int var4, int var5, long var6, int var8);

    private native void inputNativeStreamAudioPtr(long var1, int var3, int var4, int var5, long var6);

    private native void inputNativeStreamAudioData(byte[] var1, int var2, int var3, int var4, long var5);

    private native void changeNativeResolution(int var1, int var2);

    private native void snapshotNative(int var1, int var2);

    private native void mixVideoMirror(int var1, boolean var2);

    static {
        System.loadLibrary("live-rtmp");
        System.loadLibrary("live-openh264");
        System.loadLibrary("live-fdkaac");
        System.loadLibrary("live-pusher");
    }

    public static interface a {
        public void onNotify(int var1, String var2, int var3, int var4, int var5, int var6, int var7, long var8);
    }
}

