/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.clientinforeport.util;

import android.text.TextUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class NetUtils {
    public static String getHostIp() {
        String hostIp = null;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            InetAddress ia = null;
            block2: while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    String ip;
                    ia = ias.nextElement();
                    if (ia instanceof Inet6Address || "127.0.0.1".equals(ip = ia.getHostAddress())) continue;
                    hostIp = ia.getHostAddress();
                    continue block2;
                }
            }
            return hostIp;
        }
        catch (SocketException socketException) {
            return "0.0.0.0";
        }
    }

    public static boolean isIp(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        String[] addr = str.split("\\.");
        return addr.length == 4;
    }
}

