/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service.event;

import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.callback.IEventCallback;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.service.event.EventInfo;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.account.Account;
import com.alipay.mychain.sdk.domain.block.BlockHeader;
import com.alipay.mychain.sdk.domain.contract.Contract;
import com.alipay.mychain.sdk.domain.event.EventTopicResult;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.event.FetchEventRequest;
import com.alipay.mychain.sdk.message.event.FetchEventResponse;
import com.alipay.mychain.sdk.message.event.PushAccountEvent;
import com.alipay.mychain.sdk.message.event.PushBlockEvent;
import com.alipay.mychain.sdk.message.event.PushContractEvent;
import com.alipay.mychain.sdk.message.event.PushTopicsEvent;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.task.AbstractTask;
import com.alipay.mychain.sdk.task.TaskType;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class EventTask
extends AbstractTask {
    private EventInfo eventInfo;
    private INetwork network;
    private Integer timeout;

    public EventTask(EventInfo eventInfo, INetwork network, ILogger logger, Integer timeout) {
        super(1000, TaskType.ALWAYS, logger);
        this.eventInfo = eventInfo;
        this.network = network;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        FetchEventRequest fetchEventRequest = new FetchEventRequest(this.eventInfo.getServerEventId());
        final IEventCallback handler = this.eventInfo.getHandler();
        if (this.network == null) {
            this.logger.debug("EventTask, network is null");
            return;
        }
        this.network.sendAsyncRequest(fetchEventRequest, new Hash(), new IAsyncCallback(){

            @Override
            public void onResponse(int errorCode, Response response) {
                if (!response.isSuccess()) {
                    EventTask.this.logger.error("EvenTask, onResponse is error, errorCode desc:{}", (Object)response.getErrorCode().getErrorDesc());
                }
                FetchEventResponse fetchEventResponse = (FetchEventResponse)response;
                EventTask.this.logger.debug("EvenTask, onResponse type: {}", (Object)fetchEventResponse.getType().name());
                byte[] data = fetchEventResponse.getData();
                if (ArrayUtils.isEmpty((byte[])data)) {
                    EventTask.this.logger.error("EvenTask, onResponse event data is empty");
                    return;
                }
                RlpList rlpList = new RlpList();
                try {
                    RlpList dataList = (RlpList)Rlp.decode2(data).get(0);
                    if (!dataList.isEmpty()) {
                        rlpList = (RlpList)dataList.get(0);
                    }
                }
                catch (Throwable e) {
                    EventTask.this.logger.error("EventTask, decode eventData failed.");
                }
                if (rlpList.isEmpty()) {
                    return;
                }
                switch (fetchEventResponse.getType()) {
                    case ACCOUNT: {
                        ArrayList<Account> accounts = new ArrayList<Account>();
                        for (RlpElement element : rlpList) {
                            Account item = new Account();
                            item.fromRlp((RlpList)element);
                            accounts.add(item);
                        }
                        if (accounts.isEmpty()) {
                            EventTask.this.logger.error("EventTask, accounts is empty");
                            break;
                        }
                        handler.onEvent(new PushAccountEvent(EventTask.this.eventInfo.getUserEventId(), accounts));
                        break;
                    }
                    case CONTRACT: {
                        ArrayList<Contract> contracts = new ArrayList<Contract>();
                        for (RlpElement element : rlpList) {
                            Contract item = new Contract();
                            item.fromRlp((RlpList)element);
                            contracts.add(item);
                        }
                        if (contracts.isEmpty()) {
                            EventTask.this.logger.error("EventTask, contracts is empty");
                            break;
                        }
                        handler.onEvent(new PushContractEvent(EventTask.this.eventInfo.getUserEventId(), contracts));
                        break;
                    }
                    case TOPIC: {
                        ArrayList<EventTopicResult> topicResults = new ArrayList<EventTopicResult>();
                        for (RlpElement element : rlpList) {
                            EventTopicResult item = new EventTopicResult();
                            item.fromRlp((RlpList)element);
                            topicResults.add(item);
                        }
                        if (topicResults.isEmpty()) {
                            EventTask.this.logger.error("EventTask, topicResults is empty");
                            break;
                        }
                        handler.onEvent(new PushTopicsEvent(EventTask.this.eventInfo.getUserEventId(), topicResults));
                        break;
                    }
                    case BLOCK: {
                        ArrayList<BlockHeader> blockHeaders = new ArrayList<BlockHeader>();
                        for (RlpElement element : rlpList) {
                            BlockHeader item = new BlockHeader();
                            item.fromRlp((RlpList)element);
                            blockHeaders.add(item);
                        }
                        if (blockHeaders.isEmpty()) {
                            EventTask.this.logger.error("EventTask, blockHeaders is empty");
                            break;
                        }
                        handler.onEvent(new PushBlockEvent(EventTask.this.eventInfo.getUserEventId(), blockHeaders));
                        break;
                    }
                    default: {
                        EventTask.this.logger.error("EvenTask, onResponse type error, type:", (Object)fetchEventResponse.getType().name());
                    }
                }
            }
        }, this.timeout);
    }
}

