/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.signer;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.NumericUtils;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;

public class EccK1KeypairV0
implements SignerBase {
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    private static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    private static final BigInteger HALF_CURVE_ORDER = CURVE_PARAMS.getN().shiftRight(1);
    private byte[] privateKey;
    private byte[] publicKey;

    public EccK1KeypairV0() {
    }

    public EccK1KeypairV0(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_ECCK1_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            this.publicKey = this.getPubkeyFromId(pubKey);
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            if (priKey.length != 32) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need private key size 32 but " + priKey.length);
            }
            this.privateKey = ArrayUtils.clone((byte[])priKey);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.publicKey = this.getPubKeyByPrivkey(priKey);
            }
        }
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return CURVE.getCurve().decodePoint(compEnc);
    }

    private static BigInteger recoverPublicKey(int recId, BigInteger sigR, BigInteger sigS, byte[] message) {
        BigInteger prime;
        BigInteger n = CURVE.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = sigR.add(i.multiply(n));
        if (x.compareTo(prime = SecP256K1Curve.q) >= 0) {
            return null;
        }
        ECPoint r = EccK1KeypairV0.decompressKey(x, (recId & 1) == 1);
        if (!r.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, message);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = sigR.modInverse(n);
        BigInteger srInv = rInv.multiply(sigS).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)CURVE.getG(), (BigInteger)eInvrInv, (ECPoint)r, (BigInteger)srInv);
        byte[] qBytes = q.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(qBytes, 1, qBytes.length));
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.SIGNER_ECCK1_LOCAL_V0;
    }

    @Override
    public boolean isSigner() {
        return !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public boolean isVerifier() {
        return !ArrayUtils.isEmpty((byte[])this.publicKey) || !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public byte[] sign(byte[] message) {
        if (ArrayUtils.isEmpty((byte[])message) || message.length != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need hash size 32 but " + (ArrayUtils.isEmpty((byte[])message) ? 0 : message.length));
        }
        if (!this.isSigner()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(new BigInteger(1, this.privateKey), CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(message);
        components[1] = this.toCanonicalised(components[1]);
        int recId = -1;
        int length = 4;
        BigInteger pubKey = new BigInteger(1, this.publicKey);
        for (int i = 0; i < length; ++i) {
            BigInteger k = EccK1KeypairV0.recoverPublicKey(i, components[0], components[1], message);
            if (k == null || !k.equals(pubKey)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        byte v = (byte)recId;
        byte[] r = NumericUtils.toBytesPadded(components[0], 32);
        byte[] s = NumericUtils.toBytesPadded(components[1], 32);
        byte[] sig = new byte[65];
        System.arraycopy(r, 0, sig, 0, 32);
        System.arraycopy(s, 0, sig, 32, 32);
        sig[64] = v;
        return sig;
    }

    @Override
    public boolean verify(byte[] signature, byte[] data) {
        if (ArrayUtils.isEmpty((byte[])signature) || signature.length < 64) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need signature size 64 but " + (ArrayUtils.isEmpty((byte[])signature) ? 0 : signature.length));
        }
        if (ArrayUtils.isEmpty((byte[])data) || data.length != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need hash size 32 but " + (ArrayUtils.isEmpty((byte[])data) ? 0 : data.length));
        }
        if (!this.isVerifier()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
        }
        byte[] publicKey = this.publicKey;
        byte[] pubX = Arrays.copyOfRange(publicKey, 0, 32);
        byte[] pubY = Arrays.copyOfRange(publicKey, 32, 64);
        ECPoint point = CURVE.getCurve().createPoint(new BigInteger(1, pubX), new BigInteger(1, pubY));
        byte[] sigR = Arrays.copyOfRange(signature, 0, 32);
        byte[] sigS = Arrays.copyOfRange(signature, 32, 64);
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPublicKeyParameters pubKeyParameters = new ECPublicKeyParameters(point, CURVE);
        signer.init(false, (CipherParameters)pubKeyParameters);
        return signer.verifySignature(data, new BigInteger(1, sigR), new BigInteger(1, sigS));
    }

    @Override
    public byte[] recover(byte[] sig, byte[] msg) {
        if (ArrayUtils.isEmpty((byte[])sig) || sig.length != 65) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need signature size 65 but " + (ArrayUtils.isEmpty((byte[])sig) ? 0 : sig.length));
        }
        if (ArrayUtils.isEmpty((byte[])msg) || msg.length != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need hash size 32 but " + (ArrayUtils.isEmpty((byte[])msg) ? 0 : msg.length));
        }
        byte recId = sig[64];
        BigInteger r = new BigInteger(1, Arrays.copyOfRange(sig, 0, 32));
        BigInteger s = new BigInteger(1, Arrays.copyOfRange(sig, 32, 64));
        BigInteger publicKeyInteger = EccK1KeypairV0.recoverPublicKey(recId, r, s, msg);
        return NumericUtils.toBytesPadded(publicKeyInteger, 64);
    }

    private boolean isCanonical(BigInteger s) {
        return s.compareTo(HALF_CURVE_ORDER) <= 0;
    }

    private BigInteger toCanonicalised(BigInteger s) {
        if (!this.isCanonical(s)) {
            s = CURVE.getN().subtract(s);
        }
        return s;
    }

    private byte[] getPubkeyFromId(byte[] pubkeyId) {
        if (pubkeyId.length != 64 && pubkeyId.length != 65) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need public key size 64 or 65 but " + pubkeyId.length);
        }
        if (pubkeyId.length == 64) {
            return ArrayUtils.clone((byte[])pubkeyId);
        }
        if (pubkeyId[0] != 4) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "65 bytes public key need start by 04");
        }
        return Arrays.copyOfRange(pubkeyId, 1, 65);
    }

    private byte[] getPubKeyByPrivkey(byte[] privKey) {
        BigInteger priKeyIn = new BigInteger(1, privKey);
        ECPoint point = CryptoUtils.publicPointFromPrivate(CURVE, priKeyIn);
        byte[] encoded = point.getEncoded(false);
        return Arrays.copyOfRange(encoded, 1, encoded.length);
    }
}

