/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.signer;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.CryptoUtils;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.custom.sec.SecP256R1Curve;
import org.bouncycastle.util.encoders.Hex;

public class EccR1SignerV1
implements SignerBase {
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256r1");
    private static final ECCurve CURVE4ORDER = new SecP256R1Curve();
    private static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    private byte[] privateKey;
    private byte[] publicKey;

    public EccR1SignerV1(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair is null!");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_ECCR1_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid key type!");
        }
        byte[] pubKey = keypair.getPubkeyId();
        byte[] priKey = keypair.getPrivkeyId();
        if (!ArrayUtils.isEmpty((byte[])pubKey)) {
            this.publicKey = this.getPubkeyFromId(pubKey);
        }
        if (!ArrayUtils.isEmpty((byte[])priKey)) {
            if (priKey.length != 32) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need private key size 32 but " + priKey.length);
            }
            this.privateKey = ArrayUtils.clone((byte[])priKey);
            if (ArrayUtils.isEmpty((byte[])pubKey)) {
                this.publicKey = this.getPubKeyByPrivkey(priKey);
            }
        }
    }

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.SIGNER_ECCR1_LOCAL_V1;
    }

    @Override
    public boolean isSigner() {
        return !ArrayUtils.isEmpty((byte[])this.privateKey);
    }

    @Override
    public boolean isVerifier() {
        return !ArrayUtils.isEmpty((byte[])this.publicKey);
    }

    @Override
    public byte[] sign(byte[] message) {
        if (ArrayUtils.isEmpty((byte[])message) || message.length != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need hash size 32 but " + (ArrayUtils.isEmpty((byte[])message) ? 0 : message.length));
        }
        if (!this.isSigner()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        ECDSASigner signer = new ECDSASigner();
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(new BigInteger(1, this.privateKey), CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(message);
        BigInteger order = CURVE4ORDER.getOrder();
        if (components[1].compareTo(order.divide(BigInteger.valueOf(2L))) > 0) {
            components[1] = order.subtract(components[1]);
        }
        byte[] asn1Array = null;
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1Integer(components[0]));
            v.add((ASN1Encodable)new ASN1Integer(components[1]));
            DERSequence derSequence = new DERSequence(v);
            asn1Array = derSequence.getEncoded();
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        byte[] rs = new byte[asn1Array.length + 6];
        System.arraycopy(this.getAlgo().toBytes(), 0, rs, 0, 2);
        byte[] withAlgoPub = new byte[67];
        System.arraycopy(KeyTypeEnum.KEY_ECCR1_PKCS8.toBytes(), 0, withAlgoPub, 0, 2);
        withAlgoPub[2] = 4;
        System.arraycopy(this.publicKey, 0, withAlgoPub, 3, 64);
        System.arraycopy(CryptoUtils.getPubkeyFp(withAlgoPub), 0, rs, 2, 4);
        System.arraycopy(asn1Array, 0, rs, 6, asn1Array.length);
        return rs;
    }

    public static void main(String[] args) {
        Keypair keypair = new Keypair(Hex.decode((String)"0002045eb3bd920d8f1a9f55b4bca76cb74112caeaa86cebc75673269f32171a239d7dac6f7b6939f0fa86f84a9f327027bd86224a8396997412257b6d6931f0f16940"), Hex.decode((String)"00023d0a5447543665185e98c28e6e06573ec8050d9320a10d91b2f3dbcccf52e17c"));
        EccR1SignerV1 eccR1SignerV1 = new EccR1SignerV1(keypair);
        byte[] sig = eccR1SignerV1.sign(Hex.decode((String)"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"));
        System.out.println(Hex.toHexString((byte[])sig));
        boolean isVerify = eccR1SignerV1.verify(sig, Hex.decode((String)"2cf24dba5fb0a30e26e83b2ac5b9e29e1b161e5c1fa7425e73043362938b9824"));
        System.out.println("end");
    }

    @Override
    public boolean verify(byte[] sigRaw, byte[] msg) {
        if (msg.length != 32) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need msg size 32 but " + (ArrayUtils.isEmpty((byte[])msg) ? 0 : msg.length));
        }
        if (!this.isVerifier()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "no pub key");
        }
        if (!AlgoIdEnum.valueOf(sigRaw).equals((Object)AlgoIdEnum.SIGNER_ECCR1_LOCAL_V1)) {
            throw new MychainSdkException(ErrorCode.SDK_SIGN_TOOL_VERIFY_ERROR, "algo no match");
        }
        byte[] sig = new byte[sigRaw.length - 6];
        System.arraycopy(sigRaw, 6, sig, 0, sigRaw.length - 6);
        byte[] publicKey = this.publicKey;
        byte[] pubX = Arrays.copyOfRange(publicKey, 0, 32);
        byte[] pubY = Arrays.copyOfRange(publicKey, 32, 64);
        ECPoint point = CURVE.getCurve().createPoint(new BigInteger(1, pubX), new BigInteger(1, pubY));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(point, CURVE);
        ECDSASigner ecdsaSigner = new ECDSASigner();
        ecdsaSigner.init(false, (CipherParameters)publicKeyParameters);
        try {
            ASN1Sequence asn1Sequence = ASN1Sequence.getInstance((Object)sig);
            BigInteger r = ((ASN1Integer)asn1Sequence.getObjectAt(0)).getValue();
            BigInteger s = ((ASN1Integer)asn1Sequence.getObjectAt(1)).getValue();
            return ecdsaSigner.verifySignature(msg, r, s);
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.SDK_SIGN_TOOL_VERIFY_ERROR, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] recover(byte[] sig, byte[] msg) {
        return new byte[0];
    }

    private byte[] getPubkeyFromId(byte[] pubkeyId) {
        if (pubkeyId.length != 64 && pubkeyId.length != 65) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "need public key size 64 or 65 but " + pubkeyId.length);
        }
        if (pubkeyId.length == 64) {
            return ArrayUtils.clone((byte[])pubkeyId);
        }
        if (pubkeyId[0] != 4) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "65 bytes public key need start by 04");
        }
        return Arrays.copyOfRange(pubkeyId, 1, 65);
    }

    private byte[] getPubKeyByPrivkey(byte[] privKey) {
        BigInteger priKeyIn = new BigInteger(1, privKey);
        ECPoint point = CryptoUtils.publicPointFromPrivate(CURVE, priKeyIn);
        byte[] encoded = point.getEncoded(false);
        return Arrays.copyOfRange(encoded, 1, encoded.length);
    }
}

