/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.block.BlockHeader;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class BlockHeaderProof
extends MychainObject {
    byte[] proof;
    BlockHeader blockHeader;

    public BlockHeaderProof(byte[] proof, BlockHeader blockHeader) {
        this.proof = proof;
        this.blockHeader = blockHeader;
    }

    public BlockHeaderProof() {
    }

    public byte[] getProof() {
        return this.proof;
    }

    public void setProof(byte[] proof) {
        this.proof = proof;
    }

    public BlockHeader getBlockHeader() {
        return this.blockHeader;
    }

    public void setBlockHeader(BlockHeader blockHeader) {
        this.blockHeader = blockHeader;
    }

    @Override
    public byte[] toRlp() {
        return Rlp.encodeList(Rlp.encodeElement(this.proof), this.blockHeader.toRlp());
    }

    @Override
    public void fromRlp(RlpList list) {
        this.proof = ((RlpElement)list.get(0)).getRlpData();
        this.blockHeader = new BlockHeader();
        this.blockHeader.fromRlp((RlpList)list.get(1));
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("block_proof", (Object)ByteUtils.toHexString(this.proof));
        JSONObject object = new JSONObject();
        this.blockHeader.toJson(object);
        jsonObject.put("block_header", (Object)object);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.proof = ByteUtils.hexStringToBytes(jsonObject.getString("block_proof"));
        this.blockHeader = new BlockHeader();
        this.blockHeader.fromJson(jsonObject.getJSONObject("block_header"));
    }
}

