/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.exception;

import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.errorcode.IErrorCode;

public class MychainSdkException
extends RuntimeException {
    private IErrorCode errorCode;
    private String errorMessage;

    public MychainSdkException(IErrorCode errorCode, String errorMessage, Throwable e) {
        super(errorMessage, e);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public MychainSdkException(IErrorCode errorCode, String errorMessage) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public MychainSdkException(IErrorCode errorCode) {
        super(errorCode.getErrorDesc());
        this.errorCode = errorCode;
        this.errorMessage = errorCode.getErrorDesc();
    }

    public static void throwInvalidParameters(String msg) {
        throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, msg);
    }

    public static void throwInvalidParameters() {
        throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "parameters should be valid");
    }

    public static void throwNullParameters() {
        throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "parameters should not be null");
    }

    public IErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

