/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.transaction.TransactionReceipt;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryTransactionReceiptResponse
extends Response {
    private TransactionReceipt transactionReceipt;
    private BigInteger blockNumber = BigInteger.ZERO;
    private int txIndex = 0;

    public QueryTransactionReceiptResponse() {
        super(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_RECEIPT);
    }

    public QueryTransactionReceiptResponse(TransactionReceipt receipt, BigInteger blockNumber, int txIndex) {
        super(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION_RECEIPT);
        this.transactionReceipt = receipt;
        this.blockNumber = blockNumber;
        this.txIndex = txIndex;
    }

    public TransactionReceipt getTransactionReceipt() {
        return this.transactionReceipt;
    }

    public void setTransactionReceipt(TransactionReceipt transactionReceipt) {
        this.transactionReceipt = transactionReceipt;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public int getTxIndex() {
        return this.txIndex;
    }

    public void setTxIndex(int txIndex) {
        this.txIndex = txIndex;
    }

    @Override
    public byte[] toRlp() {
        byte[] receiptBytes = this.transactionReceipt.toRlp();
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNumber);
        byte[] indexBytes = Rlp.encodeInt(this.txIndex);
        return Rlp.encodeList(super.toRlp(), receiptBytes, blockNumberBytes, indexBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.transactionReceipt = new TransactionReceipt();
        this.transactionReceipt.fromRlp((RlpList)list.get(1));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
        this.txIndex = ByteUtils.byteArrayToInt(((RlpElement)list.get(3)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONObject object = new JSONObject();
        this.transactionReceipt.toJson(object);
        jsonObject.put("receipt", (Object)object);
        jsonObject.put("block_number", (Object)this.blockNumber);
        jsonObject.put("transaction_index", (Object)this.txIndex);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.transactionReceipt = new TransactionReceipt();
        this.transactionReceipt.fromJson(jsonObject.getJSONObject("receipt"));
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.txIndex = jsonObject.getIntValue("transaction_index");
    }
}

