/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class QueryTpsLatencyRequest
extends Request {
    private Hash nodeId = new Hash();
    private long startTime = 0L;
    private long endTime = 0L;

    public QueryTpsLatencyRequest() {
        super(MessageType.MSG_TYPE_STATUS_REQ_TPS_LATENCY_METRICS);
    }

    public QueryTpsLatencyRequest(Hash nodeId, long startTime, long endTime) {
        super(MessageType.MSG_TYPE_STATUS_REQ_TPS_LATENCY_METRICS);
        this.nodeId = nodeId;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public QueryTpsLatencyRequest(long startTime, long endTime) {
        super(MessageType.MSG_TYPE_STATUS_REQ_TPS_LATENCY_METRICS);
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Hash getNodeId() {
        return this.nodeId;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.nodeId != null && (this.endTime > this.startTime || this.endTime == this.startTime && this.startTime == 0L);
    }

    @Override
    public byte[] toRlp() {
        byte[] node_id = Rlp.encodeElement(this.nodeId.getValue());
        byte[] start_time = Rlp.encodeLong(this.startTime);
        byte[] end_time = Rlp.encodeLong(this.endTime);
        return Rlp.encodeList(super.toRlp(), node_id, start_time, end_time);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.nodeId = new Hash(((RlpElement)list.get(1)).getRlpData());
        this.startTime = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.endTime = ByteUtils.byteArrayToLong(((RlpElement)list.get(3)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("node_id", (Object)ByteUtils.toHexString(this.nodeId.getValue()));
        jsonObject.put("start_time", (Object)this.startTime);
        jsonObject.put("end_time", (Object)this.endTime);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.nodeId = new Hash(jsonObject.getString("node_id"));
        this.startTime = jsonObject.getLong("start_time");
        this.endTime = jsonObject.getLong("end_time");
    }
}

