/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.contract;

import com.alipay.mychain.sdk.common.Parameters;
import com.alipay.mychain.sdk.common.VMTypeEnum;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.math.BigInteger;

public class CallContractRequest
extends AbstractTransactionRequest {
    private Identity acctId;
    private Identity contractId;
    private Parameters parameters;
    private BigInteger value = BigInteger.ZERO;
    private VMTypeEnum vmTypeEnum = VMTypeEnum.EVM;

    public CallContractRequest(Identity acctId, Identity contractId, Parameters parameters, BigInteger value, VMTypeEnum vmTypeEnum) {
        super(MessageType.MSG_TYPE_TX_REQ_CONTRACT_CALL);
        this.acctId = acctId;
        this.contractId = contractId;
        this.parameters = parameters;
        this.value = value;
        this.vmTypeEnum = vmTypeEnum;
    }

    public CallContractRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_CONTRACT_CALL);
    }

    public Identity getAcctId() {
        return this.acctId;
    }

    public Identity getContractId() {
        return this.contractId;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public VMTypeEnum getVmTypeEnum() {
        return this.vmTypeEnum;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.acctId != null && !this.acctId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.contractId != null && !this.contractId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.parameters != null;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.CALL_CONTRACT);
        transaction.setFrom(this.acctId);
        transaction.setTo(this.contractId);
        transaction.setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.value));
        transaction.setData(this.parameters.getData());
        super.complete();
    }
}

