/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.envelope;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.PublicKey;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class CreateGroupRequest
extends Request {
    private PublicKey publicKey;
    private Identity from;

    public CreateGroupRequest(PublicKey publicKey, Identity from) {
        super(MessageType.MSG_TYPE_TX_REQ_CREATE_GROUP);
        this.publicKey = publicKey;
        this.from = from;
    }

    public CreateGroupRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_CREATE_GROUP);
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public Identity getFrom() {
        return this.from;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.from != null && !this.from.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.publicKey != null;
    }

    @Override
    public byte[] toRlp() {
        byte[] fromBytes = Rlp.encodeElement(this.from.getValue());
        byte[] publicKeyBytes = Rlp.encodeElement(this.publicKey.getValue());
        return Rlp.encodeList(super.toRlp(), fromBytes, publicKeyBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.from = new Identity(((RlpElement)list.get(1)).getRlpData());
        this.publicKey = new PublicKey(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("from", (Object)ByteUtils.toHexString(this.getFrom().getValue()));
        jsonObject.put("anonymous_public_key", (Object)ByteUtils.toHexString(this.getPublicKey().getValue()));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.from = new Identity(jsonObject.getString("from"));
        this.publicKey = new PublicKey(jsonObject.getString("anonymous_public_key"));
    }
}

