/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network;

import com.alipay.mychain.sdk.utils.ByteUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class PacketHead {
    public static final int PACKET_HEADER_LENGTH = 16;
    public static final int NUM_VERSION_BITS = 12;
    public static final int NUM_COMPRESSED_BITS = 4;
    public static final int PACKET_MAGIC1 = 51;
    public static final int PACKET_MAGIC2 = 119;
    public static final int PACKET_RESERVED1 = 0;
    public static final int PACKET_RESERVED2 = 0;
    private int totalLen = 0;
    private int version = 2;
    private int compressed = 0;
    private int magic1 = 51;
    private int magic2 = 119;
    private int reserved1 = 0;
    private int reserved2 = 0;

    public static PacketHead fromBytes(byte[] data) {
        PacketHead packetHead = new PacketHead();
        packetHead.setTotalLen(ByteUtils.bytesToInt(Arrays.copyOfRange(data, 0, 4)));
        packetHead.setVersion(data[4]);
        packetHead.setCompressed(data[5]);
        packetHead.setMagic1(Arrays.copyOfRange(data, 6, 7)[0]);
        packetHead.setMagic2(Arrays.copyOfRange(data, 7, 8)[0]);
        packetHead.setReserved1(ByteUtils.byteArrayToInt(Arrays.copyOfRange(data, 8, 12)));
        packetHead.setReserved2(ByteUtils.byteArrayToInt(Arrays.copyOfRange(data, 12, 16)));
        return packetHead;
    }

    public static byte[] toBytes(byte[] msg) {
        PacketHead packetHead = new PacketHead();
        packetHead.setTotalLen(16 + msg.length);
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        int t = packetHead.getVersion() | packetHead.getCompressed() << 12;
        byteBuffer.put(ByteUtils.intToBytes(packetHead.getTotalLen()));
        byte b = (byte)(t >> 8);
        byteBuffer.put(b);
        b = (byte)(t & 0xF);
        byteBuffer.put(b);
        b = (byte)packetHead.getMagic1();
        byteBuffer.put(b);
        b = (byte)packetHead.getMagic2();
        byteBuffer.put(b);
        byteBuffer.put(ByteUtils.intToBytes(packetHead.getReserved1()));
        byteBuffer.put(ByteUtils.intToBytes(packetHead.getReserved2()));
        return byteBuffer.array();
    }

    public boolean verify() {
        return this.magic1 == 51 && this.magic2 == 119 && this.reserved1 == 0 && this.reserved2 == 0 && this.totalLen > 16;
    }

    public int getTotalLen() {
        return this.totalLen;
    }

    public void setTotalLen(int totalLen) {
        this.totalLen = totalLen;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCompressed() {
        return this.compressed;
    }

    public void setCompressed(int compressed) {
        this.compressed = compressed;
    }

    public int getMagic1() {
        return this.magic1;
    }

    public void setMagic1(int magic1) {
        this.magic1 = magic1;
    }

    public int getMagic2() {
        return this.magic2;
    }

    public void setMagic2(int magic2) {
        this.magic2 = magic2;
    }

    public int getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(int reserved1) {
        this.reserved1 = reserved1;
    }

    public int getReserved2() {
        return this.reserved2;
    }

    public void setReserved2(int reserved2) {
        this.reserved2 = reserved2;
    }
}

