/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network.netty;

import com.alipay.mychain.sdk.api.env.ISslOption;
import com.alipay.mychain.sdk.api.env.NetworkOption;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.network.netty.ClientInitializer;
import com.alipay.mychain.sdk.network.netty.IChannelHandler;
import com.alipay.mychain.sdk.network.netty.ITransport;
import com.alipay.mychain.sdk.utils.ExecutorUtils;
import com.alipay.mychain.sdk.utils.SocketAddressUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractClientTransport
implements ITransport {
    private static final String IO_POOL_NAME = "WorkThreadPool";
    private static final String CONNECT_POOL_NAME = "ConnectThreadPool";
    protected NetworkOption networkOption;
    protected ISslOption sslOption;
    protected ILogger logger;
    protected Channel channel;
    private Map<String, IChannelHandler> channelHandlers = new LinkedHashMap<String, IChannelHandler>();
    private Bootstrap bootstrap;
    private EventLoopGroup eventLoopGroup;
    private DefaultEventExecutor connectExecutor;

    public AbstractClientTransport(NetworkOption networkOption, ISslOption sslOption, ILogger logger) {
        this.networkOption = networkOption;
        this.sslOption = sslOption;
        this.logger = logger;
        this.init();
    }

    private void init() {
        this.eventLoopGroup = new NioEventLoopGroup(this.networkOption.getCoreThreadPoolSize().intValue(), (ThreadFactory)new DefaultThreadFactory(IO_POOL_NAME, true));
        this.connectExecutor = new DefaultEventExecutor(ExecutorUtils.getNamedThreadFactory(CONNECT_POOL_NAME));
        this.bootstrap = new Bootstrap();
    }

    protected void addChannelHandler(String name, IChannelHandler channelHandler) {
        this.channelHandlers.put(name, channelHandler);
    }

    public <T> AbstractClientTransport option(ChannelOption<T> option, T value) {
        this.bootstrap.option(option, value);
        return this;
    }

    @Override
    public void open() {
        ((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ClientInitializer(this.channelHandlers));
    }

    @Override
    public void close() throws IOException {
        if (this.connectExecutor != null) {
            this.connectExecutor.shutdownGracefully();
        }
        if (this.eventLoopGroup != null) {
            this.eventLoopGroup.shutdownGracefully();
        }
    }

    @Override
    public boolean connect(final InetSocketAddress address, int timeout) {
        final Promise responsePromise = this.connectExecutor.newPromise();
        this.logger.debug("connect to {} by async", (Object)SocketAddressUtil.parseAddress(address));
        if (!this.connectExecutor.isShuttingDown()) {
            this.connectExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        ChannelFuture channelFuture = AbstractClientTransport.this.bootstrap.connect((SocketAddress)address).sync();
                        if (channelFuture.isSuccess()) {
                            AbstractClientTransport.this.logger.debug("connect to {} success.", (Object)SocketAddressUtil.parseAddress(address));
                            responsePromise.trySuccess((Object)channelFuture.channel());
                        } else {
                            AbstractClientTransport.this.logger.error("connect to {} failed, cause: {}", (Object)SocketAddressUtil.parseAddress(address), (Object)channelFuture.cause());
                            responsePromise.tryFailure(channelFuture.cause());
                        }
                    }
                    catch (Exception e) {
                        AbstractClientTransport.this.logger.error("connect to {} failed, cause: {}", (Object)SocketAddressUtil.parseAddress(address), (Object)ExceptionUtils.getStackTrace((Throwable)e));
                        responsePromise.tryFailure((Throwable)e);
                    }
                }
            });
        }
        if (responsePromise.awaitUninterruptibly((long)timeout)) {
            try {
                this.channel = (Channel)responsePromise.get();
                this.logger.info("connect to {}, async, success", (Object)SocketAddressUtil.parseAddress(address));
                return true;
            }
            catch (InterruptedException e) {
                this.logger.error("InterruptedException", e);
            }
            catch (ExecutionException e) {
                this.logger.error("ExecutionException", e);
            }
        }
        return false;
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    protected abstract void initChannelHandlers();

    protected void configTransport() {
        this.option(ChannelOption.SO_SNDBUF, this.networkOption.getMaxMessageSize());
        this.option(ChannelOption.SO_RCVBUF, this.networkOption.getMaxMessageSize());
        this.option(ChannelOption.TCP_NODELAY, true);
        this.option(ChannelOption.SO_KEEPALIVE, true);
    }
}

