/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.annotation.privacy;

import com.alipay.mychain.zoro.annotation.privacy.EncryptedTuple;
import com.alipay.mychain.zoro.annotation.privacy.Note;
import com.alipay.mychain.zoro.annotation.privacy.PlainTuple;
import com.alipay.mychain.zoro.crypto.BulletProof;
import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.enums.ZoroErrorCodeEnum;
import com.alipay.mychain.zoro.envelop.EnvelopeEnc;
import com.alipay.mychain.zoro.exception.ZoroException;
import com.alipay.mychain.zoro.util.Base64Codec;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Verification {
    private static final Logger logger = LoggerFactory.getLogger(Verification.class);

    public static Note computeCommitmentChange(byte[] pedersenCommitment, byte[] blindFactor, long value, byte[] keyName, byte[] password, List<? extends EncryptedTuple> positiveTuples, List<? extends EncryptedTuple> negativeTuples) {
        byte[] tempPC;
        byte[] blindFactorSum;
        Note note = new Note();
        ArrayList<byte[]> positiveBlindList = new ArrayList<byte[]>();
        ArrayList<byte[]> negativeBlindList = new ArrayList<byte[]>();
        long valueSum = value;
        positiveBlindList.add(blindFactor);
        if (positiveTuples != null) {
            for (EncryptedTuple encryptedTuple : positiveTuples) {
                Vector<byte[]> positivePlaintextVector;
                if (encryptedTuple.getBindFactor() == null || encryptedTuple.getEnvelope() == null || encryptedTuple.getValue() == null) {
                    logger.error("Null elements in Positive Tuple");
                    throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Null elements in Positive Tuple");
                }
                Vector<byte[]> positiveCipherVector = new Vector<byte[]>();
                positiveCipherVector.add(Base64Codec.decode(encryptedTuple.getBindFactor()));
                positiveCipherVector.add(Base64Codec.decode(encryptedTuple.getValue()));
                try {
                    positivePlaintextVector = EnvelopeEnc.decrypt(keyName, password, Base64Codec.decode(encryptedTuple.getEnvelope()), positiveCipherVector);
                }
                catch (Exception e) {
                    logger.error("Envelope Decryption Error", (Throwable)e);
                    throw new ZoroException(ZoroErrorCodeEnum.ENVELOPE_DECRYPT_FAILED, e.getMessage());
                }
                String blindPosString = new String(positivePlaintextVector.get(0), StandardCharsets.UTF_8);
                byte[] blindPosBytes = Base64Codec.decode(blindPosString);
                positiveBlindList.add(blindPosBytes);
                String valuePosString = new String(positivePlaintextVector.get(1), StandardCharsets.UTF_8);
                valueSum += Long.valueOf(valuePosString).longValue();
            }
        }
        if (negativeTuples != null) {
            for (EncryptedTuple encryptedTuple : negativeTuples) {
                Vector<byte[]> negativePlaintextVector;
                if (encryptedTuple.getBindFactor() == null || encryptedTuple.getEnvelope() == null || encryptedTuple.getValue() == null) {
                    throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Null elements in negative Tuple");
                }
                Vector<byte[]> negativeCipherVector = new Vector<byte[]>();
                negativeCipherVector.add(Base64Codec.decode(encryptedTuple.getBindFactor()));
                negativeCipherVector.add(Base64Codec.decode(encryptedTuple.getValue()));
                try {
                    negativePlaintextVector = EnvelopeEnc.decrypt(keyName, password, Base64Codec.decode(encryptedTuple.getEnvelope()), negativeCipherVector);
                }
                catch (Exception e) {
                    logger.error("Envelope Decryption Error", (Throwable)e);
                    throw new ZoroException(ZoroErrorCodeEnum.ENVELOPE_DECRYPT_FAILED, e.getMessage());
                }
                String blindNegString = new String(negativePlaintextVector.get(0), StandardCharsets.UTF_8);
                byte[] blindNegBytes = Base64Codec.decode(blindNegString);
                negativeBlindList.add(blindNegBytes);
                String valueNegString = new String(negativePlaintextVector.get(1), StandardCharsets.UTF_8);
                valueSum -= Long.valueOf(valueNegString).longValue();
            }
        }
        try {
            blindFactorSum = BulletProof.addBlindFactors(positiveBlindList, negativeBlindList);
        }
        catch (CryptoException e) {
            logger.error("Blind Factors Addition Error", (Throwable)e);
            throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_SUBTRACTION_FAILED, e.getMessage());
        }
        try {
            tempPC = BulletProof.generateCommit(blindFactorSum, valueSum);
        }
        catch (CryptoException e) {
            logger.error("Generate Pedersen Commitment Failed", (Throwable)e);
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_GENERATION_FAILED, e.getMessage());
        }
        if (!Arrays.equals(tempPC, pedersenCommitment)) {
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_NOT_MATCHED, "Calculated PC Does Not equal To Input Commitment");
        }
        note.setPedersenCommitment(Base64Codec.encode(tempPC));
        note.setBlindFactor(Base64Codec.encode(blindFactorSum));
        note.setValue(valueSum);
        return note;
    }

    public static Note computeCommitmentChange(String commitment, String blindFactor, long value, List<? extends PlainTuple> positiveTuples, List<? extends PlainTuple> negativeTuples) {
        boolean bl;
        byte[] totalBlindFactor;
        byte[] endCommitment = Base64Codec.decode(commitment);
        byte[] startBlindFactor = Base64Codec.decode(blindFactor);
        ArrayList<byte[]> positiveList = new ArrayList<byte[]>();
        positiveList.add(startBlindFactor);
        long totalValue = value;
        ArrayList<byte[]> negativeList = null;
        if (positiveTuples != null) {
            for (PlainTuple plainTuple : positiveTuples) {
                if (plainTuple.getBindFactor() == null) {
                    throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Null elements in Positive Tuple");
                }
                positiveList.add(Base64Codec.decode(plainTuple.getBindFactor()));
                totalValue += plainTuple.getValue();
            }
        }
        if (negativeTuples != null) {
            negativeList = new ArrayList<byte[]>();
            for (PlainTuple plainTuple : negativeTuples) {
                if (plainTuple.getBindFactor() == null) {
                    throw new ZoroException(ZoroErrorCodeEnum.INVALID_PARAMETER, "Null elements in Negative Tuple");
                }
                negativeList.add(Base64Codec.decode(plainTuple.getBindFactor()));
                totalValue -= plainTuple.getValue();
            }
        }
        try {
            totalBlindFactor = BulletProof.addBlindFactors(positiveList, negativeList);
        }
        catch (Exception exception) {
            logger.error("Blind Factors Addition Error", (Throwable)exception);
            throw new ZoroException(ZoroErrorCodeEnum.BLIND_FACTOR_SUBTRACTION_FAILED, exception.getMessage());
        }
        boolean bl2 = false;
        try {
            bl = BulletProof.verifyCommit(endCommitment, totalBlindFactor, totalValue);
        }
        catch (Exception ex) {
            logger.error("Pedersen commitment varify failed", (Throwable)ex);
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_NOT_MATCHED, ex.getMessage());
        }
        if (!bl) {
            throw new ZoroException(ZoroErrorCodeEnum.COMMITMENT_NOT_MATCHED, "Calculated PC Does Not equal To Input Commitment");
        }
        Note note = new Note();
        note.setPedersenCommitment(commitment);
        note.setBlindFactor(Base64Codec.encode(totalBlindFactor));
        note.setValue(totalValue);
        return note;
    }
}

