/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.ecdsa;

import com.alipay.mychain.zoro.crypto.ecdsa.ECSignUtils;
import com.alipay.mychain.zoro.crypto.ecdsa.ISignature;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequenceGenerator;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.util.Properties;

public class ECDSASignature
implements ISignature {
    private static final Logger logger = Logger.getLogger(ECDSASignature.class.getName());
    public final BigInteger r;
    public final BigInteger s;

    public ECDSASignature(BigInteger r, BigInteger s) {
        this.r = r;
        this.s = s;
    }

    public boolean isCanonical() {
        return this.s.compareTo(ECSignUtils.HALF_CURVE_ORDER) <= 0;
    }

    public ECDSASignature toCanonicalised() {
        if (!this.isCanonical()) {
            return new ECDSASignature(this.r, ECSignUtils.CURVE.getN().subtract(this.s));
        }
        return this;
    }

    public byte[] encodeToDER() {
        try {
            return this.derByteStream().toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ECDSASignature decodeFromDER(byte[] bytes) throws IllegalArgumentException {
        ASN1InputStream decoder = null;
        try {
            ASN1Integer s;
            ASN1Integer r;
            Properties.setThreadOverride((String)"org.bouncycastle.asn1.allow_unsafe_integer", (boolean)true);
            decoder = new ASN1InputStream(bytes);
            ASN1Primitive seqObj = decoder.readObject();
            if (seqObj == null) {
                throw new IllegalArgumentException("Reached past end of ASN.1 stream.");
            }
            if (!(seqObj instanceof DLSequence)) {
                throw new IllegalArgumentException("Read unexpected class: " + seqObj.getClass().getName());
            }
            DLSequence seq = (DLSequence)seqObj;
            try {
                r = (ASN1Integer)seq.getObjectAt(0);
                s = (ASN1Integer)seq.getObjectAt(1);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(e);
            }
            ECDSASignature eCDSASignature = new ECDSASignature(r.getPositiveValue(), s.getPositiveValue());
            return eCDSASignature;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (decoder != null) {
                try {
                    decoder.close();
                }
                catch (IOException x) {
                    logger.log(Level.SEVERE, x.getMessage(), x);
                }
            }
            Properties.removeThreadOverride((String)"org.bouncycastle.asn1.allow_unsafe_integer");
        }
    }

    protected ByteArrayOutputStream derByteStream() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(72);
        DERSequenceGenerator seq = new DERSequenceGenerator((OutputStream)bos);
        seq.addObject((ASN1Encodable)new ASN1Integer(this.r));
        seq.addObject((ASN1Encodable)new ASN1Integer(this.s));
        seq.close();
        return bos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECDSASignature other = (ECDSASignature)o;
        return this.r.equals(other.r) && this.s.equals(other.s);
    }
}

