/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.bloom;

import com.alipay.mychain.sdk.utils.ByteUtils;
import java.io.Serializable;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;

public class BloomFilter
implements Serializable {
    private static final int STEPS_8 = 8;
    private static final int LOW_3_BITS = 7;
    private static final int ENSURE_BYTE = 255;
    private int expectedNumberOfFilterElements = 0;
    private int numberOfAddedElements;
    private int k = 3;
    private int bitSetSize = 2048;
    private BitSet bitset = new BitSet(this.bitSetSize);

    public BloomFilter(byte[] bloom) {
        ArrayUtils.reverse((byte[])bloom);
        this.bitset = BitSet.valueOf(bloom);
    }

    public BloomFilter() {
        this.numberOfAddedElements = 0;
    }

    public void setBitset(BitSet bitset) {
        this.bitset = bitset;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BloomFilter other = (BloomFilter)obj;
        if (this.expectedNumberOfFilterElements != other.expectedNumberOfFilterElements) {
            return false;
        }
        if (this.k != other.k) {
            return false;
        }
        if (this.bitSetSize != other.bitSetSize) {
            return false;
        }
        return this.bitset == other.bitset || this.bitset != null && this.bitset.equals(other.bitset);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + (this.bitset != null ? this.bitset.hashCode() : 0);
        hash = 61 * hash + this.expectedNumberOfFilterElements;
        hash = 61 * hash + this.bitSetSize;
        hash = 61 * hash + this.k;
        return hash;
    }

    public double expectedFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.expectedNumberOfFilterElements);
    }

    public double getFalsePositiveProbability(double numberOfElements) {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * numberOfElements / (double)this.bitSetSize), this.k);
    }

    public double getFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.numberOfAddedElements);
    }

    public int getK() {
        return this.k;
    }

    public synchronized void clear() {
        this.bitset.clear();
        this.numberOfAddedElements = 0;
    }

    public synchronized void add(byte[] bytes) {
        int[] hashes;
        for (int hash : hashes = this.createHashes(bytes, this.k)) {
            this.bitset.set(Math.abs(hash % this.bitSetSize), true);
        }
        ++this.numberOfAddedElements;
    }

    private int[] createHashes(byte[] bytes, int k) {
        int[] ret = new int[k];
        if (bytes.length / 4 < k) {
            int[] maxHashes = new int[bytes.length / 4];
            ByteUtils.bytesToInts(bytes, maxHashes, false);
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = maxHashes[i % maxHashes.length];
            }
        } else {
            this.generateRet(bytes, ret);
        }
        return ret;
    }

    private void generateRet(byte[] toBloom, int[] ret) {
        ret[0] = ((toBloom[0] & 0xFF & 7) << 8) + (toBloom[1] & 0xFF);
        ret[1] = ((toBloom[2] & 0xFF & 7) << 8) + (toBloom[3] & 0xFF);
        ret[2] = ((toBloom[4] & 0xFF & 7) << 8) + (toBloom[5] & 0xFF);
    }

    public synchronized boolean contains(byte[] bytes) {
        int[] hashes;
        for (int hash : hashes = this.createHashes(bytes, this.k)) {
            if (this.bitset.get(Math.abs(hash % this.bitSetSize))) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean getBit(int bit) {
        return this.bitset.get(bit);
    }

    public synchronized void setBit(int bit, boolean value) {
        this.bitset.set(bit, value);
    }

    public synchronized BitSet getBitSet() {
        return this.bitset;
    }

    public synchronized int size() {
        return this.bitSetSize;
    }

    public synchronized int count() {
        return this.numberOfAddedElements;
    }

    public int getExpectedNumberOfElements() {
        return this.expectedNumberOfFilterElements;
    }
}

