/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.crypto.pkeycipher.RSAPkeyCipherV0;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAEnvelopeSGX
implements EnvelopeBase {
    private static final int SGX_IV_LEN = 12;
    private static final int SGX_AUTHTAG_LEN = 16;
    private static final int RSA_2048_BLOCK_SIZE = 256;
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase privkey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_RSA_LOCAL_SGX;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() > 0;
    }

    @Override
    public boolean isDecryptor() {
        return this.privkey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pkeyCipherList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_RSA_OAEP_LOCAL_V0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pubkeyList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            RSAPkeyCipherV0 pkeyCipher = new RSAPkeyCipherV0(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_CIPHER_RSA_OAEP_LOCAL_V0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = pkeyCipher;
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_RSA2048_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = new RSAPkeyCipherV0(keypair);
    }

    @Override
    public byte[] envelopeSeal(byte[] plainText, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Random rnd = new Random();
            if (secretKey == null) {
                secretKey = new byte[16];
                rnd.nextBytes(secretKey);
            }
            SecretKeySpec skey = new SecretKeySpec(secretKey, "AES");
            Cipher aesCipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            byte[] iv = new byte[12];
            rnd.nextBytes(iv);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            aesCipher.init(1, (Key)skey, gcmSpec);
            byte[] gcmCipherText = aesCipher.doFinal(plainText);
            byte[] gcmCipherTextWithouTag = Arrays.copyOfRange(gcmCipherText, 0, gcmCipherText.length - 16);
            byte[] authtag = Arrays.copyOfRange(gcmCipherText, gcmCipherTextWithouTag.length, gcmCipherText.length);
            int pubkeyNr = this.pubkeyList.size();
            int skeyCipherLength = 256 * pubkeyNr;
            byte[] output = new byte[2 + skeyCipherLength + iv.length + authtag.length + gcmCipherTextWithouTag.length];
            int index = 2;
            for (PkeyCipherBase publicKey : this.pubkeyList) {
                byte[] encryptedSkey = publicKey.encrypt(secretKey);
                System.arraycopy(encryptedSkey, 0, output, index, encryptedSkey.length);
                index += encryptedSkey.length;
            }
            output[0] = (byte)(pubkeyNr >> 8 & 0xFF);
            output[1] = (byte)(pubkeyNr & 0xFF);
            System.arraycopy(iv, 0, output, index, iv.length);
            System.arraycopy(authtag, 0, output, index += iv.length, authtag.length);
            System.arraycopy(gcmCipherTextWithouTag, 0, output, index += authtag.length, gcmCipherTextWithouTag.length);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (BadPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchProviderException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IllegalBlockSizeException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] envelopeOpen(byte[] cipherText, byte[] secretKey) {
        if (!this.isDecryptor() && secretKey == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        if (cipherText == null || cipherText.length < 2) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text!");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key!");
        }
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            int skeyCipherLength = 256;
            int pubkeyNr = ((cipherText[0] & 0xFF) << 8) + (cipherText[1] & 0xFF);
            if (pubkeyNr == 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key number!");
            }
            int start = 2 + pubkeyNr * skeyCipherLength;
            int aesCipherTextLen = cipherText.length - start - 12 - 16;
            if (aesCipherTextLen <= 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text, need at least " + (start + 12 + 16 + 1) + "bytes");
            }
            byte[] iv = Arrays.copyOfRange(cipherText, start, start + 12);
            byte[] aesCipherText = new byte[aesCipherTextLen + 16];
            System.arraycopy(cipherText, start + 12 + 16, aesCipherText, 0, aesCipherTextLen);
            System.arraycopy(cipherText, start + 12, aesCipherText, aesCipherTextLen, 16);
            if (secretKey == null) {
                for (int i = 0; i < pubkeyNr; ++i) {
                    try {
                        byte[] encryptedSkey = Arrays.copyOfRange(cipherText, 2 + i * skeyCipherLength, 2 + i * skeyCipherLength + skeyCipherLength);
                        secretKey = this.privkey.decrypt(encryptedSkey);
                        break;
                    }
                    catch (Exception e) {
                        if (i != pubkeyNr - 1) continue;
                        throw new MychainSdkException(ErrorCode.OTHERS, "no matching encrypted skey");
                    }
                }
            }
            if (secretKey == null || secretKey.length != 16) {
                throw new MychainSdkException(ErrorCode.OTHERS, "no matching encrypted skey");
            }
            SecretKeySpec skey = new SecretKeySpec(secretKey, "AES");
            Cipher aesCipher = Cipher.getInstance("AES/GCM/NoPadding", "BC");
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            aesCipher.init(2, (Key)skey, gcmSpec);
            byte[] plainText = aesCipher.doFinal(aesCipherText);
            return plainText;
        }
        catch (NoSuchAlgorithmException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidKeyException e) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (BadPaddingException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (NoSuchProviderException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (IllegalBlockSizeException e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

