/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.hash;

import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.crypto.hash.IHash;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM3Hash
implements IHash {
    @Override
    public HashTypeEnum getHashType() {
        return HashTypeEnum.SM3;
    }

    @Override
    public byte[] hash(byte[] data) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            MessageDigest digest = MessageDigest.getInstance("SM3", "BC");
            digest.reset();
            return digest.digest(data);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        catch (NoSuchProviderException e) {
            return null;
        }
    }
}

