/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.keypair;

public enum KeyTypeEnum {
    UNKNOWN(0),
    KEY_ECCK1_PKCS8(1),
    KEY_ECCR1_PKCS8(2),
    KEY_SM2_PKCS8(3),
    KEY_RSA2048_PKCS8(4);

    public static final int MAX_KEY_TYPE_PKCS8 = 1000;
    private int value;

    private KeyTypeEnum(int value) {
        this.value = value;
    }

    public static KeyTypeEnum valueOf(int value) {
        for (KeyTypeEnum e : KeyTypeEnum.values()) {
            if (e.value != value) continue;
            return e;
        }
        return UNKNOWN;
    }

    public static KeyTypeEnum valueOf(byte[] bytes) {
        if (bytes.length < 2) {
            return UNKNOWN;
        }
        int value = ((bytes[0] & 0xFF) << 8) + (bytes[1] & 0xFF);
        return KeyTypeEnum.valueOf(value);
    }

    public int getValue() {
        return this.value;
    }

    public byte[] toBytes() {
        int value = this.value;
        byte[] bytes = new byte[]{(byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return bytes;
    }
}

