/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.block.BlockBody;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class BlockBodyInfo
extends MychainObject {
    private Hash blockHash;
    private BlockBody body;

    public BlockBodyInfo() {
    }

    public BlockBodyInfo(Hash blockHash, BlockBody body) {
        this.blockHash = blockHash;
        this.body = body;
    }

    public Hash getBlockHash() {
        return this.blockHash;
    }

    public void setBlockHash(Hash blockHash) {
        this.blockHash = blockHash;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public void setBody(BlockBody body) {
        this.body = body;
    }

    @Override
    public byte[] toRlp() {
        byte[] blockHashBytes = Rlp.encodeElement(this.blockHash.getValue());
        byte[] bodyBytes = this.body.toRlp();
        return Rlp.encodeList(blockHashBytes, bodyBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.blockHash = new Hash(((RlpElement)list.get(0)).getRlpData());
        this.body = new BlockBody();
        this.body.fromRlp((RlpList)list.get(1));
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("block_hash", (Object)ByteUtils.toHexString(this.blockHash.getValue()));
        JSONObject object = new JSONObject();
        this.body.toJson(object);
        jsonObject.put("body", (Object)object);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.blockHash = new Hash(jsonObject.getString("block_hash"));
        this.body = new BlockBody();
        this.body.fromJson(jsonObject.getJSONObject("body"));
    }
}

