/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class EndPoint
extends MychainObject {
    private String ip;
    private int port;

    public EndPoint(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public EndPoint() {
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndPoint endPoint = (EndPoint)o;
        if (this.port != endPoint.port) {
            return false;
        }
        return this.ip != null ? this.ip.equals(endPoint.ip) : endPoint.ip == null;
    }

    public int hashCode() {
        int result = this.ip != null ? this.ip.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    @Override
    public byte[] toRlp() {
        byte[] ipBytes = Rlp.encodeString(this.ip);
        byte[] portBytes = Rlp.encodeInt(this.port);
        return Rlp.encodeList(ipBytes, portBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.ip = ByteUtils.byteArrayToString(((RlpElement)list.get(0)).getRlpData());
        this.port = ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("ip", (Object)this.ip);
        jsonObject.put("port", (Object)this.port);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.ip = jsonObject.getString("ip");
        this.port = jsonObject.getIntValue("port");
    }
}

