/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.domain.status.ConsensusInfo;
import com.alipay.mychain.sdk.domain.status.ConsensusInfoEnum;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class HoneybadgerInfo
extends ConsensusInfo {
    private long n;
    private long f;
    private Hash nodeId;
    private long currentView;
    private long proposeSize;
    private long threads;
    private long normalTimeoutInterval;

    public static HoneybadgerInfo builder(long n, long f, Hash nodeId, long currentView, long proposeSize, long normalTimeoutInterval, long threads) {
        HoneybadgerInfo honeybadgerInfo = new HoneybadgerInfo();
        honeybadgerInfo.n = n;
        honeybadgerInfo.f = f;
        honeybadgerInfo.nodeId = nodeId;
        honeybadgerInfo.currentView = currentView;
        honeybadgerInfo.threads = threads;
        honeybadgerInfo.proposeSize = proposeSize;
        honeybadgerInfo.normalTimeoutInterval = normalTimeoutInterval;
        return honeybadgerInfo;
    }

    public long getN() {
        return this.n;
    }

    public void setN(long n) {
        this.n = n;
    }

    public long getF() {
        return this.f;
    }

    public void setF(long f) {
        this.f = f;
    }

    public Hash getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Hash nodeId) {
        this.nodeId = nodeId;
    }

    public long getCurrentView() {
        return this.currentView;
    }

    public void setCurrentView(long currentView) {
        this.currentView = currentView;
    }

    public long getProposeSize() {
        return this.proposeSize;
    }

    public void setProposeSize(long proposeSize) {
        this.proposeSize = proposeSize;
    }

    public long getThreads() {
        return this.threads;
    }

    public void setThreads(long threads) {
        this.threads = threads;
    }

    public long getNormalTimeoutInterval() {
        return this.normalTimeoutInterval;
    }

    public void setNormalTimeoutInterval(long normalTimeoutInterval) {
        this.normalTimeoutInterval = normalTimeoutInterval;
    }

    @Override
    public ConsensusInfoEnum getConsensusInfoEnum() {
        return ConsensusInfoEnum.CONSENSUS_INFO_TYPE_HONEYBADGER;
    }

    @Override
    public byte[] toRlp() {
        byte[] nBytes = Rlp.encodeLong(this.n);
        byte[] fBytes = Rlp.encodeLong(this.f);
        byte[] myIdBytes = Rlp.encodeElement(this.nodeId.getValue());
        byte[] currentViewBytes = Rlp.encodeLong(this.currentView);
        byte[] proposeSizeBytes = Rlp.encodeLong(this.proposeSize);
        byte[] threadsBytes = Rlp.encodeLong(this.threads);
        byte[] normalTimeoutIntervalBytes = Rlp.encodeLong(this.normalTimeoutInterval);
        return Rlp.encodeList(super.toRlp(), nBytes, fBytes, myIdBytes, currentViewBytes, proposeSizeBytes, threadsBytes, normalTimeoutIntervalBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.n = ByteUtils.byteArrayToLong(((RlpElement)list.get(1)).getRlpData());
        this.f = ByteUtils.byteArrayToLong(((RlpElement)list.get(2)).getRlpData());
        this.nodeId = new Hash(((RlpElement)list.get(3)).getRlpData());
        this.currentView = ByteUtils.byteArrayToLong(((RlpElement)list.get(4)).getRlpData());
        this.proposeSize = ByteUtils.byteArrayToLong(((RlpElement)list.get(5)).getRlpData());
        this.threads = ByteUtils.byteArrayToLong(((RlpElement)list.get(6)).getRlpData());
        this.normalTimeoutInterval = ByteUtils.byteArrayToLong(((RlpElement)list.get(7)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("n", (Object)this.n);
        jsonObject.put("f", (Object)this.f);
        jsonObject.put("my_id", (Object)ByteUtils.toHexString(this.nodeId.getValue()));
        jsonObject.put("current_view", (Object)this.currentView);
        jsonObject.put("propose_size", (Object)this.proposeSize);
        jsonObject.put("threads", (Object)this.threads);
        jsonObject.put("normal_timeout_interval", (Object)this.normalTimeoutInterval);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.n = jsonObject.getLong("n");
        this.f = jsonObject.getLong("f");
        this.nodeId = new Hash(jsonObject.getString("my_id"));
        this.currentView = jsonObject.getLong("current_view");
        this.proposeSize = jsonObject.getLong("propose_size");
        this.threads = jsonObject.getLong("threads");
        this.normalTimeoutInterval = jsonObject.getLong("normal_timeout_interval");
    }
}

