/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class QueryTransactionResponse
extends Response {
    private Transaction transaction;
    private BigInteger blockNumber = BigInteger.ZERO;
    private int index;

    public QueryTransactionResponse() {
        super(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION);
    }

    public QueryTransactionResponse(Transaction transaction, BigInteger blockNumber, int index) {
        super(MessageType.MSG_TYPE_QUERY_RESP_TRANSACTION);
        this.transaction = transaction;
        this.blockNumber = blockNumber;
        this.index = index;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public BigInteger getBlockNumber() {
        return this.blockNumber;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public byte[] toRlp() {
        byte[] transactionBytes = this.transaction.toRlp();
        byte[] blockNumberBytes = Rlp.encodeBigInteger(this.blockNumber);
        byte[] indexBytes = Rlp.encodeInt(this.index);
        return Rlp.encodeList(super.toRlp(), transactionBytes, blockNumberBytes, indexBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.transaction = new Transaction();
        this.transaction.fromRlp((RlpList)list.get(1));
        this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
        this.index = ByteUtils.byteArrayToInt(((RlpElement)list.get(3)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONObject object = new JSONObject();
        this.transaction.toJson(object);
        jsonObject.put("transaction", (Object)object);
        jsonObject.put("block_number", (Object)this.blockNumber);
        jsonObject.put("transaction_index", (Object)this.index);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.transaction = new Transaction();
        this.transaction.fromJson(jsonObject.getJSONObject("transaction"));
        this.blockNumber = jsonObject.getBigInteger("block_number");
        this.index = jsonObject.getIntValue("transaction_index");
    }
}

