/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction.account;

import com.alipay.mychain.sdk.domain.account.Account;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.domain.transaction.TransactionType;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import java.math.BigInteger;

public class CreateAccountRequest
extends AbstractTransactionRequest {
    private Account account;
    private Identity accountId;
    private BigInteger value = BigInteger.ZERO;

    public CreateAccountRequest() {
        super(MessageType.MSG_TYPE_TX_REQ_ACCOUNT_CREATE);
    }

    public CreateAccountRequest(Account account) {
        super(MessageType.MSG_TYPE_TX_REQ_ACCOUNT_CREATE);
        this.accountId = account.getIdentity();
        this.account = account;
    }

    public CreateAccountRequest(Identity accountId, Account account) {
        super(MessageType.MSG_TYPE_TX_REQ_ACCOUNT_CREATE);
        this.accountId = accountId;
        this.account = account;
    }

    public CreateAccountRequest(Identity accountId, Account account, BigInteger value) {
        super(MessageType.MSG_TYPE_TX_REQ_ACCOUNT_CREATE);
        this.accountId = accountId;
        this.account = account;
        this.value = value;
    }

    public Account getAccount() {
        return this.account;
    }

    public Identity getAccountId() {
        return this.accountId;
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.account != null && this.account.isValid() && this.account.getBalance() == 0L && this.accountId != null && !this.accountId.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.value != null && this.value.intValue() >= 0;
    }

    @Override
    public void complete() {
        Transaction transaction = this.getTransaction();
        transaction.setTxType(TransactionType.CREATE_ACCOUNT);
        transaction.setFrom(this.accountId);
        transaction.setTo(this.account.getIdentity());
        transaction.setData(this.account.toRlp());
        if (this.value.intValue() > 0) {
            this.getTransaction().setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(this.value));
        } else {
            this.getTransaction().setValue(BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.ZERO);
        }
        super.complete();
    }
}

