/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network.netty.handler;

import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.network.netty.INetEventHandler;
import com.alipay.mychain.sdk.utils.SocketAddressUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.ReferenceCounted;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MessageInboundHandler
extends SimpleChannelInboundHandler<Object> {
    private INetEventHandler netEventHandler;
    private ILogger logger;

    public MessageInboundHandler(INetEventHandler netEventHandler, ILogger logger) {
        this.netEventHandler = netEventHandler;
        this.logger = logger;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("channel active: {}", (Object)SocketAddressUtil.parseAddress(ctx.channel().remoteAddress()));
        super.channelActive(ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.logger.debug("channel read: {}", (Object)ctx.toString());
        if (msg instanceof ReferenceCounted) {
            ((ReferenceCounted)msg).retain();
        }
        this.netEventHandler.onMessage(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.logger.debug("channel inactive: {}", (Object)SocketAddressUtil.parseAddress(ctx.channel().remoteAddress()));
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        String localAddress = SocketAddressUtil.parseAddress(ctx.channel().localAddress());
        String remoteAddress = SocketAddressUtil.parseAddress(ctx.channel().remoteAddress());
        this.logger.error("caught exception, local: {}, remote: {}, cause: {}\n{}", localAddress, remoteAddress, cause.getMessage(), ExceptionUtils.getStackTrace((Throwable)cause));
        ctx.channel().close();
    }
}

