/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.ecdsa;

import java.util.Arrays;

public class SignatureData {
    private final byte v;
    private final byte[] r;
    private final byte[] s;

    public SignatureData(byte v, byte[] r, byte[] s) {
        this.v = v;
        this.r = r;
        this.s = s;
    }

    public byte getV() {
        return this.v;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignatureData that = (SignatureData)o;
        if (this.v != that.v) {
            return false;
        }
        if (!Arrays.equals(this.r, that.r)) {
            return false;
        }
        return Arrays.equals(this.s, that.s);
    }

    public int hashCode() {
        int result = this.v;
        result = 31 * result + Arrays.hashCode(this.r);
        result = 31 * result + Arrays.hashCode(this.s);
        return result;
    }

    public static SignatureData decode(byte[] signMessage) {
        byte[] r = new byte[32];
        byte[] s = new byte[32];
        byte v = signMessage[64];
        System.arraycopy(signMessage, 0, r, 0, 32);
        System.arraycopy(signMessage, 32, s, 0, 32);
        return new SignatureData(v, r, s);
    }
}

